/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.passthrough;

import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.I_Mem;
import org.jaymo_lang.object.passthrough.I_PassThrough;
import org.jaymo_lang.object.pseudo.ConstLet;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.ConstEnv;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Function;

public class Const
extends A_Object
implements I_PassThrough,
I_Mem {
    private final String name;
    private final boolean nilable;
    private String initType = null;

    public Const(String name) {
        Err.ifNull((Object)name);
        this.name = name;
        this.nilable = name.endsWith("?");
    }

    @Override
    public I_Object get(CallRuntime cr) {
        I_Object result = cr.vce.cons.get(cr, this);
        if (result == null) {
            throw Lib_Error.memNotInitialized(cr, this);
        }
        return result;
    }

    @Override
    public final String getMemTypeString() {
        return "constant";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    public boolean isInitialized(CallRuntime cr) {
        return cr.vce.cons.isInitialized(this);
    }

    @Override
    public void let(CallRuntime crOld, CallRuntime crNew, I_Object o) {
        this.let(crOld, crNew, o, false);
    }

    @Override
    public void let(CallRuntime crOld, CallRuntime crNew, I_Object o, boolean convert) {
        if (this.initType != null) {
            crNew.vce.cons.setType(crNew, this, this.initType);
            this.initType = null;
        }
        crNew.vce.cons.set(crOld, this, o, this.nilable, convert);
    }

    @Override
    public void setType(String type, DebugInfo debugInfo) {
        this.initType = type;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.name;
            }
        }
        Err.ifNull((Object)cr);
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        ConstEnv ve = cr.vce.cons;
        if (ve.isInitialized(this)) {
            I_Object data = ve.get(cr, this);
            sb.append('[');
            sb.append(data.toString(cr, STYPE.IDENT));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "=": {
                this.mAssign(cr, false);
                return A_Object.stdResult(this);
            }
            case "~=": {
                this.mAssign(cr, true);
                return A_Object.stdResult(this);
            }
        }
        if (Lib_Function.isVarFunction(method) > -1) {
            throw new CodeError(cr, "Invalid method for constant", "Can't change the once assigned value of a constant with: " + method);
        }
        return this.get(cr).call(cr);
    }

    private void mAssign(CallRuntime cr, boolean convert) {
        ConstLet streamit = new ConstLet(this);
        I_Object arg = cr.args(streamit, I_Object.class)[0];
        this.let(cr, cr, arg, convert);
    }
}

