/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.filesys;

import de.mn77.base.error.Err;
import java.io.File;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_Dir;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;

public class JMo_Path
extends A_Object
implements I_Object {
    private Call arg;
    private File file = null;

    public JMo_Path(Call arg) {
        Err.ifNull((Object)arg);
        this.arg = arg;
    }

    public JMo_Path(File f) {
        this.arg = null;
        this.file = f;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JMo_Path) {
            return ((JMo_Path)o).file.equals(this.file);
        }
        return super.equals(o);
    }

    public File getInternalFile() {
        return this.file;
    }

    @Override
    public void init(CallRuntime cr) {
        cr.getStrict().checkSandbox(cr, this.getTypeName());
        if (this.arg != null) {
            I_Object filename = cr.execInit(this.arg, this);
            filename = cr.argType(filename, Str.class);
            String filestr = ((Str)filename).getValue();
            this.file = new File(filestr);
            this.arg = null;
        }
    }

    @Override
    public Boolean isGreater2(I_Object o) {
        if (o instanceof JMo_Path) {
            if (this.file.compareTo(((JMo_Path)o).file) > 0) {
                return true;
            }
            return false;
        }
        return null;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (this.file == null) {
            return "Path";
        }
        switch (type) {
            case REGULAR: {
                return this.file.getAbsolutePath().toString();
            }
            case NESTED: 
            case IDENT: {
                return "Path";
            }
        }
        return "Path(\"" + this.file.getAbsolutePath().toString() + '\"' + ")";
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "exists": {
                return A_Object.stdResult(this.mExists(cr));
            }
            case "equals": 
            case "==": {
                return A_Object.stdResult(this.mEquals2(cr));
            }
            case "parent": {
                return A_Object.stdResult(this.mParent(cr));
            }
            case "name": {
                return A_Object.stdResult(this.mName(cr));
            }
            case "isDir": {
                return A_Object.stdResult(this.mIsDir(cr));
            }
            case "isFile": {
                return A_Object.stdResult(this.mIsFile(cr));
            }
            case "isHidden": {
                return A_Object.stdResult(this.mIsHidden(cr));
            }
            case "to": {
                JMo_Path f1 = this.file.isDirectory() ? new JMo_Dir(this.file) : new JMo_File(this.file);
                return A_Object.stdResult(f1);
            }
            case "toFile": {
                if (this.file != null && this.file.isDirectory()) {
                    throw new ExternalError(cr, "Path to File error", "This is a directory, not a file: " + this.file.getAbsoluteFile());
                }
                JMo_File f2 = new JMo_File(this.file);
                return A_Object.stdResult(f2);
            }
            case "toDir": {
                if (this.file != null && this.file.isFile()) {
                    throw new ExternalError(cr, "Path to Dir error", "This is a file, not a directory: " + this.file.getAbsoluteFile());
                }
                JMo_Dir f3 = new JMo_Dir(this.file);
                return A_Object.stdResult(f3);
            }
            case "absolutePath": 
            case "path": 
            case "absolute": {
                return A_Object.stdResult(this.mAbsolutePath(cr));
            }
        }
        return null;
    }

    protected void changeFile(File f) {
        this.file = f;
    }

    private Str mAbsolutePath(CallRuntime cr) {
        cr.argsNone();
        String path = this.file.getAbsolutePath();
        return new Str(path);
    }

    private Bool mEquals2(CallRuntime cr) {
        JMo_Path arg = (JMo_Path)cr.args(this, JMo_Path.class)[0];
        File pf = arg.file;
        return Bool.getObject(this.file.equals(pf));
    }

    private Bool mExists(CallRuntime cr) {
        cr.argsNone();
        return Bool.getObject(this.file.exists());
    }

    private Bool mIsDir(CallRuntime cr) {
        cr.argsNone();
        return Bool.getObject(this.file.isDirectory());
    }

    private Bool mIsFile(CallRuntime cr) {
        cr.argsNone();
        return Bool.getObject(this.file.isFile());
    }

    private Bool mIsHidden(CallRuntime cr) {
        cr.argsNone();
        return Bool.getObject(this.file.isHidden());
    }

    private Str mName(CallRuntime cr) {
        cr.argsNone();
        return new Str(this.file.getName());
    }

    private JMo_Dir mParent(CallRuntime cr) {
        cr.argsNone();
        return new JMo_Dir(this.file.getParentFile());
    }
}

