/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.I_File;
import java.util.HashMap;
import java.util.function.Consumer;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ReturnException;
import org.jaymo_lang.error.RuntimeWarning;
import org.jaymo_lang.model.ImportManager;
import org.jaymo_lang.model.IncludeInfo;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.StrictManager;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.magic.con.MagicConstSelf;
import org.jaymo_lang.object.pseudo.JMo_Warning;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.parser.ParseManagerFunc;
import org.jaymo_lang.parser.ParseManagerObj;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ErrorComposer;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Output;

public class App
extends Instance {
    public static final String name = "App";
    public static final String typeName = "Root";
    private final ImportManager imports;
    private HashMap<String, MagicConstSelf> magicConsts = null;
    private I_File outputFile = null;
    public boolean genHints = false;
    private String[] args = null;
    private Consumer<String> outputConsumer = null;
    public final ParseManagerObj parsemanager_obj = new ParseManagerObj();
    public final ParseManagerFunc parsemanager_func = new ParseManagerFunc();
    public final StrictManager strict = new StrictManager(this.parsemanager_obj, this.parsemanager_func);
    public final boolean terminalRawMode;
    private boolean debug = false;
    private byte terminate = 0;
    private boolean keep = false;
    private boolean noHardExit = false;
    private SimpleList<Procedure> doAtCalledExit = null;
    private int activeForks = 0;

    public App(boolean terminalRawMode, boolean debug) {
        super(null, null, new Type(typeName, null, null, false, false, null, null), null);
        Sys.correctCharset();
        this.terminalRawMode = terminalRawMode;
        this.debug = debug;
        this.imports = new ImportManager();
    }

    public void addMagicConst(String key, MagicConstSelf obj, DebugInfo debug) {
        if (this.magicConsts == null) {
            this.magicConsts = new HashMap();
        }
        if (this.magicConsts.containsKey(key)) {
            throw new CodeError("Invalid magic constant", "Constant is already defined: __" + key, debug);
        }
        this.magicConsts.put(key, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkExit(boolean fromFork) {
        if (fromFork) {
            --this.activeForks;
        }
        App app = this;
        synchronized (app) {
            this.notify();
        }
    }

    public void describe() {
        MOut.print("Unknown App");
        CallRuntime cr = new CallRuntime(null, this, null);
        String s = this.getType().toString(cr, STYPE.DESCRIBE);
        MOut.print(s);
    }

    public final void doAtCalledExit(Procedure p) {
        if (this.doAtCalledExit == null) {
            this.doAtCalledExit = new SimpleList();
        }
        this.doAtCalledExit.add(p);
    }

    public String exec(CallRuntime cr, App app) {
        I_Object result = this.iExec(cr, app);
        return result == null ? null : result.toString();
    }

    public String exec(String[] args) {
        CallRuntime cr = new CallRuntime(null, this, null);
        this.args = args;
        I_Object result = this.iExec(cr, this);
        return result == null ? null : result.toString();
    }

    public String execToDescribe(String[] args) {
        CallRuntime cr = new CallRuntime(null, this, null);
        this.args = args;
        I_Object result = this.iExec(cr, this);
        return result == null ? null : result.toString(cr, STYPE.DESCRIBE);
    }

    public void exit(CallRuntime cr, int exitState) {
        if (this.doAtCalledExit != null) {
            for (Procedure p : this.doAtCalledExit) {
                p.execute();
            }
        }
        this.terminate = 1;
        if (exitState == 0) {
            this.checkExit(false);
        } else {
            this.iRunShutdownHooks(cr, this);
            if (!this.noHardExit) {
                System.exit(exitState);
            }
        }
    }

    public JMo_List getArgs() {
        int size = this.args == null ? 0 : this.args.length;
        SimpleList<I_Object> al = new SimpleList<I_Object>(size);
        if (size > 0) {
            String[] stringArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                al.add(new Str(arg));
                ++n2;
            }
        }
        JMo_List list = new JMo_List(al);
        list.setReadOnly();
        return list;
    }

    public I_Object getMagicConst(String key, DebugInfo debug) {
        if (this.magicConsts == null) {
            throw new CodeError("Invalid magic constant", "Unknown constant: __" + key, debug);
        }
        I_Object obj = this.magicConsts.get(key);
        if (obj == null) {
            throw new CodeError("Invalid magic constant", "Unknown constant: __" + key, debug);
        }
        return obj;
    }

    public I_File getOutputFile() {
        return this.outputFile;
    }

    public Type getRootType() {
        return this.getType();
    }

    public void importsAdd(String basePath, String file) {
        this.imports.add(basePath, file);
    }

    public IncludeInfo importsReadNext(DebugInfo debug) {
        return this.imports.readNext(debug);
    }

    @Override
    public void init(CallRuntime cr) {
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void registerFork() {
        ++this.activeForks;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void setKeep(CallRuntime cr) {
        this.keep = true;
    }

    public void setNoHardExit() {
        this.noHardExit = true;
    }

    public void setOutputFile(I_File opf) {
        this.outputFile = opf;
    }

    public void setOutputRedirection(Consumer<String> c) {
        this.outputConsumer = c;
    }

    public void terminate() {
        this.terminate = 1;
        this.checkExit(false);
    }

    public boolean toBeTerminated() {
        return this.terminate > 0 && this.terminate != 2;
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@exit": 
            case "@warning": 
            case "@error": {
                return true;
            }
        }
        return super.validateEvent(cr, event);
    }

    public void warning(CallRuntime cr, RuntimeWarning t) {
        JMo_Warning warning = new JMo_Warning(t);
        this.eventRunRaw(cr, "@warning", warning);
        if (this.strict.getNoWarnings()) {
            return;
        }
        ErrorComposer composer = new ErrorComposer(t, cr);
        Lib_Output.err(this, composer.compose(), true);
    }

    public boolean writeOutput(String s, boolean newline) {
        if (this.outputConsumer != null) {
            this.outputConsumer.accept(newline ? String.valueOf(s) + '\n' : s);
            return true;
        }
        return false;
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        return super.callMethod(cr, method);
    }

    private I_Object iExec(CallRuntime cr, App app) {
        app.setMainEnv(cr.vce);
        I_Object result = null;
        try {
            result = app.getType().getBlock().execAppRoot(cr);
        }
        catch (ReturnException e) {
            Return temp = e.get();
            switch (temp.getLevel()) {
                case RETURN: {
                    return temp.getResult();
                }
                case NEXT: {
                    throw new CodeError(cr, "Invalid loop control", "Got 'Next' without a loop.");
                }
                case BREAK: {
                    throw new CodeError(cr, "Invalid loop control", "Got 'Break' without a loop.");
                }
            }
        }
        catch (Throwable t) {
            Lib_Error.handleThreadErrorEnd(cr, t);
        }
        if (app == this) {
            this.iWaitForOtherThreads();
        }
        this.iRunShutdownHooks(cr, app);
        return result;
    }

    private void iRunShutdownHooks(CallRuntime cr, App app) {
        if (app.terminate > 1) {
            return;
        }
        app.terminate = (byte)2;
        app.eventRunRaw(cr, "@exit", this);
        app.terminate = (byte)3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iWaitForOtherThreads() {
        while (this.terminate == 0 && (this.activeForks != 0 || this.keep)) {
            App app = this;
            synchronized (app) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

