/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.out;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.data.util.Lib_Describe;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.out.CHANNEL_IN;
import de.mn77.base.sys.out.OUTPUT_DETAIL;
import de.mn77.base.sys.out.OUTPUT_STYLE;
import de.mn77.base.sys.out.TRACE;

public class MOutStyler {
    private String linebreak = System.lineSeparator();
    private final String TRACE_INDENT = "  ";

    public void addLogHeader(CHANNEL_IN channel, StringBuilder sb) {
        sb.append(new MDateTime().toStringFileSysSlim());
        sb.append('\t');
        sb.append(channel.name());
        sb.append('\t');
    }

    public void addTrace(StringBuilder sb, StackTraceElement[] ste, TRACE trace) {
        int got = 0;
        int maxLines = trace.amount;
        int traceIdx = 0;
        while (traceIdx < ste.length - 1) {
            StackTraceElement st = ste[traceIdx];
            String stt = st.toString();
            if (!(trace != TRACE.FULL && (stt.matches("^(sun|java)\\..*$") || stt.matches("^.*:1\\)$") || stt.contains(MOut.class.getName()) || stt.contains(Err.class.getName()) || stt.indexOf("Err") >= 0 || stt.matches("^de.mn77.base.error.*$")))) {
                sb.append("  ");
                sb.append("@ ");
                sb.append(stt);
                sb.append(this.linebreak);
                if (++got >= maxLines) break;
            }
            ++traceIdx;
        }
        if (trace != TRACE.ONE) {
            sb.append("  ");
            sb.append("> ");
            sb.append(ste[ste.length - 1]);
            sb.append(this.linebreak);
        }
    }

    public String argsToDescribe(String prefix, boolean newLine, Object[] oa) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(prefix);
            sb.append(Lib_Describe.toDescribe(o));
            if (newLine) {
                sb.append(this.linebreak);
            }
            ++n2;
        }
        return sb.toString();
    }

    public String argsToIdent(String prefix, boolean newLine, Object[] oa) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(prefix);
            sb.append(ConvertObject.toStringIdent(o));
            if (newLine) {
                sb.append(this.linebreak);
            }
            ++n2;
        }
        return sb.toString();
    }

    public String argsToString(String prefix, boolean newLine, Object[] oa) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(prefix);
            sb.append(ConvertObject.toStringOutput(o));
            if (newLine) {
                sb.append(this.linebreak);
            }
            ++n2;
        }
        return sb.toString();
    }

    public void setLineBreak(String s) {
        this.linebreak = s;
    }

    public void style(StringBuilder sb, OUTPUT_STYLE style, CHANNEL_IN channel, OUTPUT_DETAIL detail, boolean newLine, Object[] oa) {
        switch (style) {
            case RAW: {
                this.argsTo(sb, "", detail, newLine, oa);
                return;
            }
            case CHANNEL: {
                this.argsTo(sb, String.valueOf(channel.name()) + "| ", detail, newLine, oa);
                if (!newLine) {
                    sb.append(this.linebreak);
                }
                return;
            }
            case TIMESTAMP: {
                this.argsTo(sb, String.valueOf(channel.name()) + ' ' + new MTime().toStringSlim() + "| ", detail, newLine, oa);
                if (!newLine) {
                    sb.append(this.linebreak);
                }
                return;
            }
        }
        throw Err.todo(new Object[]{style});
    }

    private void argsTo(StringBuilder sb, String prefix, OUTPUT_DETAIL detail, boolean newLine, Object[] oa) {
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(prefix);
            String s = detail == OUTPUT_DETAIL.RAW ? ConvertObject.toStringOutput(o) : (detail == OUTPUT_DETAIL.IDENT ? ConvertObject.toStringIdent(o) : Lib_Describe.toDescribe(o));
            sb.append(s);
            if (newLine) {
                sb.append(this.linebreak);
            }
            ++n2;
        }
    }
}

