/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.util;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import java.util.Map;

public class Lib_Describe {
    private static final String linebreak = System.lineSeparator();

    public static String toDescribe(Object o) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(o.getClass().getName()) + linebreak);
        Lib_Describe.iDescribe(sb, 1, o);
        return sb.toString();
    }

    public static String toIdent(Object o, int size) {
        StringBuilder sb = new StringBuilder();
        sb.append(o.getClass().getSimpleName());
        sb.append('<');
        sb.append(size);
        sb.append('>');
        return sb.toString();
    }

    private static void iDescribe(StringBuffer sb, int level, Object o) {
        String indent = Lib_String.sequence(' ', (long)(level * 4));
        if (o == null) {
            sb.append(String.valueOf(indent) + "null" + linebreak);
        } else if (o instanceof String || o instanceof Number || o instanceof Boolean) {
            sb.append(String.valueOf(indent) + ConvertObject.toStringIdent(o) + linebreak);
        } else if (o instanceof Map.Entry) {
            sb.append(String.valueOf(indent) + ConvertObject.toStringIdent(((Map.Entry)o).getKey()) + ":" + linebreak);
            Lib_Describe.iDescribe(sb, level + 1, ((Map.Entry)o).getValue());
        } else if (o instanceof String[]) {
            String[] stringArray = (String[])o;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n2;
            }
        } else if (o instanceof byte[]) {
            byte[] byArray = (byte[])o;
            int n = byArray.length;
            int n3 = 0;
            while (n3 < n) {
                byte i = byArray[n3];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n3;
            }
        } else if (o instanceof short[]) {
            short[] sArray = (short[])o;
            int n = sArray.length;
            int n4 = 0;
            while (n4 < n) {
                short i = sArray[n4];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n4;
            }
        } else if (o instanceof int[]) {
            int[] nArray = (int[])o;
            int n = nArray.length;
            int n5 = 0;
            while (n5 < n) {
                int i = nArray[n5];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n5;
            }
        } else if (o instanceof long[]) {
            long[] lArray = (long[])o;
            int n = lArray.length;
            int n6 = 0;
            while (n6 < n) {
                long i = lArray[n6];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n6;
            }
        } else if (o instanceof float[]) {
            float[] fArray = (float[])o;
            int n = fArray.length;
            int n7 = 0;
            while (n7 < n) {
                float i = fArray[n7];
                Lib_Describe.iDescribe(sb, level + 1, Float.valueOf(i));
                ++n7;
            }
        } else if (o instanceof double[]) {
            double[] dArray = (double[])o;
            int n = dArray.length;
            int n8 = 0;
            while (n8 < n) {
                double i = dArray[n8];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n8;
            }
        } else if (o instanceof Byte[]) {
            Byte[] byteArray = (Byte[])o;
            int n = byteArray.length;
            int n9 = 0;
            while (n9 < n) {
                Byte i = byteArray[n9];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n9;
            }
        } else if (o instanceof Short[]) {
            Short[] shortArray = (Short[])o;
            int n = shortArray.length;
            int n10 = 0;
            while (n10 < n) {
                Short i = shortArray[n10];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n10;
            }
        } else if (o instanceof Integer[]) {
            Integer[] integerArray = (Integer[])o;
            int n = integerArray.length;
            int n11 = 0;
            while (n11 < n) {
                Integer i = integerArray[n11];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n11;
            }
        } else if (o instanceof Long[]) {
            Long[] longArray = (Long[])o;
            int n = longArray.length;
            int n12 = 0;
            while (n12 < n) {
                Long i = longArray[n12];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n12;
            }
        } else if (o instanceof Float[]) {
            Float[] floatArray = (Float[])o;
            int n = floatArray.length;
            int n13 = 0;
            while (n13 < n) {
                Float i = floatArray[n13];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n13;
            }
        } else if (o instanceof Double[]) {
            Double[] doubleArray = (Double[])o;
            int n = doubleArray.length;
            int n14 = 0;
            while (n14 < n) {
                Double i = doubleArray[n14];
                Lib_Describe.iDescribe(sb, level + 1, i);
                ++n14;
            }
        } else if (o instanceof Map) {
            for (Map.Entry e : ((Map)o).entrySet()) {
                Lib_Describe.iDescribe(sb, level, e);
            }
        } else if (o instanceof Iterable) {
            for (Object e : (Iterable)o) {
                Lib_Describe.iDescribe(sb, level, e);
            }
        } else {
            Err.invalid(o.getClass().getSimpleName());
        }
    }
}

