/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.util;

import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class Lib_BigMath {
    public static final BigDecimal TWO = BigDecimal.valueOf(2L);
    public static final BigDecimal THREE = BigDecimal.valueOf(3L);
    public static final BigDecimal EULER_256 = new BigDecimal("2.7182818284590452353602874713526624977572470936999595749669676277240766303535475945713821785251664274274663919320030599218174135966290435729003342952605956307381323286279434907632338298807531952510190115738341879307021540891499348841675092447614606680822648");
    public static final MathContext CONTEXT256 = new MathContext(258, RoundingMode.HALF_EVEN);
    public static final MathContext CONTEXT1024 = new MathContext(1026, RoundingMode.HALF_EVEN);

    public static void checkMathContextNoUnlimited(MathContext mc) {
        if (mc.getPrecision() == 0) {
            throw new UnsupportedOperationException("Unlimited MathContext is not supported");
        }
    }

    public static BigInteger convertToBigInteger(double v) {
        return BigDecimal.valueOf(v).toBigInteger();
    }

    public static int convertToInt(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) == -1 || value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
            throw new Err_Runtime("Value out of Integer-Range", "" + value);
        }
        return value.intValueExact();
    }

    public static BigDecimal euler(int cycles, MathContext mc) {
        BigDecimal result = BigDecimal.ONE;
        BigDecimal f = BigDecimal.ONE;
        int i = 1;
        while (i <= cycles) {
            if ((f = f.multiply(BigDecimal.ONE.divide(new BigDecimal(i), mc), mc)).signum() == 0) break;
            result = result.add(f, mc);
            ++i;
        }
        return result;
    }

    public static boolean isBetween(BigDecimal value, double min, double max) {
        BigDecimal biMin = BigDecimal.valueOf(min);
        BigDecimal biMax = BigDecimal.valueOf(max);
        return value.compareTo(biMin) >= 0 && value.compareTo(biMax) <= 0;
    }

    public static boolean isBetween(BigInteger value, long min, long max) {
        BigInteger biMin = BigInteger.valueOf(min);
        BigInteger biMax = BigInteger.valueOf(max);
        return value.compareTo(biMin) >= 0 && value.compareTo(biMax) <= 0;
    }

    public static BigDecimal log(BigDecimal base, BigDecimal x, MathContext mc) {
        Lib_BigMath.checkMathContextNoUnlimited(mc);
        BigDecimal input = x;
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal inputOld = null;
        while (input.compareTo(base) > 0) {
            result = result.add(BigDecimal.ONE);
            if ((input = input.divide(base, mc)) == inputOld) {
                MOut.dev("Calculation error", base + ".log(" + x + ")");
                return BigDecimal.ZERO;
            }
            inputOld = input;
        }
        BigDecimal fraction = new BigDecimal(0.5);
        input = input.multiply(input, mc);
        String mem = "";
        while (result.add(fraction).compareTo(result) == 1 && input.compareTo(BigDecimal.ONE) == 1) {
            if (input.compareTo(base) == 1) {
                input = input.divide(base, mc);
                String plain = (result = result.add(fraction, mc)).toPlainString();
                if (plain.equals(mem)) {
                    return result;
                }
                mem = plain;
            }
            input = input.multiply(input, mc);
            fraction = fraction.divide(new BigDecimal(2), mc);
        }
        return Lib_BigMath.round(result, mc);
    }

    public static BigDecimal modulo(BigDecimal left, BigDecimal right) {
        return left.remainder(right);
    }

    public static BigInteger pow(long value, int exp) {
        BigInteger bigValue = BigInteger.valueOf(value);
        return bigValue.pow(exp);
    }

    public static BigDecimal round(BigDecimal value, MathContext mc) {
        return value.round(mc);
    }
}

