/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.keypot;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.struct.SimpleSet;
import de.mn77.base.data.struct.keypot.I_KeyPot;
import de.mn77.base.data.struct.keypot.KeyPotItem;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.error.Err;
import java.util.Iterator;

public abstract class A_KeyPot<TA, TB>
implements I_KeyPot<TA, TB> {
    protected SimpleSet<TA> keys = new SimpleSet();

    @Override
    public void addAll(TA key, Iterable<TB> objects) {
        for (TB o : objects) {
            this.add(key, o);
        }
    }

    @Override
    public void addItems(TA key, TB ... objects) {
        TB[] TBArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            TB o = TBArray[n2];
            this.add(key, o);
            ++n2;
        }
    }

    @Override
    public KeyPotItem<TA, TB> get(int zeile) {
        TA ta = this.keys.get(zeile);
        return new KeyPotItem(ta, this.getPot(ta));
    }

    @Override
    public SimpleSet<TA> getKeys() {
        return this.keys.copy();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.size() == 0;
    }

    @Override
    public Iterator<KeyPotItem<TA, TB>> iterator() {
        return new Iterator<KeyPotItem<TA, TB>>(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return A_KeyPot.this.size() > this.next;
            }

            @Override
            public KeyPotItem<TA, TB> next() {
                Object ta = A_KeyPot.this.keys.get(this.next++);
                return new KeyPotItem(ta, A_KeyPot.this.getPot(ta));
            }

            @Override
            public void remove() {
                Err.forbidden(new Object[0]);
            }
        };
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public void sort() {
        Sort.sortable(this, false);
    }

    @Override
    public void sortRandom() {
        Err.todo("Testen");
        Sort.sortableRandom(this);
    }

    @Override
    public String toDescribe() {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < this.size()) {
            TA key = this.keys.get(index);
            sb.append(String.valueOf(ConvertObject.toStringIdent(key)) + ": ");
            sb.append(String.valueOf(ConvertObject.toStringIdent(this.getPot(key))) + "\n");
            ++index;
        }
        return sb.toString();
    }

    @Override
    public String toIdent() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('<');
        sb.append(this.size());
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < this.size()) {
            TA key = this.keys.get(index);
            sb.append(String.valueOf(ConvertObject.toText(key)) + ": ");
            sb.append(String.valueOf(ConvertObject.toText(this.getPot(key))) + "\n");
            ++index;
        }
        return sb.toString();
    }
}

