/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct;

import de.mn77.base.data.struct.I_Collection;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.atomic.IntList;
import de.mn77.base.data.struct.search.I_Search;
import de.mn77.base.data.util.Lib_Describe;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SimpleSet<T>
implements I_Collection<T>,
I_Search,
Set<T> {
    private final SimpleList<T> data = new SimpleList();

    public SimpleSet() {
    }

    public SimpleSet(Collection<T> c) {
        this.addAll((Collection<? extends T>)c);
    }

    public SimpleSet(T ... objects) {
        this.addMore(objects);
    }

    @Override
    public boolean add(T e) {
        this.iCheck(e);
        return this.data.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.data.ensureGrow(c.size());
        for (T t : c) {
            this.add(t);
        }
        return c.size() > 0;
    }

    @Override
    public boolean addAll(Iterable<? extends T> c) {
        boolean result = false;
        for (T t : c) {
            this.add(t);
            result = true;
        }
        return result;
    }

    @Override
    public void addMore(T ... ta) {
        this.data.ensureGrow(ta.length);
        T[] TArray = ta;
        int n = ta.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            this.add(t);
            ++n2;
        }
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public SimpleSet<T> copy() {
        SimpleSet<T> result = new SimpleSet<T>();
        result.addAll(this.data);
        return result;
    }

    @Override
    public void exchange(int indexA, int indexB) {
        this.data.exchange(indexA, indexB);
    }

    @Override
    public T get(int index) {
        return this.data.get(index);
    }

    @Override
    public void insert(int index, T object) {
        this.iCheck(object);
        this.data.insert(index, object);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    public boolean put(T e) {
        boolean valid = this.iValid(e);
        if (valid) {
            this.data.add(e);
        }
        return valid;
    }

    public boolean putAll(Collection<? extends T> c) {
        this.data.ensureGrow(c.size());
        boolean changed = false;
        for (T t : c) {
            boolean added = this.put(t);
            if (!added) continue;
            changed = true;
        }
        return changed;
    }

    public void putItems(T ... ta) {
        this.data.ensureGrow(ta.length);
        T[] TArray = ta;
        int n = ta.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            this.put(t);
            ++n2;
        }
    }

    public T remove(int index) {
        return this.data.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        Integer index = this.data.searchFirst(o);
        if (index != null) {
            this.data.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeAll((Iterable<?>)c);
    }

    @Override
    public boolean removeAll(Iterable<?> c) {
        boolean changed = false;
        for (Object o : c) {
            boolean removed = this.remove(o);
            if (!removed) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public void reverse() {
        this.data.reverse();
    }

    @Override
    public IntList searchAll(Object o) {
        IntList result = new IntList();
        Integer found = this.data.searchFirst(o);
        if (found != null) {
            result.add(found);
        }
        return result;
    }

    @Override
    public Integer searchFirst(Object o) {
        return this.data.searchFirst(o);
    }

    @Override
    public T set(int index, T object) {
        this.iCheck(object);
        return this.data.set(index, object);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void sort() {
        this.data.sort();
    }

    @Override
    public void sortLike(int[] newOrder) {
        this.data.sortLike(newOrder);
    }

    @Override
    public void sortRandom() {
        this.data.sortRandom();
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public T[] toArray(Class<T> type) {
        return this.data.toArray(type);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public String toDescribe() {
        return Lib_Describe.toDescribe(this);
    }

    @Override
    public String toIdent() {
        return Lib_Describe.toIdent(this, this.data.size());
    }

    private void iCheck(T t) {
        if (!this.iValid(t)) {
            throw new Err_Runtime("Invalid item for Set", "Object already known: " + t.toString());
        }
    }

    private boolean iValid(T t) {
        Err.ifNull(t);
        for (T o : this.data) {
            if (!o.equals(t)) continue;
            return false;
        }
        return true;
    }
}

