/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.atomic.IntList;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.data.util.Lib_Describe;
import de.mn77.base.data.util.Lib_Random;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SimpleList<T>
implements I_List<T> {
    private static final int DEFAULT_INIT_SIZE = 10;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private T[] data;
    private int size = 0;

    public SimpleList() {
        this.data = new Object[10];
    }

    public SimpleList(int initSize) {
        this.data = new Object[initSize];
    }

    public SimpleList(T[] arr) {
        Err.ifNull(arr);
        this.data = arr;
        this.size = arr.length;
    }

    @Override
    public void add(int index, T element) {
        this.insert(index, element);
    }

    @Override
    public boolean add(T object) {
        this.ensureGrow(1);
        this.data[this.size] = object;
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Err.ifNull(c);
        this.ensureGrow(c.size());
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public void addMore(T ... ta) {
        Err.ifNull(ta);
        this.ensureGrow(ta.length);
        T[] TArray = ta;
        int n = ta.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            this.add(t);
            ++n2;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(Object o) {
        Err.ifNull(o);
        int i = 0;
        while (i < this.size) {
            if (this.data[i].equals(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Err.ifNull(c);
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SimpleList<T> copy() {
        Object[] newArray = new Object[this.size];
        System.arraycopy(this.data, 0, newArray, 0, this.size);
        return new SimpleList<Object>(newArray);
    }

    @Override
    public void ensureCapacity(int wanted) {
        int grow = wanted - this.size;
        if (grow > 0) {
            this.ensureGrow(grow);
        }
    }

    public void ensureGrow(int amount) {
        int needed = this.size + amount;
        if (needed <= this.data.length) {
            return;
        }
        int grow = this.size <= 20 ? 10 : this.size / 2;
        int newCapacity = needed + grow;
        if (newCapacity <= 0 || newCapacity > 0x7FFFFFF7) {
            throw new Err_Runtime("Maximum list size exceeded!", new Object[0]);
        }
        this.data = Arrays.copyOf(this.data, newCapacity);
    }

    @Override
    public void exchange(int indexA, int indexB) {
        Err.ifOutOfBounds(0, this.data.length - 1, indexA);
        Err.ifOutOfBounds(0, this.data.length - 1, indexB);
        if (indexA == indexB) {
            MOut.warning("Change of " + indexA + " and " + indexB + " not necessary!");
            return;
        }
        T buffer = this.data[indexA];
        this.data[indexA] = this.data[indexB];
        this.data[indexB] = buffer;
    }

    @Override
    public T get(int index) {
        this.iCheckBounds(index);
        return this.data[index];
    }

    @Override
    public int indexOf(Object o) {
        Integer result = this.searchFirst(o);
        return result != null ? result : -1;
    }

    @Override
    public void insert(int index, T object) {
        if (index == this.size) {
            this.add(object);
            return;
        }
        this.iCheckBounds(index);
        this.ensureGrow(1);
        System.arraycopy(this.data, index, this.data, index + 1, this.data.length - index - 1);
        this.data[index] = object;
        ++this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pointer = 0;

            @Override
            public boolean hasNext() {
                return this.pointer < SimpleList.this.size;
            }

            @Override
            public T next() {
                return SimpleList.this.data[this.pointer++];
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        Err.ifNull(o);
        int i = this.size - 1;
        while (i >= 0) {
            if (this.data[i].equals(o)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.ensureCapacity(index + 1);
        return new ListItr(index);
    }

    @Override
    public T remove(int index) {
        this.iCheckBounds(index);
        T old = this.data[index];
        System.arraycopy(this.data, index + 1, this.data, index, this.data.length - index - 1);
        --this.size;
        return old;
    }

    @Override
    public boolean remove(Object o) {
        Err.ifNull(o);
        boolean changed = false;
        int i = this.size - 1;
        while (i >= 0) {
            if (this.data[i].equals(o)) {
                this.remove(i);
                changed = true;
            }
            --i;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Err.ifNull(c);
        boolean changed = false;
        for (Object o : c) {
            boolean removed = this.remove(o);
            if (!removed) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Err.ifNull(c);
        throw Err.todo(new Object[0]);
    }

    @Override
    public void reverse() {
        int size = this.data.length;
        T[] buffer = Arrays.copyOf(this.data, size);
        int i = size - 1;
        while (i >= 0) {
            buffer[i] = this.data[i];
            --i;
        }
        this.data = buffer;
    }

    @Override
    public IntList searchAll(Object o) {
        Err.ifNull(o);
        IntList result = new IntList();
        int i = 0;
        while (i < this.size) {
            if (this.data[i].equals(o)) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    @Override
    public Integer searchFirst(Object o) {
        Err.ifNull(o);
        int i = 0;
        while (i < this.size) {
            if (this.data[i].equals(o)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    @Override
    public T set(int index, T object) {
        this.iCheckBounds(index);
        T old = this.data[index];
        this.data[index] = object;
        return old;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void sort() {
        Sort.sortable(this, false);
    }

    @Override
    public void sortLike(int[] newOrder) {
        int size = this.size;
        Err.ifNot(size, newOrder.length, "Length of list and indexes must be equal");
        T[] buffer = Arrays.copyOf(this.data, size);
        int i = 0;
        while (i < size) {
            buffer[i] = this.data[newOrder[i]];
            ++i;
        }
        this.data = buffer;
    }

    @Override
    public void sortRandom() {
        if (this.data.length <= 1) {
            return;
        }
        int[] rnd = Lib_Random.getIntArraySet(0, this.data.length - 1);
        this.sortLike(rnd);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        T[] copy = Arrays.copyOfRange(this.data, fromIndex, toIndex);
        return new SimpleList<T>(copy);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.data, 0, result, 0, this.size);
        return result;
    }

    @Override
    public T[] toArray(Class<T> clazz) {
        Err.ifNull(clazz);
        Object[] result = (Object[])Array.newInstance(clazz, this.size);
        System.arraycopy(this.data, 0, result, 0, this.size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Err.ifNull(a);
        if (a.length < this.size) {
            a = Arrays.copyOf(a, this.size);
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        return a;
    }

    @Override
    public String toDescribe() {
        return Lib_Describe.toDescribe(this);
    }

    @Override
    public String toIdent() {
        return Lib_Describe.toIdent(this, this.size);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(ConvertObject.toStringIdent(this.data[i].toString()));
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    private void iCheckBounds(int index) {
        if (index < 0 || index >= this.size) {
            throw new Err_Runtime("Index out of bounds", "Allowed are 0-" + (this.size - 1) + ", but got " + index);
        }
    }

    private class Itr
    implements Iterator<T> {
        int cursor = 0;
        int lastReturn = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != SimpleList.this.size();
        }

        @Override
        public T next() {
            try {
                int i = this.cursor;
                Object next = SimpleList.this.get(i);
                this.lastReturn = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<T> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public void add(T e) {
            try {
                int i = this.cursor;
                SimpleList.this.add(i, e);
                this.lastReturn = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public T previous() {
            try {
                int i = this.cursor - 1;
                Object previous = SimpleList.this.get(i);
                this.lastReturn = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            if (this.lastReturn < 0) {
                throw new IllegalStateException();
            }
            try {
                SimpleList.this.set(this.lastReturn, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

