/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.struct.I_Collection;
import de.mn77.base.data.struct.I_Iterable;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.atomic.IntList;
import de.mn77.base.data.util.Lib_Describe;
import de.mn77.base.error.Err;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class PotList<TA>
implements I_Collection<I_Iterable<TA>> {
    private SimpleList<SimpleList<TA>> pots = new SimpleList();

    public PotList() {
    }

    public PotList(int length) {
        this();
        Err.ifTooSmall(0.0, length);
        int i = 0;
        while (i < length) {
            this.pots.add(new SimpleList());
            ++i;
        }
    }

    @Override
    public boolean add(I_Iterable<TA> pot) {
        return this.pots.add(this.iMakePot(pot));
    }

    @Override
    public boolean add(Iterable<TA> objects) {
        return this.pots.add(this.iMakePot(objects));
    }

    @Override
    public boolean add(TA ... objects) {
        return this.pots.add(this.iMakePot(objects));
    }

    @Override
    public boolean addAll(Collection<? extends I_Iterable<TA>> c) {
        for (I_Iterable<TA> s : c) {
            this.pots.add(this.iMakePot(s));
        }
        return true;
    }

    public void addMore(I_Iterable<TA> ... ta) {
        I_Iterable<TA>[] i_IterableArray = ta;
        int n = ta.length;
        int n2 = 0;
        while (n2 < n) {
            I_Iterable<TA> pot = i_IterableArray[n2];
            this.add(pot);
            ++n2;
        }
    }

    @Override
    public void clear() {
        this.pots.clear();
    }

    @Override
    public boolean contains(Object o) {
        Err.ifNull(o);
        for (I_Iterable i_Iterable : this.pots) {
            for (Object ta : i_Iterable) {
                if (!o.equals(ta)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public PotList<TA> copy() {
        PotList<TA> result = new PotList<TA>();
        result.addAll((Collection<I_Iterable<TA>>)this.pots);
        return result;
    }

    @Override
    public void exchange(int indexA, int indexB) {
        this.pots.exchange(indexA, indexB);
    }

    @Override
    public I_Iterable<TA> get(int row) {
        Err.ifOutOfSize(this.pots, row);
        return this.pots.get(row);
    }

    @Override
    public void insert(int index, I_Iterable<TA> pot) {
        this.pots.insert(index, this.iMakePot(pot));
    }

    @Override
    public boolean isEmpty() {
        return this.pots.isEmpty();
    }

    @Override
    public Iterator<I_Iterable<TA>> iterator() {
        return new Iterator<I_Iterable<TA>>(){
            private int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < PotList.this.size();
            }

            @Override
            public I_Iterable<TA> next() {
                return PotList.this.pots.get(this.next++);
            }

            @Override
            public void remove() {
                Err.todo(new Object[0]);
            }
        };
    }

    public int maxDepth() {
        int max = 0;
        for (I_Iterable i_Iterable : this.pots) {
            max = Math.max(max, i_Iterable.size());
        }
        return max;
    }

    public void potAdd(int row, TA object) {
        Err.ifOutOfSize(this.pots, row);
        this.pots.get(row).add(object);
    }

    public void potAddAll(int row, Iterable<TA> objects) {
        Err.ifOutOfSize(this.pots, row);
        for (TA t : objects) {
            this.pots.get(row).add(t);
        }
    }

    public boolean potRemove(int index, TA object) {
        return this.pots.get(index).remove(object);
    }

    public I_Iterable<TA> remove(int index) {
        return this.pots.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public void reverse() {
        this.pots.reverse();
    }

    @Override
    public IntList searchAll(Object o) {
        IntList result = new IntList();
        int y = 0;
        while (y < this.pots.size()) {
            SimpleList<TA> pot = this.pots.get(y);
            for (TA element : pot) {
                if (!element.equals(o)) continue;
                result.add(y);
            }
            ++y;
        }
        return result;
    }

    @Override
    public Integer searchFirst(Object o) {
        int y = 0;
        while (y < this.pots.size()) {
            SimpleList<TA> pot = this.pots.get(y);
            for (TA element : pot) {
                if (!element.equals(o)) continue;
                return y;
            }
            ++y;
        }
        return null;
    }

    @Override
    public I_Iterable<TA> set(int index, I_Iterable<TA> pot) {
        return this.pots.set(index, this.iMakePot(pot));
    }

    @Override
    public int size() {
        return this.pots.size();
    }

    @Override
    public void sort() {
        throw Err.invalid("This PotList can't be sorted!");
    }

    @Override
    public void sortLike(int[] newOrder) {
        this.pots.sortLike(newOrder);
    }

    @Override
    public void sortRandom() {
        this.pots.sortRandom();
    }

    @Override
    public Object[] toArray() {
        return this.pots.toArray();
    }

    public I_Iterable<TA>[] toArray(Class<I_Iterable<TA>> clazz) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.pots.toArray(a);
    }

    @Override
    public String toDescribe() {
        return Lib_Describe.toDescribe(this);
    }

    @Override
    public String toIdent() {
        return Lib_Describe.toIdent(this, this.pots.size());
    }

    @Override
    public String toString() {
        String result = "";
        int width = ("" + this.pots.size()).length();
        int nr = 1;
        for (I_Iterable i_Iterable : this.pots) {
            result = String.valueOf(result) + FormNumber.width(width, nr, false) + " ";
            ++nr;
            String result2 = "(";
            int nr2 = 1;
            for (Object item : i_Iterable) {
                result2 = String.valueOf(result2) + (nr2 == 1 ? "" : ",") + ConvertObject.toStringIdent(item);
                ++nr2;
                if (result2.length() <= 100) continue;
                result2 = String.valueOf(result2) + "...";
                break;
            }
            result = String.valueOf(result) + result2 + ")\n";
            if (nr > 100) break;
        }
        return result;
    }

    private SimpleList<TA> iMakePot(Iterable<TA> objects) {
        SimpleList<TA> newPot = new SimpleList<TA>();
        for (TA t : objects) {
            newPot.add(t);
        }
        return newPot;
    }

    private SimpleList<TA> iMakePot(TA[] pot) {
        SimpleList newPot = new SimpleList();
        Collections.addAll(newPot, pot);
        return newPot;
    }
}

