/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.group.Group2;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectManager;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_Parser;
import org.jaymo_lang.util.Lib_Prefix;
import org.jaymo_lang.util.Lib_Type;

public class ParseObj_NewWithOpenArg
implements I_ParseObject {
    public static final String NOT = ".=+-*/!&>|^~\\";

    @Override
    public boolean hits(char c0, Block current, String s) {
        if (c0 != '_' && (c0 < 'A' || c0 > 'Z')) {
            return false;
        }
        int state = 0;
        int index = -1;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            ++index;
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t') {
                        state = 1;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') break;
                    return false;
                }
                case 1: {
                    if (c == ' ') break;
                    if (c == '<') {
                        String s2 = s.substring(index);
                        return Lib_Parser.fastCheckStartWithTypeNotation(s2);
                    }
                    if (NOT.indexOf(c) != -1) {
                        if (index < s.length() - 1 && (c == '+' || c == '-')) {
                            return s.charAt(index + 1) != ' ';
                        }
                    } else if (c != ' ' && c != '\t') {
                        return true;
                    }
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        parser.app.strict.checkOpenArg(parser.getDebugInfo());
        String m = Lib_Parser.getTypeName(s, parser);
        String ps = s.substring(m.length());
        String rem = "";
        ps = FilterString.trimSpace(ps, true, true);
        if (parser.buffer.nextLevelDiff() > 0) {
            throw new CodeError("Invalid use of open argument", "For using block, please try: " + m + "( " + ps + " )", parser);
        }
        if (ps.charAt(0) == '\t') {
            throw new CodeError("Invalid arguments for type", "Please remove tabulator char after: " + m, parser);
        }
        m = Lib_Prefix.addPrefix(m, parser);
        Lib_Type.checkValidity(m, parser);
        Call[] args = Parser_Call.parseArguments(parser, current, ps);
        if (args.length != 1) {
            throw new CodeError("Invalid amount of arguments", "For more arguments, please try: " + m + '(' + ps + ')', parser);
        }
        if (args[0].hasBlock()) {
            throw new CodeError("Invalid use of open argument", "For using block, please try: " + m + "( " + ps + " )", parser);
        }
        I_Object o = ObjectManager.createNew(parser.app, current, m, args, parser.getDebugInfo());
        return new Group2<I_Object, String>(o, "");
    }
}

