/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser;

import de.mn77.base.data.filter.FilterString;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.magic.con.MagicConstSelf;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.util.BLOCKED;
import org.jaymo_lang.util.Lib_Error;

public class Parser_MagicConst {
    public static void parse(Parser_Script parser, Type currentType, Block currentBlock, String s) {
        if (!currentType.getName().equals("Root")) {
            throw new CodeError("Invalid definition", "A magic constant must be defined in the root type!", parser.getDebugInfo());
        }
        if (currentBlock.getParent() != null) {
            throw new CodeError("Invalid definition", "A magic constant must be defined at root level!", parser.getDebugInfo());
        }
        String var = FilterString.matchingLeft("_ABCDEFGHIJKLMNOPQRSTUVWXYZ", s).substring(2);
        String arg = s.substring(var.length() + 2).trim();
        if (var.length() == 0) {
            throw new CodeError("Invalid definition", "Missing name of the magic constant: " + s, parser.getDebugInfo());
        }
        if (arg.length() == 0) {
            throw new CodeError("Invalid definition", "Missing argument for magic constant: " + s, parser.getDebugInfo());
        }
        if (arg.charAt(0) != '=') {
            throw new CodeError("Invalid definition", "Missing '=' after the magic constant: __" + var, parser.getDebugInfo());
        }
        String[] stringArray = BLOCKED.MAGIC_CONSTS;
        int n = BLOCKED.MAGIC_CONSTS.length;
        int n2 = 0;
        while (n2 < n) {
            String blocked = stringArray[n2];
            if (var.equals(blocked)) {
                throw new CodeError("Invalid definition", "Name of magic constant is already used: __" + var, parser.getDebugInfo());
            }
            ++n2;
        }
        arg = arg.substring(1).trim();
        Call[] args = Parser_Call.parseArguments(parser, currentBlock, arg);
        Lib_Error.ifArgs(args.length, 1, (Integer)1, "Magic constant", parser.getDebugInfo());
        MagicConstSelf mcc = new MagicConstSelf(var, args[0]);
        parser.app.addMagicConst(var, mcc, parser.getDebugInfo());
    }
}

