/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.convert.ConvertArray;
import de.mn77.base.data.convert.ConvertString;
import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.I_Series;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.util.Lib_Array;
import de.mn77.base.error.Err;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.I_AutoBlockList;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.JMo_RegEx;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Sequence;
import org.jaymo_lang.util.Lib_Table;
import org.jaymo_lang.util.Lib_TableStyle;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Table
extends A_Sequence
implements I_AutoBlockDo,
I_AutoBlockList {
    private ArrayTable<I_Object> tab;
    private final ArgCallBuffer width;
    private final ArgCallBuffer rows;
    private final ArgCallBuffer fill;
    private I_Object[] titles = null;

    public JMo_Table(ArrayTable<I_Object> init_tab) {
        this.tab = init_tab;
        this.width = null;
        this.rows = null;
        this.fill = null;
    }

    public JMo_Table(Call width) {
        this.width = new ArgCallBuffer(0, width);
        this.rows = null;
        this.fill = null;
    }

    public JMo_Table(Call width, Call rows, Call fill) {
        this.width = new ArgCallBuffer(0, width);
        this.rows = new ArgCallBuffer(1, rows);
        this.fill = new ArgCallBuffer(2, fill);
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.mEach((CallRuntime)cr, (boolean)false).obj;
    }

    @Override
    public SimpleList<I_Object> autoBlockToList(CallRuntime cr) {
        SimpleList<I_Object> result = new SimpleList<I_Object>(this.tab.size());
        for (I_Object[] i_ObjectArray : this.tab) {
            SimpleList<I_Object> rowList = ConvertArray.toSimpleList(i_ObjectArray);
            result.add(new JMo_List(rowList));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JMo_Table) {
            ArrayTable<I_Object> other = ((JMo_Table)obj).tab;
            if (this.tab.size() != other.size() || this.tab.width() != other.width()) {
                return false;
            }
            int y = 0;
            while (y < this.tab.size()) {
                int x = 0;
                while (x < this.tab.width()) {
                    if (!this.tab.get(x, y).equals(other.get(x, y))) {
                        return false;
                    }
                    ++x;
                }
                ++y;
            }
            I_Object[] otherTitles = ((JMo_Table)obj).titles;
            if (this.titles == null) {
                return otherTitles == null;
            }
            if (otherTitles == null || this.titles.length != otherTitles.length) {
                return false;
            }
            int i = 0;
            while (i < this.titles.length) {
                if (!this.titles[i].equals(otherTitles[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    public I_Series<? extends I_Object> getInternalCollection() {
        throw Err.impossible(new Object[0]);
    }

    public I_Object[] getInternalColumnNames() {
        return this.titles;
    }

    public ArrayTable<I_Object> getInternalObject() {
        return this.tab;
    }

    public I_Object[] getTitles() {
        return this.titles;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.width != null) {
            int w;
            this.width.init(cr, this, A_IntNumber.class);
            if (this.tab != null) {
                Err.invalid(this.tab);
            }
            if ((w = Lib_Convert.getIntValue(cr, this.width.get())) < 1) {
                throw new RuntimeError(cr, "Invalid table width", "Minimum amount of columns is 1, but got " + w);
            }
            this.tab = new ArrayTable(w);
            if (this.rows != null) {
                int r = Lib_Convert.getIntValue(cr, this.rows.init(cr, this, A_IntNumber.class));
                Object fill = this.fill.init(cr, this, null);
                int ir = 0;
                while (ir < r) {
                    I_Object[] row = new I_Object[w];
                    int iw = 0;
                    while (iw < w) {
                        row[iw] = fill;
                        ++iw;
                    }
                    this.tab.add((T[])row);
                    ++ir;
                }
            }
        }
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPosition(cr, i, this.tab.size(), lazy);
        if (pos == -1 || pos > this.tab.size()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.tab.size(), pos, "position in list");
        }
        if (offset == keys.length - 1) {
            I_Object[] it = this.tab.get(pos - 1);
            return this.iToList(it);
        }
        I_Object[] it = this.tab.get(pos - 1);
        I_Object deeper = this.iToList(it);
        if (!(deeper instanceof A_Sequence)) {
            throw new RuntimeError(cr, "Invalid type of item.", "Item " + (offset + 1) + " isn't a sequence, so I can't go into it!");
        }
        A_Sequence deeper2 = (A_Sequence)deeper;
        return deeper2.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        A_IntNumber oiy = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int wantedY = Lib_Convert.getIntValue(cr, oiy);
        int posY = Lib_Sequence.realPosition(cr, wantedY, this.tab.size(), lazy);
        if (lazy) {
            while ((posY = Lib_Sequence.realPosition(cr, wantedY, this.tab.size(), lazy)) == -1) {
                I_Object[] emptyRow = new I_Object[this.tab.width()];
                int i = 0;
                while (i < this.tab.width()) {
                    emptyRow[i] = Nil.NIL;
                    ++i;
                }
                this.tab.add((T[])emptyRow);
            }
        }
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), posY, "row");
        if (keys.length - offset == 1) {
            if (!Lib_Type.typeIs(cr, value, JMo_List.class)) {
                throw new RuntimeError(cr, "Invalid type of value", "Value must be a List");
            }
            JMo_List valueList = (JMo_List)value;
            I_Series valueArrayList = valueList.getInternalCollection();
            Lib_Error.ifNot(cr, this.tab.width(), ((SimpleList)valueArrayList).size(), "row-size");
            int col = 0;
            while (col < this.tab.width()) {
                this.tab.set(col, posY - 1, (I_Object)((SimpleList)valueArrayList).get(col));
                ++col;
            }
            return;
        }
        A_IntNumber oix = (A_IntNumber)cr.argType(keys[offset + 1], A_IntNumber.class);
        int wantedX = Lib_Convert.getIntValue(cr, oix);
        int posX = Lib_Sequence.realPosition(cr, wantedX, this.tab.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.tab.width(), wantedX, "column");
        if (offset == keys.length - 2) {
            this.tab.set(posX - 1, posY - 1, value);
        } else {
            I_Object deeper = this.tab.get(posX - 1, posY - 1);
            if (deeper == Nil.NIL && lazy) {
                deeper = new JMo_List();
                this.tab.set(posX - 1, posY - 1, deeper);
            }
            if (!(deeper instanceof A_Sequence)) {
                throw new RuntimeError(cr, "Invalid type of item.", "Item " + (offset + 1) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.sequenceDeepSet(cr, keys, offset + 2, value, lazy);
        }
    }

    public void setTitles(CallRuntime cr, I_Object[] titles) {
        if (titles.length != this.tab.width()) {
            throw new RuntimeError(cr, "Invalid amount of titles for table", "Column count is " + this.tab.width() + ", but got " + titles.length + " title(s).");
        }
        I_Object[] i_ObjectArray = titles;
        int n = titles.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object title = i_ObjectArray[n2];
            cr.argType(title, A_Atomic.class);
            ++n2;
        }
        this.titles = titles;
    }

    @Override
    public String toString() {
        return this.tab == null ? "Table" : "Table<" + this.tab.width() + ',' + this.tab.size() + '>';
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: {
                return Lib_Table.toText(false, cr, this, this.tab, this.titles);
            }
            case NESTED: 
            case IDENT: {
                return this.toString();
            }
        }
        return Lib_Table.toText(true, cr, this, this.tab, this.titles);
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "init": {
                this.mInit(cr);
                return A_Object.stdResult(this);
            }
            case "row": {
                return A_Object.stdResult(this.mGetRow(cr, false));
            }
            case "rowMap": {
                return A_Object.stdResult(this.mGetRow(cr, true));
            }
            case "column": {
                return A_Object.stdResult(this.mGetColumn(cr));
            }
            case "getTitles": {
                return this.mGetTitles(cr);
            }
            case "setTitles": {
                this.mSetTitles(cr);
                return A_Object.stdResult(this);
            }
            case "firstRowTitles": {
                this.mSetFirstRowTitles(cr);
                return A_Object.stdResult(this);
            }
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "addRow": 
            case "addRows": {
                return A_Object.stdResult(this.mAddRows(cr));
            }
            case "concat": 
            case "++": {
                return A_Object.stdResult(this.mConcat(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.mAddAll(cr));
            }
            case "each": {
                return this.mEach(cr, false);
            }
            case "eachMap": {
                return this.mEach(cr, true);
            }
            case "search": {
                return A_Object.stdResult(this.mSearch(cr, false, true));
            }
            case "searchFirst": {
                return A_Object.stdResult(this.mSearch(cr, true, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.mSearch(cr, true, false));
            }
            case "width": {
                cr.argsNone();
                return A_Object.stdResult(new Int(this.tab.width()));
            }
            case "sort": {
                return A_Object.stdResult(this.mSort(cr));
            }
            case "shuffle": {
                return A_Object.stdResult(this.mShuffle(cr));
            }
            case "reverse": {
                return A_Object.stdResult(this.mReverse(cr));
            }
            case "filter": {
                return A_Object.stdResult(this.mFilter(cr, method));
            }
            case "map": {
                return A_Object.stdResult(this.mMap(cr, method));
            }
            case "reduce": {
                return A_Object.stdResult(this.mReduce(cr, method));
            }
            case "amount": {
                return A_Object.stdResult(this.mAmount(cr, method));
            }
            case "rotate": {
                return A_Object.stdResult(this.mRotate(cr));
            }
            case "columns": {
                return A_Object.stdResult(this.mColumns(cr));
            }
            case "rows": {
                return A_Object.stdResult(this.mRows(cr));
            }
            case "deleteRow": 
            case "deleteRows": {
                return A_Object.stdResult(this.mDelete(cr));
            }
            case "contains": {
                return A_Object.stdResult(this.mContains(cr));
            }
            case "style": {
                return A_Object.stdResult(this.mStyle(cr));
            }
        }
        return null;
    }

    @Override
    protected JMo_Table copy(CallRuntime cr) {
        return new JMo_Table((ArrayTable<I_Object>)this.tab.copy());
    }

    @Override
    protected I_Object getFirst(CallRuntime cr) {
        return this.tab.size() == 0 ? Nil.NIL : this.iToList(this.tab.get(0));
    }

    @Override
    protected I_Object getLast(CallRuntime cr) {
        int len = this.tab.size();
        return len == 0 ? Nil.NIL : this.iToList(this.tab.get(len - 1));
    }

    @Override
    protected void mSequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] orc = cr.argsVar(this, 2, 2);
        if (orc.length > 3) {
            this.sequenceDeepSet(cr, orc, 1, orc[0], lazy);
            return;
        }
        int row = Lib_Convert.getIntValue(cr, orc[1]);
        int col = Lib_Convert.getIntValue(cr, orc[2]);
        if (lazy) {
            while (this.tab.size() < row) {
                I_Object[] newRow = new I_Object[this.tab.width()];
                int i = 0;
                while (i < this.tab.width()) {
                    newRow[i] = Nil.NIL;
                    ++i;
                }
                this.tab.add((T[])newRow);
            }
            if (col > this.tab.width()) {
                throw new RuntimeError(cr, "Can't add columns to Table", "Table has a fixed width, so I can't add/access column " + col);
            }
        }
        this.tab.set(col - 1, row - 1, orc[0]);
    }

    @Override
    protected void sequenceContent(CallRuntime cr, I_Object[] values) {
        int y = 0;
        while (y < this.tab.size()) {
            JMo_List in = (JMo_List)cr.argType(values[y], JMo_List.class);
            I_Series row = in.getInternalCollection();
            if (((SimpleList)row).size() != this.tab.width()) {
                throw new RuntimeError(cr, "Invalid amount of items in row", "Width of table is " + this.tab.width() + ", but got " + ((SimpleList)row).size() + " items in argument " + (y + 1) + ".");
            }
            int x = 0;
            while (x < this.tab.width()) {
                this.tab.set(x, y, (I_Object)((SimpleList)row).get(x));
                ++x;
            }
            ++y;
        }
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.tab.isEmpty();
    }

    @Override
    protected I_Object sequenceGetPull(CallRuntime cr, boolean lazy, I_Object arg) {
        return this.mGetRow(cr, false);
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int oi = Lib_Convert.getIntValue(cr, key);
        int pos = Lib_Sequence.realPosition(cr, oi, this.tab.size(), lazy);
        return pos == -1 ? Nil.NIL : this.iToList(this.tab.getRow(pos - 1));
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object key, I_Object value, boolean lazy) {
        I_Series cols = ((JMo_List)cr.argType(value, JMo_List.class)).getInternalCollection();
        int row = Lib_Convert.getIntValue(cr, key);
        if (lazy) {
            int width = this.tab.width();
            while (this.tab.size() < row) {
                I_Object[] newRow = new I_Object[width];
                int i = 0;
                while (i < width) {
                    newRow[i] = Nil.NIL;
                    ++i;
                }
                this.tab.add((T[])newRow);
            }
        }
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), row, "row");
        Lib_Error.ifNotBetween(cr, 1, this.tab.width(), ((SimpleList)cols).size(), "columns");
        int col = 0;
        while (col < this.tab.width()) {
            this.tab.set(col, row - 1, (I_Object)((SimpleList)cols).get(col));
            ++col;
        }
    }

    @Override
    protected int sequenceSize() {
        return this.tab.size();
    }

    private I_Object iToList(Collection<I_Object> it) {
        SimpleList<I_Object> al = new SimpleList<I_Object>(it.size());
        al.addAll(it);
        return new JMo_List(al);
    }

    private I_Object iToList(I_Object[] it) {
        return new JMo_List(ConvertArray.toSimpleList(it));
    }

    private I_Object iToMap(I_Object[] it) {
        SimpleList<I_Object> objects = new SimpleList<I_Object>(it.length);
        Collections.addAll(objects, it);
        if (this.titles != null) {
            SimpleList<I_Object> keys = new SimpleList<I_Object>(this.titles.length);
            Collections.addAll(keys, this.titles);
            return new JMo_Map(keys, objects);
        }
        SimpleList<I_Object> t2 = new SimpleList<I_Object>(this.tab.width());
        int col = 1;
        while (col <= this.tab.width()) {
            t2.add(new Int(col));
            ++col;
        }
        return new JMo_Map(t2, objects);
    }

    private int[] iVarArgsToIntArray(CallRuntime cr, I_Object[] args, int offset, int min, int max) {
        int[] result = new int[args.length - offset];
        int i = offset;
        while (i < args.length) {
            result[i - offset] = Lib_Convert.getIntValue(cr, cr.argType(args[i], Int.class)) - 1;
            ++i;
        }
        return result;
    }

    private JMo_Table mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        if (args.length != this.tab.width()) {
            throw new RuntimeError(cr, "Invalid amount of items to add.", "Width of table is " + this.tab.width() + ", but got " + cr.argCount() + " items.");
        }
        this.tab.add((T[])args);
        return this;
    }

    private JMo_Table mAddAll(CallRuntime cr) {
        JMo_Table tab2 = (JMo_Table)cr.args(this, JMo_Table.class)[0];
        tab2.getInternalObject().forEach(a -> {
            boolean bl = this.tab.add((T[])a);
        });
        return this;
    }

    private JMo_Table mAddRows(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 1);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            JMo_List pl = (JMo_List)cr.argType(arg, JMo_List.class);
            I_Series list = pl.getInternalCollection();
            if (((SimpleList)list).size() != this.tab.width()) {
                throw new RuntimeError(cr, "Invalid size of row", "Table width is " + this.tab.width() + ", but should add a row with " + ((SimpleList)list).size() + " items.");
            }
            I_Object[] row = ((SimpleList)list).toArray((T[])new I_Object[((SimpleList)list).size()]);
            this.tab.add((T[])row);
            ++n2;
        }
        return this;
    }

    private Int mAmount(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        int result = 0;
        for (I_Object[] i_ObjectArray : this.tab) {
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, i_ObjectArray, Bool.class);
            if (!ok.getValue().booleanValue()) continue;
            ++result;
        }
        return new Int(result);
    }

    private JMo_Table mColumns(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int parLen = args.length;
        int[] parsi = new int[parLen];
        int i = 0;
        while (i < parLen) {
            int par = Lib_Convert.getIntValue(cr, cr.argType(args[i], A_IntNumber.class));
            parsi[i] = Lib_Sequence.realPosition(cr, par, this.tab.width(), false);
            ++i;
        }
        ArrayTable<I_Object> newTab = new ArrayTable<I_Object>(parLen);
        int row = 0;
        while (row < this.tab.size()) {
            I_Object[] items = new I_Object[parLen];
            int i2 = 0;
            while (i2 < parLen) {
                items[i2] = this.tab.get(parsi[i2] - 1, row);
                ++i2;
            }
            newTab.add((T[])items);
            ++row;
        }
        return new JMo_Table(newTab);
    }

    private JMo_Table mConcat(CallRuntime cr) {
        JMo_Table tab2 = (JMo_Table)cr.args(this, JMo_Table.class)[0];
        ArrayTable<I_Object> newTab = new ArrayTable<I_Object>(this.tab.width());
        this.tab.forEach(a -> {
            boolean bl = newTab.add((T[])a);
        });
        tab2.getInternalObject().forEach(a -> {
            boolean bl = newTab.add((T[])a);
        });
        return new JMo_Table(newTab);
    }

    private Bool mContains(CallRuntime cr) {
        I_Object arg = cr.args(this, A_Object.class)[0];
        int x = 0;
        while (x < this.tab.width()) {
            if (this.tab.getColumn(x).contains(arg)) {
                return Bool.TRUE;
            }
            ++x;
        }
        return Bool.FALSE;
    }

    private JMo_Table mDelete(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int len = args.length;
        int[] rows = new int[len];
        int i = 0;
        while (i < len) {
            rows[i] = Lib_Convert.getIntValue(cr, args[i]);
            ++i;
        }
        Integer duplicate = Lib_Array.getNextDuplicate(rows);
        if (duplicate != null) {
            throw new RuntimeError(cr, "Duplicated row position", "Same row can't removed twice: " + duplicate);
        }
        Lib_Array.sortGnome(rows, true);
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Lib_Error.ifNotBetween(cr, 1, this.tab.size(), row, "row");
            this.tab.remove(row - 1);
            ++n2;
        }
        return this;
    }

    private ObjectCallResult mEach(CallRuntime crOld, boolean map) {
        crOld.argsNone();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            Err.impossible("No block, no stream, what should I do?");
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = Nil.NIL;
        for (I_Object[] i_ObjectArray : this.tab) {
            handle.startLap();
            I_Object itO = map ? this.iToMap(i_ObjectArray) : this.iToList(i_ObjectArray);
            result = Lib_Exec.execBlockStream(crNew, itO);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new ObjectCallResult(result, true);
    }

    private JMo_Table mFilter(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        ArrayTable<I_Object> result = new ArrayTable<I_Object>(this.tab.width());
        int p = 0;
        while (p < this.tab.size()) {
            I_Object[] test = this.tab.get(p);
            JMo_List list = new JMo_List(test);
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{list}, Bool.class);
            if (ok.getValue().booleanValue()) {
                result.add((T[])test);
            }
            ++p;
        }
        return new JMo_Table(result);
    }

    private I_Object mGetColumn(CallRuntime cr) {
        I_Object x = cr.args(this, A_IntNumber.class)[0];
        int ix = Lib_Convert.getIntValue(cr, x);
        Lib_Error.ifNotBetween(cr, 1, this.tab.width(), ix, "column");
        return this.iToList(this.tab.getColumn(ix - 1));
    }

    private I_Object mGetRow(CallRuntime cr, boolean map) {
        I_Object y = cr.args(this, A_IntNumber.class)[0];
        int iy = Lib_Convert.getIntValue(cr, y);
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), iy, "row");
        I_Object[] it = this.tab.get(iy - 1);
        return map ? this.iToMap(it) : this.iToList(it);
    }

    private ObjectCallResult mGetTitles(CallRuntime cr) {
        SimpleList<I_Object> al = new SimpleList<I_Object>(this.titles.length);
        Collections.addAll(al, this.titles);
        return A_Object.stdResult(new JMo_List(al));
    }

    private void mInit(CallRuntime cr) {
        I_Object[] args = cr.args(this, Int.class, I_Object.class);
        int r = Lib_Convert.getIntValue(cr, args[0]);
        I_Object f = args[1];
        int ir = 0;
        while (ir < r) {
            I_Object[] row = new I_Object[this.tab.width()];
            int iw = 0;
            while (iw < this.tab.width()) {
                row[iw] = f;
                ++iw;
            }
            this.tab.add((T[])row);
            ++ir;
        }
    }

    private JMo_Table mMap(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        ArrayTable<I_Object> result = new ArrayTable<I_Object>(this.tab.width());
        int p = 0;
        while (p < this.tab.size()) {
            I_Object[] test = this.tab.get(p);
            JMo_List testr = (JMo_List)cr.copyEach(method).argsEach(this, 0, test, JMo_List.class);
            I_Object[] row = ((SimpleList)testr.getInternalCollection()).toArray((T[])new I_Object[this.tab.width()]);
            result.addRow((I_Object[])row);
            ++p;
        }
        return new JMo_Table(result);
    }

    private I_Object mReduce(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)3, cr, this);
        I_Object sum = cr.argsOneAdvance(this, 0, I_Object.class);
        for (I_Object[] i_ObjectArray : this.tab) {
            I_Object[] each = new I_Object[]{sum, new JMo_List(i_ObjectArray)};
            sum = cr.copyEach(method).argsEach(this, 1, each, I_Object.class);
        }
        return sum;
    }

    private I_Object mReverse(CallRuntime cr) {
        cr.argsNone();
        this.tab.reverse();
        return this;
    }

    private I_Object mRotate(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 1);
        ArrayTable<I_Object> newTab = new ArrayTable<I_Object>(this.tab.size());
        POSITION_H dir = POSITION_H.RIGHT;
        if (args.length == 1) {
            POSITION p = ((MagicPosition)cr.argType(args[0], MagicPosition.class)).get();
            if (p != POSITION.LEFT && p != POSITION.RIGHT) {
                throw new RuntimeError(cr, "Invalid direction", "A table can only be rotated to _LEFT or _RIGHT.");
            }
            dir = (POSITION_H)((Object)p);
        }
        if (dir == POSITION_H.LEFT) {
            int col = this.tab.width() - 1;
            while (col >= 0) {
                I_List<I_Object> row = this.tab.getColumn(col);
                I_Object[] rowArray = row.toArray((T[])new I_Object[row.size()]);
                newTab.add((T[])rowArray);
                --col;
            }
        } else {
            int col = 0;
            while (col < this.tab.width()) {
                I_List<I_Object> row = this.tab.getColumn(col);
                I_Object[] rowArray = row.toArray((T[])new I_Object[row.size()]);
                Lib_Array.reverse(rowArray);
                newTab.add((T[])rowArray);
                ++col;
            }
        }
        return new JMo_Table(newTab);
    }

    private JMo_Table mRows(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        ArrayTable<I_Object> newTab = new ArrayTable<I_Object>(this.tab.width());
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int parRow = Lib_Convert.getIntValue(cr, cr.argType(arg, A_IntNumber.class));
            parRow = Lib_Sequence.realPosition(cr, parRow, this.tab.size(), false);
            newTab.add((T[])this.tab.getRow(parRow - 1));
            ++n2;
        }
        return new JMo_Table(newTab);
    }

    private I_Object mSearch(CallRuntime cr, boolean one, boolean first) {
        I_Object[] args = cr.argsVar(this, 1, 1);
        I_Object searchObj = cr.argTypeExt(args[0], Str.class, JMo_RegEx.class);
        ArrayTable<I_Object> result = new ArrayTable<I_Object>(this.tab.width());
        boolean useRegex = searchObj instanceof JMo_RegEx;
        String searchStr = useRegex ? ((JMo_RegEx)searchObj).getValue() : Lib_Convert.getStringValue(cr, searchObj);
        int[] columnIndexes = args.length == 1 ? Lib_Array.intRange(0, this.tab.width() - 1) : this.iVarArgsToIntArray(cr, args, 1, 1, this.tab.width());
        int size = this.tab.size();
        int yStart = first ? 0 : size - 1;
        int yEnd = first ? size : -1;
        int yStep = first ? 1 : -1;
        int y = yStart;
        while (y != yEnd) {
            boolean add = false;
            int[] nArray = columnIndexes;
            int n = columnIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                boolean hit;
                int x = nArray[n2];
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cr, o);
                boolean bl = hit = useRegex ? s.matches(searchStr) : s.equals(searchStr);
                if (hit) {
                    add = true;
                    break;
                }
                ++n2;
            }
            if (add) {
                result.add((T[])this.tab.get(y));
                if (one) break;
            }
            y += yStep;
        }
        if (result.size() == 0) {
            return Nil.NIL;
        }
        if (one) {
            I_Object[] row = (I_Object[])result.getRow(0);
            SimpleList<I_Object> row2 = new SimpleList<I_Object>();
            Collections.addAll(row2, row);
            return new JMo_List(row2);
        }
        return new JMo_Table(result);
    }

    private void mSetFirstRowTitles(CallRuntime cr) {
        cr.argsNone();
        if (this.tab.size() == 0) {
            throw new RuntimeError(cr, "Invalid amount of rows", "The table must contain at least one row to be set as titles.");
        }
        I_Object[] headers = this.tab.remove(0);
        this.setTitles(cr, headers);
    }

    private void mSetTitles(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        this.setTitles(cr, args);
    }

    private I_Object mShuffle(CallRuntime cr) {
        cr.argsNone();
        this.tab.sortRandom();
        return this;
    }

    private I_Object mSort(CallRuntime cr) {
        int tabWidth;
        I_Object[] args = cr.argsVar(this, 0, 0);
        int parLen = args.length;
        if (parLen > (tabWidth = this.tab.width())) {
            throw new RuntimeError(cr, "Too much parameters", "This table has only " + tabWidth + " colums. Got " + parLen + " columns to sort.");
        }
        int[] colOrder = new int[parLen];
        int i = 0;
        while (i < parLen) {
            colOrder[i] = Lib_Convert.getIntValue(cr, cr.argType(args[i], A_IntNumber.class));
            ++i;
        }
        int[] nArray = colOrder;
        int n = colOrder.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            Lib_Error.ifNotBetween(cr, 1, this.tab.width(), Math.abs(i), "column");
            ++n2;
        }
        this.tab.sort(colOrder);
        return this;
    }

    private Str mStyle(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String style = Lib_Convert.getStringValue(cr, arg);
        List<String> parts = ConvertString.toList(':', style);
        Lib_Error.ifNotBetween(cr, 0, 3, parts.size(), "Amount of parts");
        String result = Lib_TableStyle.compute(cr, this.tab, parts.toArray(new String[3]));
        return new Str(result);
    }
}

