/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object;

import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.stream.Lib_InputStream;
import de.mn77.base.sys.file.Lib_Jar;
import java.io.InputStream;
import java.util.ArrayList;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.error.RuntimeWarning;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.ObjectManager;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Function;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Help
extends A_Object {
    private static final String JAR_HELP_TYPE_FUNC = "/jar/help/functions.txt";
    private static final String JAR_HELP_TYPE_NEW = "/jar/help/constructors.txt";
    private static final String JAR_HELP_TYPE_EXTENDS = "/jar/help/extends.txt";

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "quick": 
            case "quickly": {
                this.mQuickly(cr);
                return A_Object.stdResult(this);
            }
            case "explain": {
                this.mExplain(cr);
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    private void iAddFunctionsOfType(SimpleList<String> functions, ArrayList<String> funcLines, boolean starts, String filter, String t) {
        t = String.valueOf(t) + '.';
        int len = t.length();
        for (String line : funcLines) {
            if (!line.startsWith(t)) continue;
            line = line.substring(len);
            if (starts) {
                if (!line.toLowerCase().startsWith(filter)) continue;
                functions.add(line);
                continue;
            }
            if (!FilterString.before(new char[]{'(', '\u00a7'}, false, line.toLowerCase()).contains(filter)) continue;
            functions.add(line);
        }
    }

    private boolean iCheckType(String type) {
        int len = type.length();
        if (len < 2) {
            return false;
        }
        char[] cArray = type.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) {
                return false;
            }
            ++n2;
        }
        return type.charAt(len - 1) != '_';
    }

    private Group2<Boolean, String> iFilter(String search) {
        if ((search = search.trim()).endsWith("*")) {
            search = search.substring(0, search.length() - 1);
        }
        if (search.startsWith("*")) {
            return new Group2<Boolean, String>(false, search.substring(1));
        }
        return new Group2<Boolean, String>(true, search);
    }

    private void iOutputFunction(CallRuntime cr, String data) {
        data = FilterString.before(new char[]{'#'}, false, data).trim();
        data = Lib_String.replace(data, '\u00a7', "   --> ");
        Lib_Output.out(cr, data, true);
    }

    private void iShowConstructors(CallRuntime cr, String search) {
        Group2<Boolean, String> filter = this.iFilter(search);
        try {
            InputStream is = Lib_Jar.getStream(JAR_HELP_TYPE_NEW);
            ArrayList<String> lines = Lib_InputStream.readLines(is, true);
            for (String line : lines) {
                if (((Boolean)filter.o1).booleanValue()) {
                    if (!line.toLowerCase().startsWith((String)filter.o2)) continue;
                    Lib_Output.out(cr, line, true);
                    continue;
                }
                if (!line.toLowerCase().contains((CharSequence)filter.o2)) continue;
                Lib_Output.out(cr, line, true);
            }
        }
        catch (Err_FileSys e) {
            Err.exit(e);
        }
    }

    private void iShowFunctionDetailed(CallRuntime cr, String search) {
        try {
            InputStream is = Lib_Jar.getStream(JAR_HELP_TYPE_FUNC);
            ArrayList<String> lines = Lib_InputStream.readLines(is, true);
            search = search.toLowerCase();
            String filterDirect = String.valueOf(search) + '(';
            String filterLink = "\u00a7" + search;
            String typeLow = FilterString.untilFirst('.', search).toLowerCase();
            SimpleList<String> data = new SimpleList<String>(lines.size());
            SimpleList<String> aliases = new SimpleList<String>(lines.size());
            for (String line : lines) {
                String lineLow = line.toLowerCase();
                if (lineLow.startsWith(filterDirect)) {
                    data.add(line);
                    continue;
                }
                if (!lineLow.startsWith(typeLow) || !lineLow.contains(filterLink)) continue;
                aliases.add(line);
            }
            if (data.size() == 0 && aliases.size() > 0) {
                search = FilterString.afterFirst('\u00a7', (String)aliases.get(0));
                this.iShowFunctionDetailed(cr, search);
                return;
            }
            if (data.size() == 0) {
                Lib_Output.out(cr, "Unknown function", true);
                return;
            }
            String func = FilterString.beforeFirst('(', (String)data.get(0)).trim();
            String returns = FilterString.beforeFirst('#', FilterString.afterFirst(')', (String)data.get(0))).trim();
            StringBuilder out = new StringBuilder();
            out.append(func);
            out.append('\n');
            out.append("  => ");
            out.append(returns);
            out.append('\n');
            for (String alias : aliases) {
                out.append("  <--  ");
                out.append(alias);
                out.append('\n');
            }
            for (String f : data) {
                out.append('\n');
                String funcArgs = FilterString.fromFirst('.', FilterString.untilFirst(')', f)).trim();
                String description = FilterString.afterFirst('#', f).trim();
                if (funcArgs.endsWith("()")) {
                    funcArgs = funcArgs.substring(0, funcArgs.length() - 2);
                }
                out.append(funcArgs);
                out.append('\n');
                out.append("# ");
                out.append(description);
                out.append('\n');
            }
            Lib_Output.out(cr, out.toString(), false);
        }
        catch (Err_FileSys e) {
            Err.exit(e);
        }
    }

    private void iShowFunctions(CallRuntime cr, String type, SimpleList<String> functions) {
        functions.sort();
        for (String func : functions) {
            boolean isMath = Lib_Function.isMathematicFunction(func);
            StringBuilder sb = new StringBuilder();
            sb.append(type);
            sb.append(isMath ? (char)' ' : '.');
            sb.append(func);
            this.iOutputFunction(cr, sb.toString());
        }
    }

    private void iShowFunctions(CallRuntime cr, String searchLow, String search) {
        String type = FilterString.beforeFirst('.', searchLow);
        Group2<Boolean, String> filter = this.iFilter(searchLow.substring(type.length() + 1));
        if (!this.iCheckType(type)) {
            throw new RuntimeWarning(cr, "Invalid type name", "Got: " + search);
        }
        try {
            InputStream is2 = Lib_Jar.getStream(JAR_HELP_TYPE_EXTENDS);
            ArrayList<String> extendsLines = Lib_InputStream.readLines(is2, true);
            ArrayList<String> types = new ArrayList<String>();
            String curType = type;
            while (curType.length() > 0) {
                boolean hit = false;
                for (String line : extendsLines) {
                    String t;
                    if (line.toLowerCase().startsWith(String.valueOf(type.toLowerCase()) + '\u00a7') && !(t = FilterString.beforeFirst('\u00a7', line)).equals(type)) {
                        type = t;
                    }
                    if (!line.toLowerCase().startsWith(String.valueOf(curType.toLowerCase()) + '\u00a7')) continue;
                    curType = FilterString.afterFirst('\u00a7', line);
                    if (curType.length() > 0) {
                        types.add(curType);
                    }
                    hit = true;
                    break;
                }
                if (!hit) break;
            }
            InputStream is = Lib_Jar.getStream(JAR_HELP_TYPE_FUNC);
            ArrayList<String> funcLines = Lib_InputStream.readLines(is, true);
            SimpleList<String> functionsSelf = new SimpleList<String>();
            SimpleList<String> functionsExt = new SimpleList<String>();
            SimpleList<String> functionsObj = new SimpleList<String>();
            this.iAddFunctionsOfType(functionsSelf, funcLines, (Boolean)filter.o1, (String)filter.o2, type);
            for (String t : types) {
                if (t.equals("Object")) {
                    this.iAddFunctionsOfType(functionsObj, funcLines, (Boolean)filter.o1, (String)filter.o2, t);
                    continue;
                }
                this.iAddFunctionsOfType(functionsExt, funcLines, (Boolean)filter.o1, (String)filter.o2, t);
            }
            this.iShowFunctions(cr, type, functionsSelf);
            if (functionsSelf.size() > 0 && functionsExt.size() > 0) {
                Lib_Output.out(cr, "----- Abstract -------------------------", true);
            }
            this.iShowFunctions(cr, type, functionsExt);
            if ((functionsSelf.size() > 0 || functionsExt.size() > 0) && functionsObj.size() > 0) {
                Lib_Output.out(cr, "----- Object ---------------------------", true);
            }
            this.iShowFunctions(cr, type, functionsObj);
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, e.getMessage(), search);
        }
    }

    private void iShowTypeDetailed(CallRuntime cr, String s) {
        cr.getStrict().checkSandbox(cr, "jaymo.allTypes");
        SimpleList<String> names = ObjectManager.allTypes(cr);
        String data = null;
        String search = s.toLowerCase();
        for (String name : names) {
            if (!name.toLowerCase().startsWith(s)) continue;
            data = name;
            break;
        }
        if (data == null) {
            this.iShowTypes(cr, search);
            return;
        }
        String typeName = FilterString.beforeFirst('(', data);
        Class<?> clazz = ObjectManager.searchJavaJMoClass(data);
        SimpleList<Class<?>> list = Lib_Type.getTypeClassesList(clazz);
        SimpleList<String> types = new SimpleList<String>(list.size());
        for (Class<?> cl : list) {
            String name = Lib_Type.getName(cl, null);
            if (name.equals(typeName)) continue;
            types.add(name);
        }
        String extendings = ConvertSequence.toString(" -> ", types);
        StringBuilder sb = new StringBuilder();
        sb.append("= ");
        sb.append(typeName);
        sb.append(" =");
        sb.append('\n');
        sb.append("-> ");
        sb.append(extendings);
        Lib_Output.out(cr, sb.toString(), true);
    }

    private void iShowTypes(CallRuntime cr, String search) {
        cr.getStrict().checkSandbox(cr, "jaymo.allTypes");
        Group2<Boolean, String> filter = this.iFilter(search);
        SimpleList<String> names = ObjectManager.allTypes(cr);
        for (String name : names) {
            if (((Boolean)filter.o1).booleanValue()) {
                if (!name.toLowerCase().startsWith((String)filter.o2)) continue;
                Lib_Output.out(cr, name, true);
                continue;
            }
            if (!name.toLowerCase().contains((CharSequence)filter.o2)) continue;
            Lib_Output.out(cr, name, true);
        }
    }

    private void mExplain(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String s = Lib_Convert.getStringValue(cr, arg).toLowerCase();
        if (s.indexOf(46) > -1) {
            this.iShowFunctionDetailed(cr, s);
        } else if (s.indexOf(40) > -1) {
            this.iShowConstructors(cr, s);
        } else {
            this.iShowTypeDetailed(cr, s);
        }
    }

    private void mQuickly(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String search = Lib_Convert.getStringValue(cr, arg);
        String lower = search.toLowerCase();
        if (lower.indexOf(46) > -1) {
            this.iShowFunctions(cr, lower, search);
        } else if (lower.indexOf(40) > -1) {
            this.iShowConstructors(cr, lower);
        } else {
            this.iShowTypes(cr, lower);
        }
    }
}

