/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.xml;

import de.mn77.base.data.struct.SimpleList;
import org.jaymo_lang.error.JayMoError;
import org.jaymo_lang.lib.xml.Lib_XmlTextTable;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JMo_XmlNode
extends A_ObjectSimple {
    protected Node node = null;

    public JMo_XmlNode(Node n) {
        this.node = n;
    }

    @Override
    protected final I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "name": {
                cr.argsNone();
                return new Str(this.node.getNodeName());
            }
            case "text": {
                cr.argsNone();
                return new Str(this.node.getTextContent());
            }
            case "nodes": {
                return this.mNodes(cr);
            }
            case "attr": 
            case "attribute": {
                return this.mAttribute(cr);
            }
            case "attributes": {
                return this.mAttributes(cr);
            }
            case "stringTable": 
            case "strTable": {
                return this.mStrTable(cr);
            }
            case "get": 
            case "getFirst": {
                return this.mGetFirst(cr);
            }
        }
        return this.call4(cr, method);
    }

    protected I_Object call4(CallRuntime cr, String method) {
        return null;
    }

    private void iNodes(CallRuntime cr, SimpleList<I_Object> list, Node node, I_Object[] args, int argOffset) {
        String filter = Lib_Convert.getStringValue(cr, args[argOffset]);
        if (node.getNodeName().equals(filter)) {
            if (args.length - 1 == argOffset) {
                list.add(new JMo_XmlNode(node));
            } else {
                this.iNodes(cr, list, node, args, argOffset + 1);
            }
        }
        if (argOffset < args.length - 1) {
            NodeList nodes = node.getChildNodes();
            int idx = 0;
            while (idx < nodes.getLength()) {
                Node n = nodes.item(idx);
                this.iNodes(cr, list, n, args, argOffset + 1);
                ++idx;
            }
        }
    }

    private I_Object mAttribute(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String name = Lib_Convert.getStringValue(cr, arg);
        NamedNodeMap attr = this.node.getAttributes();
        if (attr == null) {
            return Nil.NIL;
        }
        Node n = attr.getNamedItem(name);
        return n == null ? Nil.NIL : new Str(n.getNodeValue());
    }

    private I_Object mAttributes(CallRuntime cr) {
        cr.argsNone();
        NamedNodeMap attr = this.node.getAttributes();
        if (attr == null) {
            return new JMo_Map();
        }
        SimpleList<I_Object> keys = new SimpleList<I_Object>();
        SimpleList<I_Object> values = new SimpleList<I_Object>();
        int i = 0;
        while (i < attr.getLength()) {
            Node n = attr.item(i);
            String key = n.getNodeName();
            String value = n.getNodeValue();
            keys.add(new Str(key));
            values.add(new Str(value));
            ++i;
        }
        return new JMo_Map(keys, values);
    }

    private I_Object mGetFirst(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String name = Lib_Convert.getStringValue(cr, arg);
        NodeList nodes = this.node.getChildNodes();
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node n = nodes.item(idx);
            if (n.getNodeName().equals(name)) {
                return new JMo_XmlNode(n);
            }
            ++idx;
        }
        return Nil.NIL;
    }

    private JMo_List mNodes(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        SimpleList<I_Object> result = new SimpleList<I_Object>();
        NodeList nodes = this.node.getChildNodes();
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node n = nodes.item(idx);
            if (args.length == 0) {
                result.add(new JMo_XmlNode(n));
            } else {
                this.iNodes(cr, result, n, args, 0);
            }
            ++idx;
        }
        return new JMo_List(result);
    }

    private JMo_Table mStrTable(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_List.class, JMo_List.class);
        JMo_List rows = (JMo_List)args[0];
        JMo_List cols = (JMo_List)args[1];
        if (this.node == null) {
            throw new JayMoError(cr, "Nothing to read", "No document found!");
        }
        return Lib_XmlTextTable.createTextTable(cr, this.node, rows, cols);
    }
}

