/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing.comp;

import de.mn77.base.data.constant.AXIS;
import de.mn77.base.error.Err;
import java.awt.Component;
import javax.swing.JProgressBar;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.lib.swing.comp.A_Swing_JComponent;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.JMo_Range;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.magic.con.MagicAxis;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Swing_ProgressBar
extends A_Swing_JComponent {
    private JProgressBar bar;
    private final ArgCallBuffer arg0;

    public JMo_Swing_ProgressBar(Call arg) {
        this.arg0 = new ArgCallBuffer(0, arg);
    }

    @Override
    public I_Object callMethod4(CallRuntime cr, String method) {
        switch (method) {
            case "setRange": {
                return this.mSetRange(cr);
            }
            case "setMin": 
            case "setMinimum": {
                int min = Lib_Convert.getIntValue(cr, cr.args(this, A_IntNumber.class)[0]);
                this.bar.setMinimum(min);
                return this;
            }
            case "setMax": 
            case "setMaximum": {
                int max = Lib_Convert.getIntValue(cr, cr.args(this, A_IntNumber.class)[0]);
                this.bar.setMaximum(max);
                return this;
            }
            case "setValue": {
                int value = Lib_Convert.getIntValue(cr, cr.args(this, A_IntNumber.class)[0]);
                this.bar.setValue(value);
                return this;
            }
        }
        return null;
    }

    @Override
    public Component getSwing() {
        return this.bar;
    }

    @Override
    public void init(CallRuntime cr) {
        AXIS axis = this.arg0.init(cr, this, MagicAxis.class).get();
        if (axis == AXIS.X) {
            this.bar = new JProgressBar(0);
        } else if (axis == AXIS.Y) {
            this.bar = new JProgressBar(1);
        } else {
            throw new RuntimeError(cr, "Invalid axis", "Allowed are only horizontal and vertical, but got: " + (Object)((Object)axis));
        }
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        return false;
    }

    private JMo_Swing_ProgressBar mSetRange(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        int min = 0;
        int max = 0;
        if (args.length == 1) {
            JMo_Range range = (JMo_Range)cr.argType(args[0], JMo_Range.class);
            min = Lib_Convert.getIntValue(cr, (I_Object)range.getInternalValues().o1);
            max = Lib_Convert.getIntValue(cr, (I_Object)range.getInternalValues().o2);
        } else {
            min = Lib_Convert.getIntValue(cr, args[0]);
            max = Lib_Convert.getIntValue(cr, args[1]);
        }
        Err.ifTooSmall(0.0, min);
        Err.ifToBig(max - 1, min);
        int sMin = min;
        int sMax = max;
        this.bar.setMinimum(sMin);
        this.bar.setMaximum(sMax);
        this.bar.setValue(sMin);
        return this;
    }
}

