/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing.comp;

import de.mn77.base.data.constant.position.Lib_Position;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.constant.position.POSITION_V;
import de.mn77.lib.graphic.I_ImageX;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.lib.graphic.JMo_Image;
import org.jaymo_lang.lib.swing.I_Swing_Object;
import org.jaymo_lang.lib.swing.comp.A_Swing_JComponent;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Swing_Label
extends A_Swing_JComponent
implements I_Object,
I_Swing_Object {
    private JLabel label;
    private final ArgCallBuffer arg0;
    private final ArgCallBuffer arg1;
    private final ArgCallBuffer arg2;

    public JMo_Swing_Label() {
        this.arg0 = null;
        this.arg1 = null;
        this.arg2 = null;
    }

    public JMo_Swing_Label(Call arg) {
        this.arg0 = new ArgCallBuffer(0, arg);
        this.arg1 = null;
        this.arg2 = null;
    }

    public JMo_Swing_Label(Call arg, Call align) {
        this.arg0 = new ArgCallBuffer(0, arg);
        this.arg1 = new ArgCallBuffer(1, align);
        this.arg2 = null;
    }

    public JMo_Swing_Label(Call arg, Call align, Call wrap) {
        this.arg0 = new ArgCallBuffer(0, arg);
        this.arg1 = new ArgCallBuffer(1, align);
        this.arg2 = new ArgCallBuffer(2, wrap);
    }

    @Override
    public I_Object callMethod4(CallRuntime cr, String method) {
        switch (method) {
            case "setText": {
                Str s = (Str)cr.args(this, Str.class)[0];
                this.label.setText(s.getValue());
                return this;
            }
            case "getText": {
                cr.argsNone();
                String text = this.label.getText();
                return new Str(text);
            }
            case "setImage": 
            case "setIcon": {
                I_Object img = cr.argsExt(this, new Class[][]{{JMo_Image.class, Nil.class}})[0];
                Icon icon = img == Nil.NIL ? null : ((JMo_Image)img).internalGet().getIcon();
                this.label.setIcon(icon);
                return this;
            }
            case "setAlign": {
                this.align(cr);
                return this;
            }
        }
        return null;
    }

    @Override
    public JLabel getSwing() {
        return this.label;
    }

    @Override
    public void init(CallRuntime cr) {
        this.label = new JLabel();
        if (this.arg0 != null) {
            I_Object obj = this.arg0.initExt(cr, this, Str.class, JMo_Image.class);
            if (obj instanceof Str) {
                String text = Lib_Convert.getStringValue(cr, obj);
                this.label.setText(text);
            } else {
                I_ImageX imageData = ((JMo_Image)obj).internalGet();
                Icon icon = imageData.getIcon();
                this.label.setIcon(icon);
            }
        }
        if (this.arg1 != null) {
            POSITION pos = this.arg1.init(cr, this, MagicPosition.class).get();
            if (pos == POSITION.LEFT) {
                this.label.setAlignmentX(0.0f);
            } else if (pos == POSITION.CENTER) {
                this.label.setAlignmentX(0.5f);
            } else if (pos == POSITION.RIGHT) {
                this.label.setAlignmentX(1.0f);
            } else {
                throw new RuntimeError(cr, "Invalid position", "Allowed are left, center right, but got: " + pos);
            }
        }
        if (this.arg2 != null) {
            this.arg2.init(cr, this, Bool.class);
        }
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        return false;
    }

    private void align(CallRuntime cr) {
        int sposy;
        int sposx;
        MagicPosition opos = (MagicPosition)cr.args(this, MagicPosition.class)[0];
        POSITION pos = opos.get();
        POSITION_H posh = Lib_Position.getHorizontal(pos);
        int n = posh == POSITION.LEFT ? 2 : (posh == POSITION.RIGHT ? 4 : (sposx = posh == POSITION.CENTER ? 0 : -1));
        if (sposx < 0) {
            throw new RuntimeError(cr, "Invalid position", "Only left, center and right are allowed. Got: " + posh);
        }
        POSITION_V posv = Lib_Position.getVertical(pos);
        int n2 = posv == POSITION.TOP ? 1 : (posv == POSITION.BOTTOM ? 3 : (sposy = posv == POSITION.CENTER ? 0 : -1));
        if (sposy < 0) {
            throw new RuntimeError(cr, "Invalid position", "Only top, center and bottom are allowed. Got: " + posv);
        }
        this.label.setHorizontalAlignment(sposx);
        this.label.setVerticalAlignment(sposy);
    }
}

