/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jaymo_lang.lib.swing.A_Swing_Frame;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Swing_Main
extends A_Swing_Frame {
    private static final HashSet<JMo_Swing_Main> activeMainFrames = new HashSet();

    public static void terminateAll() {
        for (JMo_Swing_Main frame : activeMainFrames) {
            frame.closeFrame(null, false);
        }
        activeMainFrames.clear();
    }

    public JMo_Swing_Main() {
        super(null);
    }

    public JMo_Swing_Main(Call title) {
        super(null, title);
    }

    public JMo_Swing_Main(Call dx, Call dy) {
        super(null, dx, dy);
    }

    public JMo_Swing_Main(Call dx, Call dy, Call title) {
        super(null, dx, dy, title);
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@key": 
            case "@exec": 
            case "@ready": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected I_Object callMethod3(CallRuntime cr, String method) {
        switch (method) {
            case "run": 
            case "start": {
                this.mRun(cr);
                return this;
            }
            case "stop": 
            case "close": {
                this.mStop(cr);
                return Nil.NIL;
            }
            case "setLook": {
                this.mSetLook(cr);
                return this;
            }
            case "getLook": {
                return this.mGetLook(cr);
            }
            case "allLooks": {
                return this.mAllLooks(cr);
            }
        }
        return null;
    }

    private String iSearchLook(String search) {
        UIManager.LookAndFeelInfo info;
        UIManager.LookAndFeelInfo[] lafs;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafs = UIManager.getInstalledLookAndFeels();
        int n = lafs.length;
        int n2 = 0;
        while (n2 < n) {
            info = lookAndFeelInfoArray[n2];
            if (info.getName().contains(search)) {
                return info.getClassName();
            }
            ++n2;
        }
        lookAndFeelInfoArray = lafs;
        n = lafs.length;
        n2 = 0;
        while (n2 < n) {
            info = lookAndFeelInfoArray[n2];
            if (info.getClassName().contains(search)) {
                return info.getClassName();
            }
            ++n2;
        }
        return null;
    }

    private void iSetLook(String s) {
        try {
            String name = this.iSearchLook(s);
            if (name == null) {
                Err.invalid("Look not found", s, name);
            }
            UIManager.setLookAndFeel(name);
        }
        catch (Exception ex) {
            Err.exit(ex);
        }
    }

    private JMo_List mAllLooks(CallRuntime cr) {
        cr.argsNone();
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        SimpleList<I_Object> al = new SimpleList<I_Object>(lafs.length);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafs;
        int n = lafs.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            al.add(new Str(info.getName()));
            ++n2;
        }
        return new JMo_List(al);
    }

    private Str mGetLook(CallRuntime cr) {
        cr.argsNone();
        String currentLook = UIManager.getLookAndFeel().getName();
        return new Str(currentLook);
    }

    private void mRun(CallRuntime cr) {
        cr.argsNone();
        this.setRunState(cr, true);
        cr.getApp().registerFork();
        activeMainFrames.add(this);
        SwingUtilities.invokeLater(() -> {
            this.frame.setLocationRelativeTo(null);
            this.frame.setDefaultCloseOperation(2);
            this.frame.setVisible(true);
            Dimension sizeDim = this.frame.getSize();
            if (!(this.frame.isMinimumSizeSet() || this.frame.isPreferredSizeSet() || this.frame.isMaximumSizeSet() || sizeDim.height != 0 || sizeDim.width != 0)) {
                this.frame.setExtendedState(this.frame.getExtendedState() | 6);
            }
            this.eventRun(cr, "@ready", this);
        });
        cr.getApp().doAtCalledExit(() -> this.cleanUp(cr));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (e.getID() != 402) {
                return false;
            }
            if (e.getKeyCode() == 10 && e.getModifiersEx() == 0) {
                this.eventRun(cr, "@exec", this);
            } else {
                SimpleList<I_Object> al = new SimpleList<I_Object>(2);
                al.add(new Char(e.getKeyChar()));
                al.add(new Int(e.getModifiersEx()));
                this.eventRun(cr, "@key", new JMo_List(al));
            }
            return false;
        });
    }

    private void mSetLook(CallRuntime cr) {
        Str os = (Str)cr.args(this, Str.class)[0];
        String s = Lib_Convert.getStringValue(cr, os);
        this.iSetLook(s);
        this.frame.repaint();
    }

    private void mStop(CallRuntime cr) {
        cr.argsNone();
        this.closeFrame(cr, true);
        activeMainFrames.remove(this);
    }
}

