/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.struct;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.lib.struct.RelationSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_RelationSet
extends A_ObjectSimple {
    private final ArgCallBuffer initArg;
    private RelationSet<I_Object> rs = null;

    public JMo_RelationSet(Call size) {
        this.initArg = new ArgCallBuffer(0, size);
    }

    @Override
    public void init(CallRuntime cr) {
        Int arg = this.initArg.init(cr, this, Int.class);
        int size = arg.getValue();
        this.rs = new RelationSet(size);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTypeName()) + "<" + this.rs.used() + ">";
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return type == STYPE.DESCRIBE ? this.rs.toString() : this.toString();
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "put": {
                return this.mPut(cr);
            }
            case "link": {
                return this.mLink(cr);
            }
            case "linked": {
                return this.mLinked(cr);
            }
            case "linkedWith": {
                return this.mLinkedWith(cr);
            }
            case "getRelation": {
                return this.mGetRelation(cr);
            }
            case "setRelation": {
                return this.mSetRelation(cr);
            }
            case "relatedWith": {
                return this.mRelatedWith(cr);
            }
            case "unlink": {
                return this.mUnlink(cr);
            }
            case "length": 
            case "len": {
                return this.mLength(cr);
            }
            case "size": {
                return this.mSize(cr);
            }
        }
        return null;
    }

    private JMo_Dec mGetRelation(CallRuntime cr) {
        I_Object[] args = cr.args(this, I_Object.class, I_Object.class);
        double r = this.rs.getRelation(args[0], args[1]);
        return JMo_Dec.valueOf(cr, r);
    }

    private Int mLength(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.rs.used());
    }

    private JMo_RelationSet mLink(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 1);
        int i = 1;
        while (i < args.length) {
            try {
                this.rs.link(args[0], args[i]);
            }
            catch (Exception e) {
                throw new RuntimeError(cr, "Link failed", e.getMessage());
            }
            ++i;
        }
        return this;
    }

    private Bool mLinked(CallRuntime cr) {
        I_Object[] args = cr.args(this, I_Object.class, I_Object.class);
        boolean b = this.rs.linked(args[0], args[1]);
        return Bool.getObject(b);
    }

    private JMo_List mLinkedWith(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        SimpleList<I_Object> linked = this.rs.linkedWith(arg);
        return new JMo_List(linked);
    }

    private JMo_RelationSet mPut(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.rs.put(o);
            ++n2;
        }
        return this;
    }

    private JMo_Map mRelatedWith(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        HashMap<I_Object, Double> linked = this.rs.relatedWith(arg);
        Set<I_Object> keySet = linked.keySet();
        SimpleList<I_Object> keys = new SimpleList<I_Object>(keySet.size());
        keys.addAll((Collection<I_Object>)keySet);
        SimpleList<I_Object> objects = new SimpleList<I_Object>(linked.values().size());
        for (Double d : linked.values()) {
            objects.add(JMo_Dec.valueOf(cr, d));
        }
        return new JMo_Map(keys, objects);
    }

    private JMo_RelationSet mSetRelation(CallRuntime cr) {
        I_Object[] args = cr.args(this, I_Object.class, I_Object.class, A_Number.class);
        double value = Lib_Convert.getDoubleValue(cr, args[2]);
        Lib_Error.ifNotBetween(cr, 0.0, 1.0, value, "value");
        this.rs.setRelation(args[0], args[1], value);
        return this;
    }

    private Int mSize(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.rs.size());
    }

    private JMo_RelationSet mUnlink(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 1);
        I_Object base = args[0];
        int i = 1;
        while (i < args.length) {
            this.rs.unlink(base, args[i]);
            ++i;
        }
        return this;
    }
}

