/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.udp;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.event.A_EnumEventHandler;
import de.mn77.base.sys.MOut;
import de.mn77.base.thread.A_AutoDaemon;
import de.mn77.lib.udp.UDP_Packet;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.function.Consumer;

public class UDP
extends A_EnumEventHandler {
    private A_AutoDaemon daemon = null;
    private final DatagramSocket socket;

    public UDP(int port) throws SocketException {
        this.socket = new DatagramSocket(port);
    }

    public boolean isActive() {
        return this.daemon != null && !this.daemon.isFinished() && this.socket != null && this.socket.isBound() && !this.socket.isClosed();
    }

    public void onError(Consumer<IOException> z) {
        this.eventAdd(EVENTS.ERROR, z);
    }

    public void onRecieve(Consumer<UDP_Packet> z) {
        this.eventAdd(EVENTS.RECIEVE, z);
    }

    public void send(UDP_Packet paket) throws IOException {
        this.socket.send(paket.getDatagram());
    }

    public void start() {
        this.daemon = new A_AutoDaemon(){

            @Override
            protected void cycle() {
                DatagramPacket paket = new DatagramPacket(new byte[65535], 65535);
                try {
                    UDP.this.socket.setSoTimeout(1000);
                    UDP.this.socket.receive(paket);
                }
                catch (SocketTimeoutException e) {
                    return;
                }
                catch (IOException e) {
                    MOut.temp(e.getMessage());
                    UDP.this.eventStart(EVENTS.ERROR, e);
                    Err.show(e);
                }
                UDP.this.eventStart(EVENTS.RECIEVE, new UDP_Packet(paket));
            }
        };
    }

    public void stop() {
        if (this.daemon == null) {
            throw new Err_Runtime("Service not startet", new Object[0]);
        }
        this.daemon.finish();
        try {
            this.socket.setSoTimeout(1);
            this.socket.disconnect();
            this.socket.close();
        }
        catch (SocketException e) {
            Err.show(e);
        }
        this.daemon = null;
    }

    private static enum EVENTS {
        ERROR,
        RECIEVE;

    }
}

