/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.terminal;

import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.lib.terminal.CSI_COLOR_BG;
import de.mn77.lib.terminal.CSI_COLOR_FG;
import de.mn77.lib.terminal.MTerminal;
import java.io.IOException;

public abstract class A_DefaultCLI {
    private static final Object EXIT_MESSAGE = "Have a wonderful day!";

    protected abstract String computePrompt();

    protected abstract void exec(String var1) throws Err_FileSys;

    protected abstract void headline(MTerminal var1);

    protected void headlineDefault(MTerminal terminal, String name, String version, String date, CSI_COLOR_BG titleBG) {
        String delimiter = "  /  ";
        if (terminal.isInRawMode()) {
            terminal.print(new Object[]{titleBG, CSI_COLOR_FG.WHITE, name, CSI_COLOR_BG.DEFAULT});
            terminal.print(new Object[]{"  ", CSI_COLOR_FG.GREEN, version});
            terminal.print(new Object[]{CSI_COLOR_FG.DARKGRAY, "  /  "});
            terminal.print(new Object[]{CSI_COLOR_FG.LIGHTMAGENTA, date});
            terminal.print(new Object[]{CSI_COLOR_FG.DEFAULT});
            terminal.print("\r\n\n");
        } else {
            terminal.print(name);
            terminal.print("  ");
            terminal.print(version);
            terminal.print("  /  ");
            terminal.print(date);
            terminal.print("\n\n");
        }
    }

    protected boolean readTerminal(MTerminal terminal, String in) throws IOException, Err_FileSys {
        String uin = in;
        if (uin == null) {
            uin = this.iReadline(terminal);
        }
        if (uin == null || uin.equals("exit") || uin.equals("quit") || uin.equals("q")) {
            terminal.print(terminal.isInRawMode() ? "\r\n" : "\n");
            terminal.closeTerminal();
            return false;
        }
        boolean rawBefore = terminal.temporaryCooked();
        this.exec(uin);
        terminal.temporaryReset(rawBefore);
        return true;
    }

    protected void runTerminal(boolean debug) throws IOException, Err_FileSys {
        final MTerminal terminal = new MTerminal();
        if (debug) {
            terminal.setDebug();
        }
        if (terminal.isInRawMode()) {
            MOut.setLineBreak("\r\n");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                terminal.closeTerminal();
            }
        });
        this.headline(terminal);
        boolean run = true;
        while (run) {
            run = this.readTerminal(terminal, null);
        }
        MOut.print(EXIT_MESSAGE);
    }

    private String iReadline(MTerminal terminal) throws IOException {
        String prompt = this.computePrompt();
        if (terminal.isInRawMode()) {
            terminal.print(new Object[]{CSI_COLOR_BG.DEFAULT, CSI_COLOR_FG.LIGHTBLUE, prompt, CSI_COLOR_FG.DEFAULT});
            String input = terminal.readLine();
            terminal.print("\r\n");
            return input;
        }
        terminal.print(prompt);
        return terminal.readLine();
    }
}

