/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.ntp;

import de.mn77.base.error.Err;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NTP_Message {
    public byte warnings = 0;
    public byte version = (byte)3;
    public byte mode = 0;
    public short getRanking = 0;
    public byte queryFrequency = 0;
    public byte accuracy = 0;
    public double rootServerDelay = 0.0;
    public double rootServerVariance = 0.0;
    public byte[] senderIdent = new byte[4];
    public double lastSenderCorrectedTime = 0.0;
    public double clientSendTime = 0.0;
    public double serverRecieveTime = 0.0;
    public double serverSendTime = 0.0;

    public static void timeDoubleToByte(byte[] target, int pointer, double timestamp) {
        int i = 0;
        while (i < 8) {
            double base = Math.pow(2.0, (3 - i) * 8);
            target[pointer + i] = (byte)(timestamp / base);
            timestamp -= (double)NTP_Message.vzlosByteToShort(target[pointer + i]) * base;
            ++i;
        }
        target[7] = (byte)(Math.random() * 255.0);
    }

    public static String timestampToString(double timestamp) {
        if (timestamp == 0.0) {
            return "0";
        }
        long ms = NTP_Message.timestampToUtc(timestamp);
        String result = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(ms));
        double decimals = timestamp - (double)((long)timestamp);
        return String.valueOf(result) + new DecimalFormat(".000000").format(decimals);
    }

    public static long timestampToUtc(double timestamp) {
        return (long)(timestamp - 2.2089888E9) * 1000L;
    }

    public static double utcToTimestamp(long millisec) {
        return (double)millisec / 1000.0 + 2.2089888E9;
    }

    private static String serverID(byte[] ref, byte version) {
        if (version == 3) {
            return String.valueOf(NTP_Message.vzlosByteToShort(ref[0])) + "." + NTP_Message.vzlosByteToShort(ref[1]) + "." + NTP_Message.vzlosByteToShort(ref[2]) + "." + NTP_Message.vzlosByteToShort(ref[3]);
        }
        if (version == 4) {
            return "" + ((double)NTP_Message.vzlosByteToShort(ref[0]) / 256.0 + (double)NTP_Message.vzlosByteToShort(ref[1]) / 65536.0 + (double)NTP_Message.vzlosByteToShort(ref[2]) / 1.6777216E7 + (double)NTP_Message.vzlosByteToShort(ref[3]) / 4.294967296E9);
        }
        throw Err.todo("Unknown version: " + version);
    }

    private static double timeByteToDouble(byte[] array, int pointer) {
        double result = 0.0;
        int i = 0;
        while (i < 8) {
            result += (double)NTP_Message.vzlosByteToShort(array[pointer + i]) * Math.pow(2.0, (3 - i) * 8);
            ++i;
        }
        return result;
    }

    private static short vzlosByteToShort(byte b) {
        if ((b & 0x80) == 128) {
            return (short)(128 + (b & 0x7F));
        }
        return b;
    }

    public NTP_Message() {
        this.mode = (byte)3;
        this.serverSendTime = NTP_Message.utcToTimestamp(System.currentTimeMillis());
    }

    public NTP_Message(byte[] daten) {
        this.warnings = (byte)(daten[0] >> 6 & 3);
        this.version = (byte)(daten[0] >> 3 & 7);
        this.mode = (byte)(daten[0] & 7);
        this.getRanking = NTP_Message.vzlosByteToShort(daten[1]);
        this.queryFrequency = daten[2];
        this.accuracy = daten[3];
        this.rootServerDelay = (double)daten[4] * 256.0 + (double)NTP_Message.vzlosByteToShort(daten[5]) + (double)NTP_Message.vzlosByteToShort(daten[6]) / 256.0 + (double)NTP_Message.vzlosByteToShort(daten[7]) / 65536.0;
        this.rootServerVariance = (double)NTP_Message.vzlosByteToShort(daten[8]) * 256.0 + (double)NTP_Message.vzlosByteToShort(daten[9]) + (double)NTP_Message.vzlosByteToShort(daten[10]) / 256.0 + (double)NTP_Message.vzlosByteToShort(daten[11]) / 65536.0;
        this.senderIdent[0] = daten[12];
        this.senderIdent[1] = daten[13];
        this.senderIdent[2] = daten[14];
        this.senderIdent[3] = daten[15];
        this.lastSenderCorrectedTime = NTP_Message.timeByteToDouble(daten, 16);
        this.clientSendTime = NTP_Message.timeByteToDouble(daten, 24);
        this.serverRecieveTime = NTP_Message.timeByteToDouble(daten, 32);
        this.serverSendTime = NTP_Message.timeByteToDouble(daten, 40);
    }

    public byte[] dataBytes() {
        byte[] result = new byte[48];
        result[0] = (byte)(this.warnings << 6 | this.version << 3 | this.mode);
        result[1] = (byte)this.getRanking;
        result[2] = this.queryFrequency;
        result[3] = this.accuracy;
        int l = (int)(this.rootServerDelay * 65536.0);
        result[4] = (byte)(l >> 24 & 0xFF);
        result[5] = (byte)(l >> 16 & 0xFF);
        result[6] = (byte)(l >> 8 & 0xFF);
        result[7] = (byte)(l & 0xFF);
        long ul = (long)(this.rootServerVariance * 65536.0);
        result[8] = (byte)(ul >> 24 & 0xFFL);
        result[9] = (byte)(ul >> 16 & 0xFFL);
        result[10] = (byte)(ul >> 8 & 0xFFL);
        result[11] = (byte)(ul & 0xFFL);
        result[12] = this.senderIdent[0];
        result[13] = this.senderIdent[1];
        result[14] = this.senderIdent[2];
        result[15] = this.senderIdent[3];
        NTP_Message.timeDoubleToByte(result, 16, this.lastSenderCorrectedTime);
        NTP_Message.timeDoubleToByte(result, 24, this.clientSendTime);
        NTP_Message.timeDoubleToByte(result, 32, this.serverRecieveTime);
        NTP_Message.timeDoubleToByte(result, 40, this.serverSendTime);
        return result;
    }

    public String toString() {
        String accuracyString = new DecimalFormat("0.#E0").format(Math.pow(2.0, this.accuracy));
        return "Warning: " + this.warnings + "\n" + "Version: " + this.version + "\n" + "Mode: " + this.mode + "\n" + "SenderRanking: " + this.getRanking + "\n" + "SenderAbfragehaeufigkeit: " + this.queryFrequency + "\n" + "Pr\u00e4zision: " + this.accuracy + " (" + accuracyString + " sek)\n" + "Root-Server-Delay: " + new DecimalFormat("0.00").format(this.rootServerDelay * 1000.0) + " ms\n" + "Root-Server-Variance: " + new DecimalFormat("0.00").format(this.rootServerVariance * 1000.0) + " ms\n" + "SenderIdent: " + NTP_Message.serverID(this.senderIdent, this.version) + "\n" + "Sender corrected time: " + NTP_Message.timestampToString(this.lastSenderCorrectedTime) + "\n" + "Client send time: " + NTP_Message.timestampToString(this.clientSendTime) + "\n" + "Server recieve time: " + NTP_Message.timestampToString(this.serverRecieveTime) + "\n" + "Server send time: " + NTP_Message.timestampToString(this.serverSendTime);
    }
}

