/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.version.data;

import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.error.Err;
import de.mn77.base.version.DEVSTAGE;
import de.mn77.base.version.data.I_VersionData;

public abstract class A_VersionData
implements I_VersionData {
    private Long build = 0L;
    private final DEVSTAGE stage;
    private I_DateTime time = null;

    public A_VersionData(DEVSTAGE stage) {
        this.stage = stage;
    }

    public A_VersionData(I_DateTime time, Long build, String[] sa) {
        this.setBuildTime(build, time);
        this.stage = this.parse(sa);
    }

    @Override
    public Long getBuild() {
        return this.build;
    }

    @Override
    public I_DateTime getDateTime() {
        return this.time;
    }

    @Override
    public DEVSTAGE getStage() {
        return this.stage;
    }

    public boolean isDevelopment() {
        return this.stage.isDevelopment();
    }

    public boolean isLoaded() {
        return this.build != 0L;
    }

    @Override
    public final void setBuildTime(Long build, I_DateTime zeit) {
        Err.ifNull(build, zeit);
        this.build = build;
        this.time = zeit;
    }

    public String toBuildString() {
        return this.build + " - " + this.time.getDate();
    }

    public abstract String toString();

    @Override
    public final String toStringFull() {
        return this.toString();
    }

    protected abstract DEVSTAGE parse(String[] var1);
}

