/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.cmd;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.stream.UTF8OutputStream;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.cmd.SYSCMD_IO;
import de.mn77.base.sys.cmd.SysCmdData;
import de.mn77.base.sys.cmd.SysCmdResult;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.thread.A_ParallelProcess;
import java.io.IOException;

public class SysCmd {
    public static SysCmdResult exec(boolean shellEnv, boolean wait, I_Directory workingDir, String cmd, String ... args) throws Exception {
        SysCmdData data = new SysCmdData(shellEnv, wait, SYSCMD_IO.LIVE, cmd, args);
        data.setWorkingDir(workingDir);
        return new SysCmd().exec(data);
    }

    public static SysCmdResult exec(boolean shellEnv, boolean wait, String cmd, String ... args) throws Exception {
        return SysCmd.exec(shellEnv, wait, null, cmd, args);
    }

    public SysCmdResult exec(SysCmdData data) throws Err_Exception {
        Err.ifNull(data, data.command);
        Thread handleOutput = null;
        Thread handleError = null;
        Thread handleInput = null;
        UTF8OutputStream bufferOutput = null;
        UTF8OutputStream bufferError = null;
        String[] args = data.environment ? this.iCommandWithEnv(data) : this.iCommandWithoutEnv(data);
        try {
            ProcessBuilder pb = new ProcessBuilder(args);
            if (data.getWorkingDir() != null) {
                pb.directory(data.getWorkingDir().getFile());
            }
            switch (data.inout) {
                case LIVE: {
                    pb.inheritIO();
                    break;
                }
                case DISCARD: {
                    pb.redirectOutput(ProcessBuilder.Redirect.DISCARD);
                    pb.redirectError(ProcessBuilder.Redirect.DISCARD);
                    break;
                }
                case CUSTOM: {
                    break;
                }
                case BUFFER: {
                    pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
                }
            }
            Process process = pb.start();
            if (!data.wait) {
                SysCmdResult sysCmdResult = new SysCmdResult(process);
                return sysCmdResult;
            }
            switch (data.inout) {
                case BUFFER: {
                    bufferOutput = new UTF8OutputStream();
                    handleOutput = Lib_Stream.connectWithInputBuffer(process.getInputStream(), bufferOutput);
                    bufferError = new UTF8OutputStream();
                    handleError = Lib_Stream.connectWithInputBuffer(process.getErrorStream(), bufferError);
                    break;
                }
                case CUSTOM: {
                    if (data.getStreamOutput() != null) {
                        handleOutput = Lib_Stream.connectWithInputBuffer(process.getInputStream(), data.getStreamOutput());
                    }
                    if (data.getStreamError() != null) {
                        handleError = Lib_Stream.connectWithInputBuffer(process.getErrorStream(), data.getStreamError());
                    }
                    if (data.getStreamInput() == null) break;
                    handleInput = Lib_Stream.connectWithOutputBuffer(data.getStreamInput(), process.getOutputStream());
                }
            }
            int result = process.waitFor();
            if (handleOutput != null) {
                handleOutput.interrupt();
                while (!((A_ParallelProcess)handleOutput).isFinished()) {
                    Thread.yield();
                }
            }
            if (handleError != null) {
                handleError.interrupt();
                while (!((A_ParallelProcess)handleError).isFinished()) {
                    Thread.yield();
                }
            }
            if (bufferOutput != null) {
                bufferOutput.close();
            }
            if (bufferError != null) {
                bufferError.close();
            }
            SysCmdResult sysCmdResult = new SysCmdResult(process, bufferOutput == null ? null : bufferOutput.getString(), bufferError == null ? null : bufferError.getString(), result);
            return sysCmdResult;
        }
        catch (IOException e) {
            throw Err.wrap(e, "External process was not executed cleanly!", data);
        }
        catch (InterruptedException e1) {
            throw Err.wrap(e1, "External process was not executed cleanly!", data);
        }
        finally {
            try {
                if (bufferOutput != null) {
                    bufferOutput.close();
                }
                if (bufferError != null) {
                    bufferError.close();
                }
                if (handleOutput != null) {
                    handleOutput.interrupt();
                }
                if (handleError != null) {
                    handleError.interrupt();
                }
                if (handleInput != null) {
                    handleInput.interrupt();
                }
            }
            catch (IOException e) {
                throw Err.wrap(e, new Object[0]);
            }
        }
    }

    private String[] iCommandWithEnv(SysCmdData data) {
        StringBuilder cmd = new StringBuilder();
        if (data.arguments != null && data.arguments.length > 0) {
            cmd.append(data.command);
            String[] stringArray = data.arguments;
            int n = data.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                cmd.append(" ");
                cmd.append(arg);
                ++n2;
            }
        } else {
            cmd.append(data.command);
        }
        if (Sys.isLinux()) {
            return new String[]{"bash", "-c", cmd.toString()};
        }
        if (Sys.isWindows()) {
            return new String[]{"cmd", "/c", cmd.toString()};
        }
        if (Sys.isMac()) {
            return new String[]{"open", "-a", cmd.toString()};
        }
        return new String[]{cmd.toString()};
    }

    private String[] iCommandWithoutEnv(SysCmdData data) {
        if (data.arguments == null || data.arguments.length == 0) {
            return new String[]{data.command};
        }
        String[] result = new String[1 + data.arguments.length];
        result[0] = data.command;
        System.arraycopy(data.arguments, 0, result, 1, data.arguments.length);
        return result;
    }
}

