/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.stream;

import de.mn77.base.data.struct.atomic.ByteList;
import de.mn77.base.error.Err;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class UTF8OutputStream
extends OutputStream {
    boolean closed = false;
    private final ByteList buffer = new ByteList();

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public String getString() {
        if (!this.closed) {
            Err.forbidden("Stream not closed!");
        }
        try {
            return new String(this.buffer.toArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw Err.exit(e2);
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.closed) {
            Err.forbidden("Stream is closed!");
        }
        this.buffer.add((byte)c);
    }
}

