/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table.type;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.I_Collection;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.data.struct.table.type.I_TypeTable;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.Iterator;

public abstract class A_TypeTable<TG>
implements I_TypeTable<TG> {
    private static final String ERR_ADD_WIDTH = "The number of items does not match the width of the table";
    private final Class<?>[] classes;

    protected A_TypeTable(Class<?> ... classes) {
        this.classes = classes;
    }

    @Override
    public void add(Object ... row) {
        Err.ifNot(this.width(), row.length, ERR_ADD_WIDTH);
        int col = 0;
        while (col < this.width()) {
            this.isValid(col, row[col]);
            ++col;
        }
        this.pAdd(row);
    }

    @Override
    public I_TypeTable<TG> copy() {
        throw Err.todo(new Object[0]);
    }

    @Override
    public void exchange(int rowA, int rowB) {
        Err.ifOutOfBounds(0, this.size() - 1, rowA);
        Err.ifOutOfBounds(0, this.size() - 1, rowB);
        if (rowA == rowB) {
            MOut.warning("Exchange of " + rowA + " and " + rowB + " not necessary!");
            return;
        }
        this.pExchange(rowA, rowB);
    }

    @Override
    public TG get(int row) {
        return this.getRow(row);
    }

    @Override
    public Object get(int col, int row) {
        return this.getColumn(col).get(row);
    }

    @Override
    public void insert(int row, Object ... objects) {
        Err.ifNot(this.width(), objects.length, ERR_ADD_WIDTH);
        int col = 0;
        while (col < this.width()) {
            this.isValid(col, objects[col]);
            ++col;
        }
        this.pInsert(row, objects);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<TG> iterator() {
        final A_TypeTable table = this;
        return new Iterator<TG>(){
            private int nextRow = 0;

            @Override
            public boolean hasNext() {
                return this.nextRow < table.size();
            }

            @Override
            public TG next() {
                Err.ifToBig(table.size() - 1, this.nextRow);
                return table.getRow(this.nextRow++);
            }

            @Override
            public void remove() {
                Err.forbidden(new Object[0]);
            }
        };
    }

    @Override
    public TG remove(int rowIndex) {
        Object row = this.getRow(rowIndex);
        this.pRemove(rowIndex);
        return row;
    }

    @Override
    public TG removeLast() {
        int last = this.size() - 1;
        Object row = this.getRow(last);
        this.pRemove(last);
        return row;
    }

    @Override
    public void replace(int row, Object ... objects) {
        Err.ifOutOfBounds(row, this.size());
        Err.ifEqual(row, 0);
        int s = 0;
        while (s <= this.width()) {
            this.isValid(s, objects[s]);
            ++s;
        }
        this.pReplace(row, objects);
    }

    @Override
    public void set(int col, int row, Object object) {
        Err.ifOutOfBounds(0, this.size() - 1, row);
        Err.ifOutOfBounds(0, this.width() - 1, col);
        this.isValid(col, object);
        this.pSet(col, row, object);
    }

    @Override
    public int size() {
        return this.getColumn(0).size();
    }

    @Override
    public void sort() {
        this.sort(null);
    }

    @Override
    public void sort(int ... columnOrder) {
        Sort.table(this, columnOrder);
    }

    @Override
    public void sortLike(int[] indexes) {
        int col = 0;
        while (col < this.width()) {
            I_Collection<?> data = this.pGetColumn(col);
            int size = data.size();
            Err.ifNot(size, indexes.length, "Length of list and indexes must be equal");
            Object[] buffer = new Object[size];
            int i = 0;
            while (i < size) {
                buffer[i] = data.get(indexes[i]);
                ++i;
            }
            i = 0;
            while (i < size) {
                this.set(col, i, buffer[i]);
                ++i;
            }
            ++col;
        }
    }

    @Override
    public void sortRandom() {
        Sort.sortableRandom(this);
    }

    @Override
    public String toDescribe() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        int[] width = new int[this.width()];
        int i = 0;
        while (i < this.width()) {
            for (Object o : this.getColumn(i)) {
                int osl = ConvertObject.toStringIdent(o).length();
                if (osl <= width[i]) continue;
                width[i] = osl;
            }
            ++i;
        }
        int y = 0;
        while (y < this.size()) {
            sb.append("| ");
            int x = 0;
            while (x < this.width()) {
                if (x > 0) {
                    sb.append(" | ");
                }
                sb.append(FormString.width(width[x], ConvertObject.toStringIdent(this.get(x, y)), false));
                ++x;
            }
            sb.append(" |");
            if (y != this.size()) {
                sb.append("\n");
            }
            ++y;
        }
        return sb.toString();
    }

    @Override
    public String toIdent() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('<');
        sb.append(this.size());
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int row = 0;
        while (row < this.size()) {
            int col = 0;
            while (col < this.width()) {
                sb.append(this.get(col, row) + (col < this.width() - 1 ? "," : ""));
                ++col;
            }
            sb.append("\n");
            ++row;
        }
        return sb.toString();
    }

    protected void isValid(int col, Object o) {
        if (o != null && !this.classes[col].isAssignableFrom(o.getClass())) {
            Err.invalid(o.getClass().getSimpleName());
        }
    }

    protected abstract void pAdd(Object[] var1);

    protected abstract void pExchange(int var1, int var2);

    protected abstract I_Collection<?> pGetColumn(int var1);

    protected abstract void pInsert(int var1, Object[] var2);

    protected abstract void pRemove(int var1);

    protected abstract void pReplace(int var1, Object[] var2);

    protected abstract void pSet(int var1, int var2, Object var3);
}

