/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.keypot;

import de.mn77.base.data.struct.I_Collection;
import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.keypot.A_KeyPot;
import de.mn77.base.data.struct.keypot.I_KeyPot;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;

public class KeyPotList<TA, TB>
extends A_KeyPot<TA, TB>
implements I_KeyPot<TA, TB> {
    private final SimpleList<I_List<TB>> pots = new SimpleList();

    @Override
    public void add(TA key, TB object) {
        Integer pos = this.keys.searchFirst(key);
        if (pos == null) {
            this.keys.add(key);
            SimpleList emptyList = new SimpleList();
            this.pots.add(emptyList);
            pos = this.keys.searchFirst(key);
        }
        this.pots.get(pos).add(object);
    }

    public void clear(TA key) {
        Integer index = this.keys.searchFirst(key);
        if (index == null) {
            Err.invalid(key, "Invalid Key");
        }
        this.pots.get(index).clear();
    }

    @Override
    public KeyPotList<TA, TB> copy() {
        throw Err.todo(new Object[0]);
    }

    @Override
    public void exchange(int row_a, int row_b) {
        Err.ifEqual(row_a, 0);
        Err.ifEqual(row_b, 0);
        Err.ifOutOfBounds(1, this.size(), Math.abs(row_a));
        Err.ifOutOfBounds(1, this.size(), Math.abs(row_b));
        if (row_a == row_b) {
            MOut.warning("Exchange of " + row_a + " and " + row_b + " not necessary!");
            return;
        }
        this.keys.exchange(row_a, row_b);
        this.pots.exchange(row_a, row_b);
    }

    public Object get(int col, int row) {
        if (col == 0) {
            return this.keys.get(row);
        }
        if (col == 1) {
            return this.pots.get(row);
        }
        throw Err.invalid(col);
    }

    @Override
    public I_Collection<TB> getPot(TA key) {
        Integer index = this.keys.searchFirst(key);
        Err.ifNull((Object)index);
        return this.pots.get(index);
    }

    @Override
    public I_Collection<TB> getPot(TA key, I_Collection<TB> ifMissing) {
        Integer pos = this.keys.searchFirst(key);
        if (pos == null) {
            return ifMissing;
        }
        return this.pots.get(pos);
    }

    @Override
    public I_Collection<TB> remove(TA key) {
        Integer index = this.keys.searchFirst(key);
        if (index == null) {
            Err.invalid(key, "Invalid Key");
        }
        I_Collection result = this.pots.get(index);
        this.keys.remove(index);
        this.pots.remove(index);
        return result;
    }

    @Override
    public boolean remove(TA key, TB object) {
        Integer index = this.keys.searchFirst(key);
        if (index == null) {
            Err.invalid(key, "Invalid Key");
        }
        boolean result = false;
        I_List<TB> pot = this.pots.get(index);
        if (pot.contains(object)) {
            if (pot.remove(object)) {
                result = true;
            } else {
                Err.invalid(object, "Unknown Object");
            }
        }
        return result;
    }

    @Override
    public void reverse() {
        this.pots.reverse();
    }

    @Override
    public void sortLike(int[] newOrder) {
        this.keys.sortLike(newOrder);
        this.pots.sortLike(newOrder);
    }
}

