/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.action;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.cmd.SysDefault;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.sys.file.MFile;
import de.mn77.lib.swing.DIALOG_TYPE;
import de.mn77.lib.swing.Lib_SwingDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import org.jaymo_lang.edit.Main_JayMo_Edit;
import org.jaymo_lang.edit.action.EVENTS;
import org.jaymo_lang.edit.action.ExecutionControl;
import org.jaymo_lang.edit.defs.EditorMainPanel;
import org.jaymo_lang.edit.defs.FileEditor;
import org.jaymo_lang.edit.dialog.Dialog_About;
import org.jaymo_lang.edit.editor.funcs.Lib_IndentOutdent;
import org.jaymo_lang.edit.refactor.JayMo_Refactor;

public class JayMo_Actions
implements ActionListener {
    private final Component base;
    private final Main_JayMo_Edit frame;
    private EditorMainPanel main = null;
    private FileEditor editor = null;
    private JButton execButton;
    private JButton terminateButton;
    private final ExecutionControl execControl;
    private final FileFilter jmoFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            MFile mf = new MFile(f);
            return mf.getSuffix().toLowerCase().equals("jmo");
        }

        @Override
        public String getDescription() {
            return "JayMo-Files (*.jmo)";
        }
    };

    public JayMo_Actions(Main_JayMo_Edit frame, Component base) {
        this.frame = frame;
        this.base = base;
        this.execControl = new ExecutionControl();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(EVENTS.CHANGED.name())) {
            this.frame.updateTitle(this.editor);
        } else if (action.equals(EVENTS.EXEC.name())) {
            this.main.clearOutput();
            this.execute();
        } else if (action.equals(EVENTS.STOP.name())) {
            this.terminate();
        } else if (action.equals(EVENTS.NEW.name())) {
            this.iNew();
        } else if (action.equals(EVENTS.CUT.name())) {
            this.editor.cut();
            this.editor.setChanged(true);
            this.editor.getHistory().add();
        } else if (action.equals(EVENTS.COPY.name())) {
            this.editor.copy();
        } else if (action.equals(EVENTS.PASTE.name())) {
            this.editor.paste();
            this.editor.setChanged(true);
            this.editor.getHistory().add();
        } else if (action.equals(EVENTS.SELECT_ALL.name())) {
            this.editor.selectAll();
        } else if (action.equals(EVENTS.SELECT_NONE.name())) {
            int pos = this.editor.getCaretPosition();
            this.editor.select(pos, pos);
        } else if (action.equals(EVENTS.INDENT.name())) {
            boolean b2 = Lib_IndentOutdent.indent(this.editor, true);
            if (b2) {
                this.editor.getHistory().add();
            }
            this.editor.setChanged(true);
        } else if (action.equals(EVENTS.OUTDENT.name())) {
            boolean b3 = Lib_IndentOutdent.outdent(this.editor);
            if (b3) {
                this.editor.getHistory().add();
            }
            this.editor.setChanged(true);
        } else if (action.equals(EVENTS.OPEN.name())) {
            this.iOpenDialog();
        } else if (action.equals(EVENTS.SAVE.name())) {
            this.iSave();
        } else if (action.equals(EVENTS.SAVE_AS.name())) {
            this.iSaveAsDialog();
        } else if (action.equals(EVENTS.RECENT.name())) {
            this.editor.getRecent().show((JComponent)e.getSource());
        } else if (action.equals(EVENTS.UNDO.name())) {
            this.editor.getHistory().undo();
            this.editor.setChanged(true);
        } else if (action.equals(EVENTS.REDO.name())) {
            this.editor.getHistory().redo();
            this.editor.setChanged(true);
        } else if (action.equals(EVENTS.INFO.name())) {
            Dialog_About.show(this.base);
        } else if (action.equals(EVENTS.WEB.name())) {
            try {
                SysDefault.startBrowser((URI)new URI("https://www.jaymo-lang.org"));
            }
            catch (Exception e1) {
                Err.show((Throwable)e1);
            }
        } else if (action.equals(EVENTS.EXIT.name())) {
            if (this.editor.hasUnsavedChanges()) {
                Lib_SwingDialog.yesOrNo((Component)this.base, (DIALOG_TYPE)DIALOG_TYPE.WARNING, (String)"Script changed", (String)"Save your work?", b -> {
                    if (b.booleanValue()) {
                        this.iSave();
                    }
                    this.frame.dispose();
                });
            } else {
                this.frame.dispose();
            }
        } else if (action.startsWith(EVENTS.LOAD.name())) {
            String filename = action.substring(EVENTS.LOAD.name().length() + 1);
            File f = new File(filename);
            this.iOpen(f);
        } else if (action.startsWith(EVENTS.REFACTORING.name())) {
            int caretPosition = this.editor.getCaretPosition();
            String text = JayMo_Refactor.rename(this.base, this.editor.getText(), caretPosition);
            if (text != null) {
                this.editor.setText(text);
                this.editor.setCaretPosition(caretPosition);
                this.editor.getHistory().add();
                this.editor.setChanged(true);
            }
        } else if (action.startsWith(EVENTS.FIND.name())) {
            String find = Lib_SwingDialog.input((Component)this.base, (String)"Find", (String)"Search for", null);
            if (find != null) {
                this.editor.find(find);
            }
        } else if (action.startsWith(EVENTS.SLIDER.name())) {
            JSplitPane split = this.main.getSplit();
            int min = split.getMinimumDividerLocation();
            int cur = split.getDividerLocation();
            split.setDividerLocation(cur <= min + 50 ? Integer.MAX_VALUE : min);
        }
    }

    public void open(File initFile) {
        this.iOpen(initFile);
    }

    public void perform(EVENTS event) {
        this.actionPerformed(new ActionEvent(this, -1, event.name()));
    }

    public void setButtons(JButton execButton, JButton terminateButton) {
        this.execButton = execButton;
        this.terminateButton = terminateButton;
    }

    public void setMain(EditorMainPanel main) {
        this.main = main;
        this.editor = main.getComponentEditor();
        this.editor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 82 && e.getModifiersEx() == 128) {
                    JayMo_Actions.this.perform(EVENTS.REFACTORING);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void execute() {
        if (!this.execButton.isEnabled()) {
            return;
        }
        this.execButton.setEnabled(false);
        this.terminateButton.setEnabled(true);
        Procedure onFinish = () -> {
            this.execButton.setEnabled(true);
            this.terminateButton.setEnabled(false);
        };
        this.execControl.execute(this.main.getCode(), this.frame, this.main, onFinish);
    }

    private void iNew() {
        if (this.editor.hasUnsavedChanges()) {
            Lib_SwingDialog.yesOrNo((Component)this.base, (DIALOG_TYPE)DIALOG_TYPE.WARNING, (String)"Script changed", (String)"Save your work?", b -> {
                if (b.booleanValue()) {
                    this.iSave();
                    this.iNew();
                }
            });
        }
        this.main.clearOutput();
        this.editor.setCode("");
        this.editor.setCurrentFile(null);
        this.editor.setChanged(false);
        this.editor.getHistory().clear();
        this.frame.setStatus("New script");
    }

    private void iOpen(File f) {
        if (this.editor.hasUnsavedChanges()) {
            Lib_SwingDialog.yesOrNo((Component)this.base, (DIALOG_TYPE)DIALOG_TYPE.WARNING, (String)"Script changed", (String)"Save your work?", b -> {
                if (b.booleanValue()) {
                    this.iSave();
                    this.iOpen(f);
                }
            });
        }
        try {
            boolean createNew = !f.exists();
            String code = createNew ? "" : Lib_TextFile.read((File)f);
            this.editor.setCode(code);
            this.editor.setCurrentFile(f);
            this.editor.setChanged(false);
            this.editor.getRecent().add(f);
            this.main.getComponentOutput().setText("");
            this.main.getComponentResult().setText("");
            String taskMessage = createNew ? "New File: " : "File opened: ";
            this.frame.setStatus(String.valueOf(taskMessage) + f.getAbsolutePath());
            this.editor.getHistory().clear();
            this.editor.getHistory().add();
        }
        catch (Err_FileSys e) {
            Err.show((Throwable)e);
            Lib_SwingDialog.okay((Component)this.base, (DIALOG_TYPE)DIALOG_TYPE.ERROR, (String)"File open error", (String)e.getMessage());
        }
    }

    private void iOpenDialog() {
        File current = this.editor.getCurrentFile();
        String startDir = current == null ? null : current.getAbsolutePath();
        Lib_SwingDialog.open((Component)this.base, (String)startDir, (FileFilter)this.jmoFilter, f -> {
            if (new MFile(f).getSuffix().toLowerCase().equals("jmo")) {
                if (!f.exists()) {
                    Lib_SwingDialog.okay((Component)this.base, (DIALOG_TYPE)DIALOG_TYPE.ERROR, (String)"File read error", (String)("File doesn't exist: " + f.getAbsolutePath()));
                } else {
                    this.iOpen((File)f);
                }
            } else {
                Lib_SwingDialog.okay((Component)this.base, (DIALOG_TYPE)DIALOG_TYPE.ERROR, (String)"Invalid file type", (String)"The selected file is not a JayMo-File.");
            }
        });
    }

    private void iSave() {
        File current = this.editor.getCurrentFile();
        if (current == null) {
            this.iSaveAsDialog();
        } else {
            this.iSave(current);
        }
    }

    private void iSave(File f) {
        String code = this.editor.getText();
        try {
            Lib_TextFile.set((File)f, (String)code);
            this.editor.setCurrentFile(f);
            this.editor.setChanged(false);
            this.editor.getRecent().add(f);
            this.frame.setStatus("File saved: " + f.getAbsolutePath());
        }
        catch (Err_FileSys e) {
            Err.show((Throwable)e);
        }
    }

    private void iSaveAsDialog() {
        File current = this.editor.getCurrentFile();
        String startDir = current == null ? null : current.getAbsolutePath();
        Lib_SwingDialog.save((Component)this.base, (String)startDir, (FileFilter)this.jmoFilter, f -> {
            MFile mf = new MFile(f);
            if (!mf.getSuffix().toLowerCase().equals("jmo")) {
                mf.setSuffix("jmo");
            }
            if (mf.exists()) {
                Lib_SwingDialog.yesOrNo((Component)this.base, (DIALOG_TYPE)DIALOG_TYPE.WARNING, (String)"File already exists", (String)("Really overwrite '" + mf.getPathAbsolute() + "'?"), b -> {
                    if (b != null && b.booleanValue()) {
                        this.iSave(mf.getFile());
                    }
                });
            } else {
                this.iSave(mf.getFile());
            }
        });
    }

    private void terminate() {
        this.execControl.reset();
        this.execButton.setEnabled(true);
        this.frame.setStatus("Terminated");
    }
}

