/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.action;

import de.mn77.base.debug.Stopwatch;
import de.mn77.base.error.Err;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.Sys;
import de.mn77.base.thread.A_ParallelProcess;
import org.jaymo_lang.edit.Main_JayMo_Edit;
import org.jaymo_lang.edit.defs.EditorMainPanel;
import org.jaymo_lang.edit.defs.TextOutput;
import org.jaymo_lang.edit.defs.TextResult;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.lib.swing.JMo_Swing_Main;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.Parser_App;

public class ExecutionControl {
    private static final String TEXT_END_ERROR = "Process ended with error.";
    private static final String TEXT_END_EMPTY = "Nothing to do!";
    private final Parser_App parser = new Parser_App();
    private App runningApp = null;
    private Thread runningThread = null;

    public void execute(final String sourceCode, final Main_JayMo_Edit frame, final EditorMainPanel compMain, final Procedure onFinish) {
        if (this.runningThread != null) {
            return;
        }
        if (sourceCode.trim().length() == 0) {
            onFinish.execute();
            frame.setStatus(TEXT_END_EMPTY);
            return;
        }
        final TextOutput compOutput = compMain.getComponentOutput();
        final TextResult compResult = compMain.getComponentResult();
        frame.setStatus("Running ...");
        this.runningThread = new A_ParallelProcess(){

            protected void onFinished() {
                onFinish.execute();
                ExecutionControl.this.runningApp = null;
                ExecutionControl.this.runningThread = null;
            }

            protected void process() {
                if (ExecutionControl.this.runningApp != null) {
                    return;
                }
                App app = null;
                compOutput.setText("");
                compResult.showMessage("");
                compMain.showOutput();
                try {
                    app = ExecutionControl.this.parser.parseText(">strictWebstart");
                    ExecutionControl.this.parser.parseText(app, sourceCode);
                    ExecutionControl.this.runningApp = app;
                    app.setOutputRedirection(s -> {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            compOutput.append((String)s);
                            compOutput.setCaretPosition(compOutput.getText().length());
                        }
                        compOutput.repaint();
                    });
                    app.setNoHardExit();
                    Stopwatch timer = new Stopwatch();
                    String result = app.exec(null);
                    if (result != null) {
                        compResult.showMessage(result);
                        frame.setStatus("Runtime: " + ExecutionControl.this.iTimeMMSSsss(timer.getMillisec()));
                    } else {
                        compResult.showMessage("Error");
                        frame.setStatus(ExecutionControl.TEXT_END_ERROR);
                    }
                }
                catch (ErrorBaseDebug ce) {
                    if (app == null || !app.toBeTerminated()) {
                        compOutput.setText(ce.toInfo());
                        compResult.showMessage("Error");
                        frame.setStatus(ExecutionControl.TEXT_END_ERROR);
                        Err.show((Throwable)ce);
                    }
                }
                catch (Throwable t) {
                    compOutput.setText(t.toString());
                    compResult.showMessage("Error");
                    frame.setStatus(ExecutionControl.TEXT_END_ERROR);
                    Err.show((Throwable)t);
                }
            }
        };
    }

    public void reset() {
        JMo_Swing_Main.terminateAll();
        if (this.runningApp != null) {
            this.runningApp.terminate();
        }
        Sys.sleep((int)100);
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
        Sys.sleep((int)100);
        try {
            if (this.runningThread != null) {
                this.runningThread.stop();
            }
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    private String iTimeMMSSsss(long time) {
        int ms = (int)(time % 1000L);
        int ss = (int)(time /= 1000L);
        return ss == 0 ? ms + " ms" : String.valueOf(ss) + "." + ms + " Sec.";
    }
}

