/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.demo;

import de.mn77.base.data.group.Group4;
import de.mn77.base.error.Err;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.Sys;
import de.mn77.base.thread.A_ParallelProcess;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jaymo_lang.demo.defs.DemoMainPanel;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.Parser_App;

public class Main_JayMo_Demo {
    private App runningApp = null;
    private Thread runningThread = null;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Main_JayMo_Demo().createAndShowGUI());
    }

    private void createAndShowGUI() {
        Parser_App parser = new Parser_App();
        String version = "JayMo-Demo  " + parser.getVersionString(false, true);
        JFrame frame = new JFrame(version);
        frame.setDefaultCloseOperation(3);
        DemoMainPanel panel = new DemoMainPanel(g -> this.execute(parser, (Group4<String, JTextArea, JTextField, Procedure>)g), () -> this.reset());
        frame.add(panel);
        frame.pack();
        frame.setSize(1100, 500);
        frame.setVisible(true);
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/logo/jaymo_icon_256.png"));
        frame.setIconImage(img.getImage());
        int CTRL = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (402 != e.getID()) {
                return false;
            }
            if (e.getKeyCode() == 81 && e.getModifiersEx() == CTRL) {
                frame.dispose();
            }
            if (e.getKeyCode() == 10 && e.getModifiersEx() == CTRL) {
                panel.execute();
            }
            return false;
        });
    }

    private void execute(final Parser_App parser, final Group4<String, JTextArea, JTextField, Procedure> g) {
        final String sourcecode = (String)g.o1;
        if (this.runningThread != null) {
            return;
        }
        this.runningThread = new A_ParallelProcess(){

            protected void onFinished() {
                ((Procedure)g.o4).execute();
                Main_JayMo_Demo.this.runningApp = null;
                Main_JayMo_Demo.this.runningThread = null;
            }

            protected void process() {
                block4: {
                    if (Main_JayMo_Demo.this.runningApp != null) {
                        return;
                    }
                    App app = null;
                    try {
                        app = parser.parseText(">strictWebstart");
                        parser.parseText(app, sourcecode);
                        Main_JayMo_Demo.this.runningApp = app;
                        ((JTextArea)g.o2).setText("");
                        ((JTextField)g.o3).setText("");
                        app.setOutputRedirection(s -> {
                            ((JTextArea)group4.o2).append((String)s);
                            ((JTextArea)group4.o2).setCaretPosition(((JTextArea)group4.o2).getText().length());
                        });
                        app.setNoHardExit();
                        String result = app.exec(null);
                        if (!app.toBeTerminated() && result != null) {
                            ((JTextField)g.o3).setText(result);
                        }
                    }
                    catch (ErrorBaseDebug ce) {
                        if (app == null || app.toBeTerminated()) break block4;
                        ((JTextArea)g.o2).setText(ce.toInfo());
                        Err.show((Throwable)ce);
                    }
                }
            }
        };
    }

    private void reset() {
        if (this.runningApp != null) {
            this.runningApp.terminate();
        }
        Sys.sleep((int)100);
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
        Sys.sleep((int)100);
        try {
            if (this.runningThread != null) {
                this.runningThread.stop();
            }
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }
}

