/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;

public class Lib_ErrorConv {
    public static void checkConversion(CallRuntime cr, BigDecimal min, BigDecimal top, BigDecimal value, ATOMIC to) {
        if (value.compareTo(min) < 0 || value.compareTo(top) > 0) {
            Lib_ErrorConv.iThrowError(cr, to, min, top, value);
        }
    }

    public static void checkConversion(CallRuntime cr, Dec min, BigDecimal top, BigDecimal value, ATOMIC to) {
        Lib_ErrorConv.checkConversion(cr, min.bigDecimalValue(), top, value, to);
    }

    public static void checkConversion(CallRuntime cr, Dec min, BigDecimal top, BigInteger value, ATOMIC to) {
        Lib_ErrorConv.checkConversion(cr, min.bigDecimalValue(), top, new BigDecimal(value), to);
    }

    public static void checkConversion(CallRuntime cr, Dec min, Dec max, BigDecimal top, double value, ATOMIC to) {
        if (value >= min.doubleValue() && value <= max.doubleValue()) {
            return;
        }
        if (top.compareTo(BigDecimal.valueOf(value)) < 0) {
            Lib_ErrorConv.iThrowError(cr, to, min, top, value);
        }
    }

    public static void checkConversion(CallRuntime cr, double min, double max, double value, ATOMIC to) {
        if (value < min || value > max) {
            Lib_ErrorConv.iThrowError(cr, to, min, max, value);
        }
    }

    public static void checkConversion(CallRuntime cr, int min, int top, int value, ATOMIC to) {
        if (value < min || value > top) {
            Lib_ErrorConv.iThrowError(cr, to, min, top, value);
        }
    }

    public static void checkConversion(CallRuntime cr, long min, BigDecimal top, BigDecimal value, ATOMIC to) {
        Lib_ErrorConv.checkConversion(cr, new BigDecimal(min), top, value, to);
    }

    public static void checkConversion(CallRuntime cr, long min, BigDecimal top, BigInteger value, ATOMIC to) {
        Lib_ErrorConv.checkConversion(cr, new BigDecimal(min), top, new BigDecimal(value), to);
    }

    public static void checkConversion(CallRuntime cr, long min, long top, BigDecimal value, ATOMIC to) {
        Lib_ErrorConv.checkConversion(cr, new BigDecimal(min), new BigDecimal(top), value, to);
    }

    public static void checkConversion(CallRuntime cr, long min, long max, BigDecimal top, double value, ATOMIC to) {
        if (value >= (double)min && value <= (double)max) {
            return;
        }
        if (value < (double)min || top.compareTo(BigDecimal.valueOf(value)) < 0) {
            Lib_ErrorConv.iThrowError(cr, to, min, top, value);
        }
    }

    public static void checkConversion(CallRuntime cr, long min, long top, BigInteger value, ATOMIC to) {
        Lib_ErrorConv.checkConversion(cr, new BigDecimal(min), new BigDecimal(top), new BigDecimal(value), to);
    }

    public static void checkConversion(CallRuntime cr, long min, long max, long value, ATOMIC to) {
        if (value < min || value > max) {
            Lib_ErrorConv.iThrowError(cr, to, min, max, value);
        }
    }

    private static void iThrowError(CallRuntime cr, ATOMIC to, Object min, Object max, Object value) {
        StringBuilder detail = new StringBuilder();
        detail.append("Allowed are ");
        detail.append(min);
        detail.append(" to ");
        detail.append(max);
        detail.append(", but got: ");
        detail.append(value);
        throw new RuntimeError(cr, "Value out of bounds for conversion to " + to.name, detail.toString());
    }
}

