/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.convert.ConvertString;
import de.mn77.base.data.group.Group2;
import java.util.List;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectManager;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_Parser;
import org.jaymo_lang.util.Lib_StringParser;

public class ParseObj_Table
implements I_ParseObject {
    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == '|';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        if (!s.startsWith("||||")) {
            throw new CodeError("Invalid table block", "A TableBlock must start with '||||'.", parser);
        }
        int baseLevel = parser.buffer.getCurrentLevel();
        String rem = null;
        List<String> lines = ConvertString.toList("\u0001", s.substring(4));
        if (lines.size() > 0 && lines.get(0).length() != 0) {
            throw new CodeError("Invalid table block", "Missing linebreak after '||||'.", parser);
        }
        StringBuilder sb = new StringBuilder();
        int tableWidth = -1;
        for (String line : lines) {
            String lineTrimmed = line.trim();
            if (lineTrimmed.length() == 0) continue;
            lineTrimmed = lineTrimmed.replace('\u0002', ',');
            if (line.charAt(0) == ' ') {
                throw new CodeError("Line starts with Space-Char(s)", "Line: " + lineTrimmed, parser);
            }
            int lineDepth = Lib_Parser.getDepth(line);
            if (lineDepth != baseLevel) {
                throw new CodeError("Invalid indent", "Row must be on the same level as the table block: " + lineTrimmed, parser);
            }
            if (lineTrimmed.startsWith("||||")) {
                rem = lineTrimmed.substring(4);
                break;
            }
            sb.append(".add(");
            if (tableWidth == -1) {
                List<String> args = Lib_StringParser.splitArgs(lineTrimmed, parser.getDebugInfo());
                tableWidth = args.size();
            }
            sb.append(lineTrimmed);
            sb.append(")");
        }
        if (rem == null) {
            throw new CodeError("Invalid table block", "The terminating '||||' is missing.", parser.getDebugInfo());
        }
        if (tableWidth == -1) {
            tableWidth = 0;
        }
        Call[] args = new Call[]{new Call(current, new Int(tableWidth), parser.getDebugInfo())};
        I_Object obj = ObjectManager.createNew(parser.app, current, "Table", args, parser.getDebugInfo());
        return new Group2<I_Object, String>(obj, String.valueOf(sb.toString()) + rem);
    }
}

