/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group3;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.JMo_RegEx;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.pseudo.NonAtomic;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_Parser;

public class ParseObj_String
implements I_ParseObject {
    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 == '\"';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        Group3<String, Integer, Boolean> g = this.iParseModifier(s, parser.getDebugInfo());
        String rem = s.substring((Integer)g.o2 + 1);
        if (((Boolean)g.o3).booleanValue()) {
            Call arg = new Call(current, new Str((String)g.o1), parser.getDebugInfo());
            return new Group2<I_Object, String>(new NonAtomic(JMo_RegEx.class, new Call[]{arg}), rem);
        }
        return new Group2<I_Object, String>(new Str((String)g.o1), rem);
    }

    private Group3<String, Integer, Boolean> iParseModifier(String s, DebugInfo debugInfo) {
        int end = 1;
        int sLen = s.length();
        boolean reworkNeeded = false;
        end = 1;
        while (end < sLen) {
            char c = s.charAt(end);
            if (c == '\\') {
                ++end;
                reworkNeeded = true;
            } else if (c == '\"') break;
            ++end;
        }
        if (end == sLen) {
            throw new CodeError("Unclosed string", s, debugInfo);
        }
        String str = s.substring(1, end);
        if (end + 1 < sLen) {
            char cx = s.charAt(end + 1);
            if (cx == 'l') {
                return new Group3<String, Integer, Boolean>(str, end + 1, false);
            }
            if (cx == 'r') {
                return new Group3<String, Integer, Boolean>(str, end + 1, true);
            }
        }
        if (!reworkNeeded) {
            return new Group3<String, Integer, Boolean>(str, end, false);
        }
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        int idx = 0;
        while (idx < strLen) {
            char c = str.charAt(idx);
            if (c == '\\') {
                if ((c = str.charAt(++idx)) == 'u') {
                    char utf = Lib_Parser.replaceUtfChar(str, idx, debugInfo);
                    sb.append(utf);
                    idx += 4;
                } else {
                    sb.append(Lib_Parser.replaceEscapeChar(c, debugInfo));
                }
            } else {
                sb.append(c);
            }
            ++idx;
        }
        return new Group3<String, Integer, Boolean>(sb.toString(), end, false);
    }
}

