/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.util.Lib_Math;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;

public abstract class A_DecNumber
extends A_Number {
    @Override
    protected ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "decimal": {
                return A_Object.stdResult(this.mDecimal(cr));
            }
            case "decimals": {
                return A_Object.stdResult(this.mDecimals(cr));
            }
            case "isFinite": {
                cr.argsNone();
                Object oif = this.getValue();
                boolean isFinite = oif instanceof Dec ? true : (oif instanceof Float ? Float.isFinite(((Float)oif).floatValue()) : Double.isFinite((Double)oif));
                return A_Object.stdResult(Bool.getObject(isFinite));
            }
            case "isInfinite": {
                cr.argsNone();
                Object oii = this.getValue();
                boolean isInfinite = oii instanceof Dec ? false : (oii instanceof Float ? Float.isInfinite(((Float)oii).floatValue()) : Double.isInfinite((Double)oii));
                return A_Object.stdResult(Bool.getObject(isInfinite));
            }
            case "isNaN": {
                cr.argsNone();
                Object oin = this.getValue();
                boolean isNaN = oin instanceof Dec ? false : (oin instanceof Float ? Float.isNaN(((Float)oin).floatValue()) : Double.isNaN((Double)oin));
                return A_Object.stdResult(Bool.getObject(isNaN));
            }
            case "roundDec": {
                return A_Object.stdResult(this.mRoundDec(cr));
            }
        }
        return this.call5(cr, method);
    }

    protected abstract ObjectCallResult call5(CallRuntime var1, String var2);

    @Override
    protected Int getLength(CallRuntime cr) {
        String s = this.toString(cr, STYPE.DESCRIBE);
        char modif = s.charAt(s.length() - 1);
        if (modif >= 'a' && modif <= 'z') {
            s = s.substring(0, s.length() - 1);
        }
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return new Int(s.length());
    }

    private I_Object mDecimal(CallRuntime cr) {
        cr.argsNone();
        Number n = (Number)this.getValue();
        String dec = FilterString.from(".", false, n.toString());
        return new Int(Integer.parseInt(dec.substring(1)));
    }

    private I_Object mDecimals(CallRuntime cr) {
        cr.argsNone();
        Number n = (Number)this.getValue();
        String dec = FilterString.from(".", false, n.toString());
        return new Int(dec.length() - 1);
    }

    private I_Atomic mRoundDec(CallRuntime cr) {
        I_Object arg = cr.args(this, Int.class)[0];
        if (this instanceof JMo_BigDec) {
            throw new RuntimeError(cr, "Invalid object type", "Can't round BigDecimal number.");
        }
        double value = ((Number)this.getValue()).doubleValue();
        int i = Lib_Convert.getIntValue(cr, arg);
        if (i < 0 || i > 10) {
            throw new CodeError(cr, "Invalid argument", "Got " + i + ", allowed = 0-10");
        }
        return this instanceof JMo_Dec ? JMo_Dec.valueOf(cr, Lib_Math.round(value, i)) : new JMo_Double(Lib_Math.round(value, i));
    }
}

