/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.MDir;
import java.io.File;

public class SysDir {
    public static I_Directory current() {
        try {
            return new MDir(Sys.getCurrentDir());
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static I_Directory home() {
        try {
            return new MDir(Sys.getPathHome());
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static I_Directory root() {
        try {
            return new MDir(File.listRoots()[0]);
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static I_Directory temp() {
        try {
            return new MDir(Sys.getPathTemp());
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static I_Directory userCache() throws Err_FileSys {
        if (Sys.isLinux()) {
            return SysDir.home().dirFlex(".cache");
        }
        if (Sys.isWindows()) {
            return SysDir.userConfig();
        }
        if (Sys.isMac()) {
            return SysDir.home().dirFlex(".cache");
        }
        throw Err.todo("Cache-Directory not configured for this System.", Sys.getOsName(), Sys.getOsVersion());
    }

    public static I_Directory userCache_MN77(String app) throws Err_FileSys {
        String base = SysDir.iNormalize("MN77");
        app = SysDir.iNormalize(app);
        return SysDir.userCache().dirFlex(base).dirFlex(app);
    }

    public static I_Directory userConfig() throws Err_FileSys {
        if (Sys.isLinux()) {
            return SysDir.home().dirFlex(".config");
        }
        if (Sys.isWindows()) {
            if (Double.parseDouble(Sys.getOsVersion()) >= 10.0) {
                return SysDir.home().dirFlex("AppData").dirFlex("Local");
            }
            return SysDir.home().dirFlex("Anwendungsdaten");
        }
        if (Sys.isMac()) {
            return SysDir.home().dirFlex(".config");
        }
        throw Err.todo("App-Data-Directory not configured for this System.", Sys.getOsName(), Sys.getOsVersion());
    }

    public static I_Directory userConfig(String app) throws Err_FileSys {
        app = SysDir.iNormalize(app);
        return SysDir.userConfig().dirFlex(app);
    }

    public static I_Directory userConfig_MN77(String app) throws Err_FileSys {
        String base = SysDir.iNormalize("MN77");
        app = SysDir.iNormalize(app);
        return SysDir.userConfig().dirFlex(base).dirFlex(app);
    }

    @Deprecated
    public static I_Directory userConfig_Nitsche(String app) throws Err_FileSys {
        String base = SysDir.iNormalize("Nitsche Michael");
        app = SysDir.iNormalize(app);
        return SysDir.userConfig().dirFlex(base).dirFlex(app);
    }

    private static String iNormalize(String s) {
        Err.ifEmpty(s);
        s = FilterString.trim(s);
        if (Sys.isLinux() || Sys.isMac()) {
            s = s.toLowerCase();
            s = s.replace(' ', '_');
        }
        return s;
    }
}

