/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.debug;

import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.data.util.Lib_Math;
import de.mn77.base.sys.MOut;

public class Stopwatch {
    private final long start = System.currentTimeMillis();
    private Long diff = this.start;

    public long getDiffMillisec() {
        return System.currentTimeMillis() - this.diff;
    }

    public double getDiffSeconds() {
        return (double)(System.currentTimeMillis() - this.diff) / 1000.0;
    }

    public long getMillisec() {
        return System.currentTimeMillis() - this.start;
    }

    public double getSeconds() {
        return (double)(System.currentTimeMillis() - this.start) / 1000.0;
    }

    public String getStringDiffHHMMSS() {
        return new MTime((int)this.getDiffMillisec()).toString();
    }

    public String getStringDiffMillisec() {
        return String.valueOf(this.getDiffMillisec()) + " ms";
    }

    public String getStringDiffSeconds() {
        return String.valueOf(Lib_Math.roundToString(this.getDiffSeconds(), 1)) + " Sec";
    }

    public String getStringHHMMSS() {
        return new MTime((int)this.getMillisec()).toString();
    }

    public String getStringSeconds() {
        return String.valueOf(Lib_Math.roundToString(this.getSeconds(), 1)) + " Sec";
    }

    public String gStringMillisec() {
        return String.valueOf(this.getMillisec()) + " ms";
    }

    public void print() {
        this.iPrint(null, false);
    }

    public void print(String info) {
        this.iPrint(info, false);
    }

    public void printShort() {
        this.iPrint(null, true);
    }

    public void printShort(String info) {
        this.iPrint(info, true);
    }

    public void resetDiff() {
        this.diff = System.currentTimeMillis();
    }

    public String toString() {
        return "Duration: " + this.getStringSeconds() + "   (" + this.gStringMillisec() + ")";
    }

    private void iPrint(String info, boolean compact) {
        boolean extended = this.getSeconds() >= 120.0;
        String diffTime = extended ? this.getStringDiffHHMMSS() : this.getStringDiffSeconds();
        String totalTime = extended ? this.getStringHHMMSS() : this.getStringSeconds();
        String s1 = "Diff : " + diffTime + "   (" + this.getStringDiffMillisec() + ")";
        String s2 = "Total: " + totalTime + "   (" + this.gStringMillisec() + ")";
        if (compact) {
            MOut.print(String.valueOf(info == null ? "" : info) + ":  " + diffTime + " / " + totalTime);
        } else if (info == null) {
            MOut.print(s1, s2);
        } else {
            MOut.print(info, s1, s2);
        }
        this.resetDiff();
    }
}

