/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.tablestyle.calc;

import de.mn77.base.data.constant.ALIGN;
import de.mn77.base.data.convert.ConvertString;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.group.XY;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.tablestyle.calc.TableBorderCalc;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import java.util.HashMap;
import java.util.Map;

public class TableStyleCalc {
    private final I_Table<?> table;
    private final ALIGN[][] aligns;
    private final int columns;
    private final int rows;
    private Character colDefault = null;
    private Character rowDefault = null;
    private String colLines = null;
    private String rowLines = null;
    private int indent = 0;

    public TableStyleCalc(I_Table<?> table) {
        this.table = table;
        this.columns = table.width();
        this.rows = table.size();
        this.aligns = new ALIGN[this.columns][this.rows];
    }

    public void alignCells(HashMap<XY, ALIGN> defs) {
        for (Map.Entry<XY, ALIGN> e : defs.entrySet()) {
            int row = e.getKey().y;
            int col = e.getKey().x;
            Err.ifOutOfBounds(0, this.columns - 1, col);
            Err.ifOutOfBounds(0, this.rows - 1, row);
            this.aligns[col][row] = e.getValue();
        }
    }

    public void alignColumns(HashMap<Integer, ALIGN> defs) {
        for (Map.Entry<Integer, ALIGN> e : defs.entrySet()) {
            int col = e.getKey();
            Err.ifOutOfBounds(0, this.columns - 1, col);
            int y = 0;
            while (y < this.rows) {
                this.aligns[col][y] = e.getValue();
                ++y;
            }
        }
    }

    public void alignDefault(ALIGN style) {
        int y = 0;
        while (y < this.rows) {
            int x = 0;
            while (x < this.columns) {
                this.aligns[x][y] = style;
                ++x;
            }
            ++y;
        }
    }

    public void alignRows(HashMap<Integer, ALIGN> defs) {
        for (Map.Entry<Integer, ALIGN> e : defs.entrySet()) {
            int row = e.getKey();
            Err.ifOutOfBounds(0, this.rows - 1, row);
            int x = 0;
            while (x < this.columns) {
                this.aligns[x][row] = e.getValue();
                ++x;
            }
        }
    }

    public void columnLineDefault(Character s) {
        this.colDefault = s;
    }

    public void columnLines(String s) {
        this.colLines = s;
    }

    public String compute(boolean border, boolean unicode) {
        return this.compute(border, unicode, null);
    }

    public String compute(boolean border, boolean unicode, Integer maxColumnWidth) {
        if (this.table.size() == 0) {
            return "";
        }
        boolean limit = maxColumnWidth != null;
        int[] colWidth = new int[this.columns];
        String[][] stringTable = new String[this.columns][this.rows];
        String indentString = this.indent > 0 ? Lib_String.sequence(' ', (long)this.indent) : null;
        int x = 0;
        while (x < this.columns) {
            int y = 0;
            while (y < this.rows) {
                Object obj = this.table.get(x, y);
                stringTable[x][y] = this.iObjectToString(obj);
                if (this.aligns[x][y] == null) {
                    this.aligns[x][y] = obj instanceof Number ? ALIGN.RIGHT : ALIGN.LEFT;
                }
                ++y;
            }
            colWidth[x] = this.computeColumnWidth(stringTable, x);
            if (limit && colWidth[x] > maxColumnWidth) {
                colWidth[x] = maxColumnWidth;
            }
            ++x;
        }
        TableBorderCalc bc = new TableBorderCalc(border, unicode, this.colDefault, this.colLines, this.rowDefault, this.rowLines, colWidth, this.rows, indentString);
        StringBuilder sb = new StringBuilder();
        bc.borderTop(sb);
        int y = 0;
        while (y < this.rows) {
            if (indentString != null) {
                sb.append(indentString);
            }
            String[][] row = new String[this.columns][];
            int maxLines = 1;
            int x2 = 0;
            while (x2 < this.columns) {
                row[x2] = ConvertString.toStringArray('\n', stringTable[x2][y]);
                if (row[x2].length > maxLines) {
                    maxLines = row[x2].length;
                }
                ++x2;
            }
            int line = 0;
            while (line < maxLines) {
                bc.lineStart(sb);
                int x3 = 0;
                while (x3 < this.columns) {
                    String fieldLine = row[x3].length <= line ? "" : row[x3][line];
                    String s = FormString.width(colWidth[x3], ' ', fieldLine, this.aligns[x3][y], limit);
                    sb.append(s);
                    bc.afterColumn(sb, x3);
                    ++x3;
                }
                bc.lineEnd(sb, y, line == maxLines - 1);
                ++line;
            }
            ++y;
        }
        boolean borderAdded = bc.borderBottom(sb);
        if (!borderAdded) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public void indent(int indent) {
        this.indent = indent;
    }

    public void rowLineDefault(Character c) {
        this.rowDefault = c;
    }

    public void rowLines(String s) {
        this.rowLines = s;
    }

    private int computeColumnWidth(String[][] stringTable, int x) {
        Integer maxText = 0;
        int y = 0;
        while (y < this.rows) {
            String[] fieldLines;
            String[] stringArray = fieldLines = ConvertString.toStringArray('\n', stringTable[x][y]);
            int n = fieldLines.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldLine = stringArray[n2];
                int lineWidth = fieldLine.length();
                if (lineWidth > maxText) {
                    maxText = lineWidth;
                }
                ++n2;
            }
            ++y;
        }
        return maxText;
    }

    private String iObjectToString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }
}

