/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.tree;

import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.data.struct.I_Iterable;
import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.util.Lib_Relative;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.util.Collections;
import java.util.Iterator;

public class TreeNode<TKey, TValue>
implements I_Iterable<TreeNode<TKey, TValue>> {
    public final SimpleList<TreeNode<TKey, TValue>> nodes = new SimpleList();
    private TKey name = null;
    private TValue value = null;

    public TreeNode(TKey name) {
        this.name = name;
    }

    public TreeNode(TKey name, TValue value) {
        Err.ifNull(name);
        this.name = name;
        this.value = value;
    }

    public TreeNode<TKey, TValue> add(TKey key) {
        TreeNode<TKey, TValue> result = new TreeNode<TKey, TValue>(key);
        this.nodes.add(result);
        return result;
    }

    public TreeNode<TKey, TValue> add(TKey key, TValue value) {
        TreeNode<TKey, TValue> result = new TreeNode<TKey, TValue>(key, value);
        this.nodes.add(result);
        return result;
    }

    public void add(TreeNode<TKey, TValue> node) {
        this.nodes.add(node);
    }

    public void addNodes(TKey ... keys) {
        this.nodes.ensureGrow(keys.length);
        TKey[] TKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            TKey key = TKeyArray[n2];
            this.nodes.add(new TreeNode<TKey, TValue>(key));
            ++n2;
        }
    }

    public void addNodes(TreeNode<TKey, TValue> ... nodes) {
        Collections.addAll(this.nodes, nodes);
    }

    public TreeNode<TKey, TValue> copy() {
        throw Err.todo(new Object[0]);
    }

    public TreeNode<TKey, TValue> first() {
        return this.nodes.size() == 0 ? null : this.nodes.get(0);
    }

    @Override
    public TreeNode<TKey, TValue> get(int index) {
        return this.nodes.get(index);
    }

    public TKey getName() {
        return this.name;
    }

    public TValue getValue() {
        return this.value;
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.size() == 0;
    }

    @Override
    public Iterator<TreeNode<TKey, TValue>> iterator() {
        return this.nodes.iterator();
    }

    public TreeNode<TKey, TValue> last() {
        return this.nodes.size() == 0 ? null : this.nodes.get(this.nodes.size() - 1);
    }

    public void put(TKey key, TValue value) {
        this.iSetPut(key, value, true);
    }

    public TreeNode<TKey, TValue> relGet(int relPosition) {
        int index = Lib_Relative.realIndex(relPosition, this.nodes.size(), false);
        return this.nodes.get(index);
    }

    public void removeNodes(TKey ... keys) {
        TKey[] TKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            TKey key = TKeyArray[n2];
            boolean removed = false;
            int i = 0;
            while (i < this.nodes.size()) {
                TreeNode<TKey, TValue> node = this.nodes.get(i);
                if (node.name.equals(key)) {
                    this.nodes.remove(i);
                    removed = true;
                    break;
                }
                ++i;
            }
            if (!removed) {
                throw new Err_Runtime("Can't find node with name: \"" + key + '\"', new Object[0]);
            }
            ++n2;
        }
    }

    public void set(TKey key, TValue value) {
        this.iSetPut(key, value, false);
    }

    public void setName(TKey name) {
        Err.ifNull(name);
        this.name = name;
    }

    public void setValue(TValue value) {
        this.value = value;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public String toDescribe() {
        SimpleList<String> sum = new SimpleList<String>();
        for (TreeNode<TKey, TValue> node : this.nodes) {
            node.iToDescribe(sum, 0);
        }
        return ConvertSequence.toString('\n', sum);
    }

    @Override
    public String toIdent() {
        return this.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this.name == null ? "Tree" : this.name.toString()) + (this.value == null ? "" : ": " + this.value.toString());
    }

    private TreeNode<TKey, TValue> get(TKey key) {
        return this.iGetPull(key, false);
    }

    private TreeNode<TKey, TValue> iGetPull(TKey key, boolean lazy) {
        for (TreeNode<TKey, TValue> node : this.nodes) {
            if (!node.name.equals(key)) continue;
            return node;
        }
        if (lazy) {
            TreeNode<TKey, TValue> node;
            node = new TreeNode<TKey, TValue>(key);
            this.nodes.add(node);
            return node;
        }
        throw new Err_Runtime("Can't find node with name: \"" + key + '\"', new Object[0]);
    }

    private void iSetPut(TKey key, TValue value, boolean lazy) {
        TreeNode<TKey, TValue> found = null;
        for (TreeNode<TKey, TValue> node : this.nodes) {
            if (!node.name.equals(key)) continue;
            found = node;
        }
        if (lazy && found == null) {
            TreeNode<TKey, TValue> node;
            node = new TreeNode<TKey, TValue>(key);
            this.nodes.add(node);
            found = node;
        }
        if (found == null) {
            throw new Err_Runtime("Can't find node with name: \"" + key + '\"', new Object[0]);
        }
        found.value = value;
    }

    private void iToDescribe(I_List<String> target, int left) {
        target.add(String.valueOf(Lib_String.sequence(' ', (long)(left * 2))) + this.toString());
        for (TreeNode<TKey, TValue> node : this.nodes) {
            node.iToDescribe(target, left + 1);
        }
    }

    private TreeNode<TKey, TValue> pull(TKey key) {
        return this.iGetPull(key, true);
    }
}

