/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table;

import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;

public class Lib_Table {
    private static final String ERR_WIDTH = "The amount of titles doesn't fit to the width of the table!";

    public static <T> String toString(I_Table<T> table, String[] titles) {
        int x;
        StringBuilder sb = new StringBuilder();
        int[] max = new int[table.width()];
        int y = 0;
        while (y < table.size()) {
            x = 0;
            while (x < table.width()) {
                T o = table.get(x, y);
                int len = ("" + o).length();
                if (len > max[x]) {
                    max[x] = len;
                }
                ++x;
            }
            ++y;
        }
        if (titles != null) {
            Err.ifNot(titles.length, table.width(), ERR_WIDTH);
            int x2 = 0;
            while (x2 < table.width()) {
                int len = titles[x2].length();
                if (len > max[x2]) {
                    max[x2] = len;
                }
                ++x2;
            }
            x2 = 0;
            while (x2 < table.width()) {
                if (x2 > 0) {
                    sb.append(" | ");
                }
                sb.append(FormString.width(max[x2], titles[x2], false));
                ++x2;
            }
            sb.append('\n');
            x2 = 0;
            while (x2 < table.width()) {
                if (x2 > 0) {
                    sb.append(" | ");
                }
                sb.append(Lib_String.sequence('=', (long)max[x2]));
                ++x2;
            }
            sb.append('\n');
        }
        y = 0;
        while (y < table.size()) {
            x = 0;
            while (x < table.width()) {
                if (x > 0) {
                    sb.append(" | ");
                }
                sb.append(FormString.width(max[x], "" + table.get(x, y), false));
                ++x;
            }
            if (y < table.size() - 1) {
                sb.append("\n");
            }
            ++y;
        }
        return sb.toString();
    }
}

