/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.sort.plain;

import de.mn77.base.data.struct.sort.I_Sortable;
import de.mn77.base.data.struct.sort.Lib_Sort;
import de.mn77.base.data.struct.sort.plain.A_SortAlgo;

public class MergeSort
extends A_SortAlgo {
    @Override
    protected void pSortImpl(I_Sortable<?> list, boolean desc) {
        if (list.size() <= 1) {
            return;
        }
        int len = list.size();
        int[] dat = new int[len];
        int i = 0;
        while (i < len) {
            dat[i] = i;
            ++i;
        }
        this.part(list, desc, dat, 0, len - 1);
        list.sortLike(dat);
    }

    private void part(I_Sortable<?> s, boolean desc, int[] dat, int left, int right) {
        if (left == right) {
            return;
        }
        int len = right - left + 1;
        if (len > 2) {
            int part = len / 2;
            int l1 = left;
            int r1 = left + part;
            int l2 = r1 + 1;
            int r2 = right;
            this.part(s, desc, dat, l1, r1);
            this.part(s, desc, dat, l2, r2);
            int p1 = l1;
            int p2 = l2;
            int pi = 0;
            int[] tmp = new int[len];
            while (p1 <= r1 || p2 <= r2) {
                int rel;
                int i2;
                int i1 = p1 > r1 ? -1 : dat[p1];
                int n = i2 = p2 > r2 ? -1 : dat[p2];
                int n2 = p1 > r1 ? 1 : (rel = p2 > r2 ? -1 : Lib_Sort.relation(s, i1, i2, desc));
                if (rel > 0) {
                    tmp[pi] = i2;
                    ++p2;
                } else {
                    tmp[pi] = i1;
                    ++p1;
                }
                ++pi;
            }
            int p = 0;
            while (p < len) {
                dat[left + p] = tmp[p];
                ++p;
            }
        } else {
            int il = dat[left];
            int ir = dat[right];
            if (Lib_Sort.relation(s, il, ir, desc) > 0) {
                dat[left] = ir;
                dat[right] = il;
            }
        }
    }
}

