/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.sort;

import de.mn77.base.data.struct.sort.I_Sortable;
import de.mn77.base.data.struct.sort.I_TableSort;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.error.Err;

public class Lib_Sort {
    public static boolean isHeavier(I_Sortable<?> list, int row, int thanRow, boolean desc) {
        return Lib_Sort.relation(list, row, thanRow, desc) > 0;
    }

    public static boolean isHeavier(I_TableSort<?> tab, int row, int thanRow, int ... columnOrder) {
        return Lib_Sort.relation(tab, row, thanRow, columnOrder) > 0;
    }

    public static int relation(I_Sortable<?> list, int row1, int row2, boolean desc) {
        Object o2;
        Object o1 = list.get(row1);
        if (Lib_Compare.isEqual(o1, o2 = list.get(row2))) {
            return 0;
        }
        boolean isGreater = Lib_Compare.isGreater(o1, o2);
        if (desc) {
            isGreater = !isGreater;
        }
        return isGreater ? 1 : -1;
    }

    public static int relation(I_TableSort<?> tab, int row1, int row2, int ... columnOrder) {
        int result = 0;
        int columnOrderIdx = 0;
        while (result == 0 && columnOrder.length > columnOrderIdx) {
            Object o2;
            int columnIndex;
            Object o1;
            int currentColumn = columnOrder[columnOrderIdx];
            if (currentColumn == 0) {
                Err.invalid("Got 0 as order column");
            }
            if (!Lib_Compare.isEqual(o1 = tab.get(columnIndex = currentColumn > 0 ? currentColumn - 1 : -1 - currentColumn, row1), o2 = tab.get(columnIndex, row2))) {
                boolean isGreater = Lib_Compare.isGreater(o1, o2);
                if (currentColumn < 0) {
                    isGreater = !isGreater;
                }
                return isGreater ? 1 : -1;
            }
            result = 0;
            ++columnOrderIdx;
        }
        return result;
    }
}

