/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.xml.parser;

import de.mn77.base.data.convert.ConvertArray;
import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.data.struct.I_Iterable;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import de.mn77.base.event.A_StringEventHandler;
import de.mn77.base.sys.MOut;
import de.mn77.lib.xml.parser.XML_EVENT;
import de.mn77.lib.xml.parser.XML_Element;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XML_Parser
extends A_StringEventHandler {
    public void eventAdd(XML_EVENT type, String[] element, Consumer<XML_Element> z) {
        String epfad = this.iString(type, element);
        MOut.temp((Object[])new Object[]{epfad});
        this.eventAdd(epfad, z);
    }

    public void parse(File file) throws XMLStreamException, FileNotFoundException {
        this.parse(new FileInputStream(file));
    }

    public void parse(InputStream is) throws XMLStreamException {
        XMLInputFactory factory2 = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory2.createXMLStreamReader(is);
        SimpleList curPath = new SimpleList();
        HashMap<String, XML_Element> openElements = new HashMap<String, XML_Element>();
        while (parser.hasNext()) {
            String removed;
            String curPathString;
            XML_Element element;
            int event = parser.next();
            if (event == 1) {
                String elementName = parser.getLocalName();
                curPath.add((Object)elementName);
                String curPathString2 = this.iString(null, (I_Iterable<String>)curPath);
                element = new XML_Element((String[])curPath.toArray(String.class));
                openElements.put(curPathString2, element);
                MOut.temp((Object[])new Object[]{curPath});
                if (parser.getAttributeCount() > 0) {
                    int i = 0;
                    while (i < parser.getAttributeCount()) {
                        element.setAttribute(parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                        ++i;
                    }
                    MOut.temp((Object[])new Object[]{curPath});
                    this.eventStart(this.iString(XML_EVENT.START, (I_Iterable<String>)curPath), element);
                }
            }
            if (event == 4 && !parser.isWhiteSpace()) {
                curPathString = this.iString(null, (I_Iterable<String>)curPath);
                element = openElements.getOrDefault(curPathString, null);
                if (element == null) continue;
                element.addText(parser.getText());
                this.eventStart(this.iString(XML_EVENT.TEXT, (I_Iterable<String>)curPath), element);
            }
            if (event != 2) continue;
            curPathString = this.iString(null, (I_Iterable<String>)curPath);
            element = openElements.getOrDefault(curPathString, null);
            if (element != null) {
                openElements.remove(curPathString);
                this.eventStart(this.iString(XML_EVENT.END, (I_Iterable<String>)curPath), element);
            }
            if ((removed = (String)curPath.delete(curPath.size() - 1)).toLowerCase().equals(parser.getLocalName().toLowerCase())) continue;
            Err.forbidden((Object[])new Object[]{"XML-Format-Fehler", openElements, removed, parser.getLocalName()});
        }
    }

    public void parse(String datei) throws XMLStreamException, FileNotFoundException {
        this.parse(new FileInputStream(datei));
    }

    private String iString(XML_EVENT type, I_Iterable<String> sa) {
        String prefix = type == null ? "" : String.valueOf(type.name()) + ':';
        return String.valueOf(prefix) + "/" + ConvertSequence.toString((String)"/", sa);
    }

    private String iString(XML_EVENT type, String[] sa) {
        String prefix = type == null ? "" : String.valueOf(type.name()) + ':';
        return String.valueOf(prefix) + "/" + ConvertArray.toString((String)"/", (Object[])sa);
    }
}

