/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.graphic;

import de.mn77.base.data.util.Lib_Math;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.I_File;
import de.mn77.lib.graphic.IMAGE_FORMAT;
import de.mn77.lib.graphic.I_Image;
import de.mn77.lib.graphic.Lib_Graphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class MImage
implements I_Image {
    public static final int MAX_PIXEL = 4096;
    protected BufferedImage image = null;
    private int farbbits = 0;

    public MImage(BufferedImage img, int bits) {
        this.image = img;
        this.farbbits = bits;
    }

    public MImage(I_File file) throws Err_FileSys {
        BufferedImage temp = null;
        try {
            temp = ImageIO.read(file.read());
        }
        catch (IOException e) {
            Err.wrap((IOException)e, (Object[])new Object[]{file});
        }
        this.iNEU(temp, temp.getColorModel().getPixelSize(), 0, 0);
    }

    public MImage(int dx, int dy, int rot, int gruen, int blau) {
        this(dx, dy, rot, gruen, blau, 255);
    }

    public MImage(int dx, int dy, int rot, int gruen, int blau, int alpha) {
        Err.ifOutOfBounds((int)0, (int)4096, (int[])new int[]{dx});
        Err.ifOutOfBounds((int)0, (int)4096, (int[])new int[]{dy});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{rot});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{gruen});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{blau});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{alpha});
        this.image = new BufferedImage(dx, dy, 2);
        Graphics2D g2d = this.image.createGraphics();
        g2d.setColor(new Color(rot, gruen, blau, alpha));
        g2d.fillRect(0, 0, dx, dy);
        g2d.dispose();
        this.farbbits = 24;
    }

    public MImage(Object obj) {
        this(obj, 0, 0);
    }

    public MImage(Object obj, int dx, int dy) {
        Err.ifNull((Object)obj);
        Err.ifOutOfBounds((int)0, (int)3000, (int[])new int[]{dx});
        Err.ifOutOfBounds((int)0, (int)3000, (int[])new int[]{dy});
        if (obj instanceof I_Image) {
            obj = ((I_Image)obj).getImage();
        }
        if (obj instanceof BufferedImage) {
            this.iNEU((BufferedImage)obj, ((BufferedImage)obj).getColorModel().getPixelSize(), dx, dy);
        } else if (obj instanceof ImageIcon) {
            this.iNEU(((ImageIcon)obj).getImage(), 24, dx, dy);
        } else if (obj instanceof Image) {
            MediaTracker tracker = new MediaTracker(null);
            tracker.addImage((Image)obj, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException ie) {
                Err.wrap((Exception)ie, (Object[])new Object[]{obj});
            }
            this.iNEU((Image)obj, 24, dx, dy);
        } else if (obj instanceof InputStream) {
            BufferedImage temp = null;
            try {
                temp = ImageIO.read((InputStream)obj);
            }
            catch (IOException e) {
                Err.wrap((IOException)e, (Object[])new Object[]{obj});
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else if (obj instanceof File) {
            BufferedImage temp = null;
            try {
                temp = ImageIO.read((File)obj);
            }
            catch (IOException e) {
                Err.wrap((IOException)e, (Object[])new Object[]{obj});
            }
            if (temp == null) {
                Err.direct((String)("Image read error: " + ((File)obj).getAbsolutePath()), (Object[])new Object[0]);
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else if (obj instanceof String) {
            BufferedImage temp = null;
            try {
                temp = ImageIO.read(new File("" + obj));
            }
            catch (IOException e) {
                Err.wrap((IOException)e, (Object[])new Object[]{obj});
            }
            if (temp == null) {
                Err.direct((String)("Image unreadable: " + obj), (Object[])new Object[0]);
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else if (obj instanceof byte[]) {
            BufferedImage temp = null;
            try {
                ByteArrayInputStream is = new ByteArrayInputStream((byte[])obj);
                temp = ImageIO.read(is);
            }
            catch (IOException e) {
                Err.wrap((IOException)e, (Object[])new Object[]{obj});
            }
            if (temp == null) {
                Err.direct((String)("Image unreadable: " + obj), (Object[])new Object[0]);
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else {
            throw Err.invalid((Object[])new Object[]{"Unknown objekt type", obj, obj.getClass().getSimpleName()});
        }
    }

    public I_Image copy() {
        BufferedImage b = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        b.setData(this.image.getData());
        return new MImage(b);
    }

    @Override
    public void dispose() {
        this.image.flush();
    }

    @Override
    public byte[] getBytesPNG() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.image, "png", baos);
        }
        catch (IOException e) {
            Err.wrap((IOException)e, (Object[])new Object[0]);
        }
        return baos.toByteArray();
    }

    @Override
    public int getColorBitsOriginal() {
        return this.farbbits;
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.image);
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    public void iSaveJPEG(String datei, Integer qualitaet, boolean addSuffix) throws Err_FileSys {
        Err.ifNull((Object)datei);
        if (addSuffix) {
            datei = String.valueOf(datei) + "." + IMAGE_FORMAT.JPEG.defaultSuffix;
        }
        try {
            BufferedImage imageToSave = this.iARGBzuRGB(this.image);
            File file = new File(datei);
            FileOutputStream out = new FileOutputStream(file);
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(out);
            imageWriter.setOutput(ios);
            IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(imageToSave), null);
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            if (qualitaet != null) {
                Err.ifOutOfBounds((int)1, (int)100, (int[])new int[]{qualitaet});
                jpegParams.setCompressionMode(2);
                jpegParams.setCompressionQuality((float)qualitaet.intValue() / 100.0f);
            } else {
                jpegParams.setCompressionMode(1);
            }
            imageWriter.write(imageMetaData, new IIOImage(imageToSave, null, null), jpegParams);
            ios.close();
            imageWriter.dispose();
        }
        catch (IOException e) {
            Err.wrap((IOException)e, (Object[])new Object[]{datei});
        }
    }

    @Override
    public I_File save(I_Directory v, String name, IMAGE_FORMAT format, boolean addSuffix) throws Err_FileSys {
        Err.ifNull((Object[])new Object[]{v, name, format});
        I_File erg = null;
        try {
            BufferedImage speichern = this.image;
            if (format != IMAGE_FORMAT.GIF && format != IMAGE_FORMAT.PNG) {
                speichern = this.iARGBzuRGB(this.image);
            }
            erg = v.fileMay(name, format.defaultSuffix);
            ImageIO.write((RenderedImage)speichern, this.iSchreibformat(format), erg.write());
            speichern.flush();
        }
        catch (IOException e) {
            Err.wrap((IOException)e, (Object[])new Object[]{v, name});
        }
        return erg;
    }

    @Override
    public void save(String datei, IMAGE_FORMAT format, boolean addSuffix) throws Err_FileSys {
        Err.ifNull((Object[])new Object[]{datei, format});
        try {
            BufferedImage speichern = this.image;
            if (format != IMAGE_FORMAT.GIF && format != IMAGE_FORMAT.PNG) {
                speichern = this.iARGBzuRGB(this.image);
            }
            if (addSuffix) {
                datei = String.valueOf(datei) + "." + format.defaultSuffix;
            }
            ImageIO.write((RenderedImage)speichern, this.iSchreibformat(format), new File(datei));
            speichern.flush();
        }
        catch (IOException e) {
            Err.wrap((IOException)e, (Object[])new Object[]{datei});
        }
    }

    @Override
    public void saveJPEG(String datei, boolean addSuffix) throws Err_FileSys {
        this.iSaveJPEG(datei, null, addSuffix);
    }

    @Override
    public void saveJPEG(String datei, int qualitaet, boolean addSuffix) throws Err_FileSys {
        this.iSaveJPEG(datei, qualitaet, addSuffix);
    }

    private BufferedImage iARGBzuRGB(BufferedImage bild) {
        BufferedImage erg = new BufferedImage(bild.getWidth(), bild.getHeight(), 1);
        Graphics2D g2d2 = erg.createGraphics();
        g2d2.drawImage((Image)bild, 0, 0, null);
        g2d2.dispose();
        return erg;
    }

    private I_Image iNEU(Image bild, int farbbits, int dx, int dy) {
        this.farbbits = farbbits;
        this.image = dx > 0 && dy > 0 ? this.iZu24Bit(bild, (Integer)Lib_Math.min((Comparable[])new Integer[]{bild.getWidth(null), dx}), (Integer)Lib_Math.min((Comparable[])new Integer[]{bild.getHeight(null), dy})) : this.iZu24Bit(bild);
        return this;
    }

    private String iSchreibformat(IMAGE_FORMAT typ) {
        if (typ == IMAGE_FORMAT.JPEG) {
            return "jpg";
        }
        if (typ == IMAGE_FORMAT.PNG) {
            return "png";
        }
        if (typ == IMAGE_FORMAT.BMP) {
            return "bmp";
        }
        throw Err.invalid((Object[])new Object[]{"Nicht unterst\u00fctzter Bildtyp: " + (Object)((Object)typ)});
    }

    private BufferedImage iZu24Bit(Image bild) {
        BufferedImage neu = new BufferedImage(bild.getWidth(null), bild.getHeight(null), 2);
        Graphics2D g2d2 = neu.createGraphics();
        g2d2.drawImage(bild, 0, 0, null);
        g2d2.dispose();
        return neu;
    }

    private BufferedImage iZu24Bit(Image bild, int dx, int dy) {
        Point p = Lib_Graphic.calcResize(bild.getWidth(null), bild.getHeight(null), dx, dy);
        BufferedImage neu = new BufferedImage(p.x, p.y, 2);
        Graphics2D g2d = neu.createGraphics();
        g2d.drawImage(bild, 0, 0, p.x, p.y, null);
        g2d.dispose();
        return neu;
    }
}

