/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.csv;

import de.mn77.base.data.struct.table.I_Table;

public class CsvCreator {
    private final char delimiterColumn;
    private final char delimiterField;
    private final String delimiterLine;

    public CsvCreator(char field, char column, String line) {
        this.delimiterField = field;
        this.delimiterColumn = column;
        this.delimiterLine = line;
    }

    public String compute(I_Table<String> table) {
        StringBuilder sb = new StringBuilder();
        int row = 0;
        while (row < table.size()) {
            int col = 0;
            while (col < table.width()) {
                this.iAddField(sb, (String)table.getColumn(col).get(row));
                if (col < table.width() - 1) {
                    sb.append(this.delimiterColumn);
                }
                ++col;
            }
            if (row < table.size() - 1) {
                sb.append(this.delimiterLine);
            }
            ++row;
        }
        return sb.toString();
    }

    private void iAddField(StringBuilder sb, String field) {
        boolean wrap;
        if (field == null) {
            field = "";
        }
        boolean bl = wrap = field.length() > 0;
        if (wrap) {
            sb.append(this.delimiterField);
        }
        int i = 0;
        while (i < field.length()) {
            char c = field.charAt(i);
            if (c == this.delimiterField) {
                sb.append(this.delimiterField);
            }
            sb.append(c);
            ++i;
        }
        if (wrap) {
            sb.append(this.delimiterField);
        }
    }
}

