/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.crypt.digest;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.lib.crypt.CodecBase64;
import de.mn77.lib.crypt.digest.JAVA_DIGEST;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JavaDigest {
    private final JAVA_DIGEST vg;
    private final MessageDigest md;

    public static void main(String[] args) {
        try {
            JavaDigest jc = new JavaDigest(JAVA_DIGEST.SHA1);
            byte[] h1 = jc.compute("hello".getBytes());
            MOut.print((Object[])new Object[]{h1});
            MOut.print((String)new String(h1));
            MOut.print((Object[])new Object[]{CodecBase64.encode(h1)});
        }
        catch (Throwable t) {
            Err.exit((Throwable)t);
        }
    }

    public JavaDigest(JAVA_DIGEST vg) {
        Err.ifNull((Object)((Object)vg));
        this.vg = vg;
        try {
            this.md = MessageDigest.getInstance(this.vg.javaName);
        }
        catch (NoSuchAlgorithmException e) {
            throw Err.exit((Throwable)e);
        }
    }

    public void add(byte b) {
        this.md.update(b);
    }

    public void add(byte[] ba) {
        this.md.update(ba);
    }

    public void add(byte[] ba, int offset, int len) {
        this.md.update(ba, offset, len);
    }

    public byte[] compute() {
        byte[] hash = this.md.digest();
        this.md.reset();
        return hash;
    }

    public byte[] compute(byte[] data) {
        Err.ifNull((Object)data);
        byte[] hash = this.md.digest(data);
        this.md.reset();
        return hash;
    }

    public String toString() {
        return new String(CodecBase64.encode(this.compute()));
    }
}

