/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.util.Lib_E_Notation;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.parser.obj.ScanResult;
import org.jaymo_lang.util.Lib_Parser;

public class ParseObj_Number
implements I_ParseObject {
    private static final String MODIFIERS = "bsilcfdaz";

    @Override
    public boolean hits(char c0, Block current, String s) {
        return c0 >= '0' && c0 <= '9' || c0 == '+' || c0 == '-';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        A_Number obj;
        String rem;
        block18: {
            ScanResult sr = this.iScan(parser, s);
            rem = sr.rem;
            boolean emptyRem = rem.length() == 0;
            char typeChar = emptyRem ? (char)' ' : (char)rem.charAt(0);
            obj = null;
            try {
                if (emptyRem || MODIFIERS.indexOf(typeChar) < 0) {
                    obj = sr.hasE ? new JMo_Double(Double.parseDouble(sr.nr)) : (sr.hasDot ? new JMo_Dec(Dec.parseDec(sr.nr)) : new Int(Integer.parseInt(sr.nr)));
                    break block18;
                }
                String nr2 = sr.nr;
                if (typeChar == 'b' || typeChar == 's' || typeChar == 'i' || typeChar == 'l') {
                    if (sr.hasDot && !sr.hasE) {
                        throw this.iDecToIntError(parser, nr2);
                    }
                    if (sr.hasE) {
                        nr2 = Lib_E_Notation.unfold(nr2);
                    }
                }
                switch (typeChar) {
                    case 'b': {
                        obj = new JMo_Byte(Byte.parseByte(nr2));
                        rem = rem.substring(1);
                        break;
                    }
                    case 's': {
                        obj = new JMo_Short(Short.parseShort(nr2));
                        rem = rem.substring(1);
                        break;
                    }
                    case 'i': {
                        obj = new Int(Integer.parseInt(nr2));
                        rem = rem.substring(1);
                        break;
                    }
                    case 'l': {
                        obj = new JMo_Long(Long.parseLong(nr2));
                        rem = rem.substring(1);
                        break;
                    }
                    case 'c': {
                        obj = new JMo_Dec(Dec.parseDec(nr2));
                        rem = rem.substring(1);
                        break;
                    }
                    case 'f': {
                        obj = new JMo_Float(Float.parseFloat(nr2));
                        rem = rem.substring(1);
                        break;
                    }
                    case 'd': {
                        obj = new JMo_Double(Double.parseDouble(nr2));
                        rem = rem.substring(1);
                        break;
                    }
                    case 'a': {
                        BigInteger bigInt = sr.hasE ? new BigDecimal(nr2).toBigInteger() : new BigInteger(nr2);
                        obj = new JMo_BigInt(bigInt);
                        rem = rem.substring(1);
                        break;
                    }
                    case 'z': {
                        obj = new JMo_BigDec(new BigDecimal(nr2));
                        rem = rem.substring(1);
                        break;
                    }
                    default: {
                        throw Err.impossible(Character.valueOf(typeChar));
                    }
                }
            }
            catch (NumberFormatException e) {
                String type;
                int typeIdx = MODIFIERS.indexOf(typeChar);
                String string = type = typeIdx == -1 ? "Int" : (new String[]{"Byte", "Short", "Int", "Long", "Dec", "Float", "Double", "BigInt", "BigDec"})[typeIdx];
                if (sr.nr.toUpperCase().endsWith("E")) {
                    throw new CodeError("Parsing of number failed", "Missing exponent: " + sr.nr, parser);
                }
                throw new CodeError("Parsing of number failed", "Invalid or out of range for type <" + type + ">: " + sr.nr, parser);
            }
        }
        return new Group2<I_Object, String>(obj, rem);
    }

    private CodeError iDecToIntError(Parser_Script parser, String nr) {
        throw new CodeError("Invalid number", "A integer number has no dot, but got: " + nr, parser);
    }

    private ScanResult iScan(Parser_Script parser, String nr) {
        String s = nr;
        int len = s.length();
        int c = 32;
        boolean hasUnderline = false;
        boolean hasDot = false;
        boolean hasE = false;
        boolean afterExp = false;
        boolean afterDot = false;
        int i = 1;
        while (i < len) {
            c = s.charAt(i);
            if (c == 46) {
                if (hasDot) {
                    s = s.substring(0, i);
                    len = s.length();
                    break;
                }
                hasDot = true;
                afterDot = true;
            } else if (c == 95) {
                hasUnderline = true;
            } else if (!(afterDot || c != 101 && c != 69)) {
                afterExp = true;
                hasE = true;
            } else if (afterExp && (c == 45 || c == 43)) {
                afterExp = false;
            } else {
                afterExp = false;
                afterDot = false;
                if (c < 48 || c > 57) {
                    s = s.substring(0, i);
                    len = s.length();
                    break;
                }
            }
            ++i;
        }
        if (hasDot && s.charAt(s.length() - 1) == '.') {
            hasDot = false;
            s = s.substring(0, s.length() - 1);
            --len;
        }
        if (hasUnderline) {
            s = Lib_Parser.removeUnderlines(s, parser.getDebugInfo());
        }
        return new ScanResult(s, nr.substring(len), hasDot, hasE);
    }
}

