/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.sys;

import de.mn77.base.data.struct.I_Series;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ClassFinder;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Java;

public class JMo_Java
extends A_Object {
    private String classBuffer;
    private final ArgCallBuffer classNameCall;
    private final ArgCallBuffer constructorParList;
    private Object instance = null;
    private Class<?> instanceClass = null;

    public JMo_Java(Call[] args, DebugInfo debugInfo) {
        int argsLen = args.length;
        if (argsLen != 1 && argsLen != 2) {
            throw new CodeError("Invalid parameters for Java-constructor", "Want: (String class-name, List constructor_aruments)", debugInfo);
        }
        this.classBuffer = null;
        this.classNameCall = new ArgCallBuffer(0, args[0]);
        this.constructorParList = args.length == 1 ? null : new ArgCallBuffer(1, args[1]);
    }

    public JMo_Java(Class<?> cl, Call[] args, DebugInfo debugInfo) {
        this.instanceClass = cl;
        this.classBuffer = null;
        this.classNameCall = null;
        if (args == null || args.length == 0) {
            this.constructorParList = null;
        } else {
            Call cList = new Call(args[0].surrounding, new JMo_List(args), null, null, debugInfo);
            this.constructorParList = new ArgCallBuffer(0, cList);
        }
    }

    public JMo_Java(Object instance) {
        this.instance = instance;
        this.instanceClass = instance.getClass();
        this.classBuffer = null;
        this.classNameCall = null;
        this.constructorParList = null;
    }

    public String getFullTypeName() {
        return Lib_Java.packConv_classToFull(this.instanceClass);
    }

    public Class<?> getJavaClass() {
        return this.instanceClass;
    }

    public final String getJavaClassName() {
        return this.instanceClass.getSimpleName();
    }

    public Object getJavaInstance() {
        return this.instance;
    }

    public Object getJavaObject() {
        return this.instance == null ? this : this.instance;
    }

    @Override
    public void init(CallRuntime cr) {
        cr.getStrict().checkNoJava(cr.getDebugInfo());
        cr.getApp().strict.checkSandbox(cr, "Java");
        if (this.instance == null) {
            if (this.classNameCall != null) {
                this.classNameCall.init(cr, this, Str.class);
            }
            if (this.constructorParList != null) {
                this.constructorParList.init(cr, this, JMo_List.class);
            }
            if (this.classBuffer == null && this.classNameCall != null) {
                I_Object oName = this.classNameCall.get();
                this.classBuffer = Lib_Convert.getStringValue(cr, oName);
            }
            if (this.classBuffer != null) {
                if (this.classBuffer.startsWith("JMo_")) {
                    throw new RuntimeError(cr, "It's not allowed to create JayMo-Objects via Java-Class!", this.classBuffer);
                }
                this.instanceClass = this.searchClass(cr);
            }
            try {
                this.instance = this.getInstance(cr, this.instanceClass);
            }
            catch (InstantiationException e) {
                this.instance = null;
            }
        }
    }

    @Override
    public String toString() {
        return Lib_Java.packConv_classToFull(this.instanceClass);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (type != STYPE.DESCRIBE) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Java(\"");
        sb.append(this.instanceClass.getName());
        sb.append('\"');
        sb.append(", ");
        if (this.constructorParList != null) {
            sb.append(this.constructorParList.toString(cr, STYPE.DESCRIBE));
        } else {
            sb.append("[]");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String m) {
        return Lib_Java.mExec(cr, this.instance, this.instanceClass, m, this);
    }

    private Object getInstance(CallRuntime cr, Class<?> cl) throws InstantiationException {
        if (this.constructorParList == null || ((SimpleList)((JMo_List)this.constructorParList.get()).getInternalCollection()).size() == 0) {
            if (cl.getConstructors().length == 0) {
                return null;
            }
            try {
                return cl.newInstance();
            }
            catch (IllegalAccessException e) {
                String message = e.getMessage().replace("Class " + JMo_Java.class.getName(), "You");
                throw new ExternalError(cr, "Illegal access", message);
            }
            catch (SecurityException e) {
                throw new ExternalError(cr, "Illegal access", e.getMessage());
            }
        }
        JMo_List parList = (JMo_List)this.constructorParList.get();
        if (!(parList instanceof JMo_List)) {
            throw new RuntimeError(cr, "Invalid arguments for constructor", "Arguments are needed within a list.");
        }
        I_Series args = parList.getInternalCollection();
        Object[] javaPars = Lib_Java.jmoToJava(cr, ((SimpleList)args).toArray((T[])new I_Object[((SimpleList)args).size()]), null);
        Class<?>[] javaParTypes = this.iJavaTypes(javaPars);
        Constructor<?> ca = null;
        try {
            ca = cl.getConstructor(javaParTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (ca == null) {
            ca = Lib_Class.getConstructor(cl, javaPars);
        }
        if (ca == null) {
            throw new ExternalError(cr, "Invalid arguments for constructor", this.instanceClass.getName());
        }
        try {
            return ca.newInstance(javaPars);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ExternalError(cr, "Can't create object", e.getMessage());
        }
    }

    private Class<?>[] iJavaTypes(Object[] javaPars) {
        Class[] javaParTypes = new Class[javaPars.length];
        int i = 0;
        while (i < javaPars.length) {
            javaParTypes[i] = Lib_Java.toJavaType(javaPars[i]);
            ++i;
        }
        return javaParTypes;
    }

    private Class<?> searchClass(CallRuntime cr) {
        Err.ifNull((Object)this.classBuffer);
        Class<?> result = null;
        int dotIdx = this.classBuffer.indexOf(46);
        if (dotIdx >= 0) {
            try {
                result = Class.forName(this.classBuffer);
            }
            catch (ClassNotFoundException e) {
                throw new ExternalError(cr, "Java-Class not found!", this.classBuffer);
            }
        } else {
            result = ClassFinder.getInstance().searchJavaClass(this.classBuffer);
        }
        if (result == null) {
            throw new ExternalError(cr, "Java-Class not found!", this.classBuffer);
        }
        if (Lib_Class.isChildOf(result, I_Object.class)) {
            throw new ExternalError(cr, "It's not allowed to create JayMo-Objects via Java-Class!", this.classBuffer);
        }
        return result;
    }
}

