/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.data.struct.I_Series;
import de.mn77.base.data.struct.SimpleList;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.pseudo.FuncLet;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Sequence;

public class JMo_Macro
extends A_Sequence
implements I_AutoBlockDo {
    private final SimpleList<I_Object> items;

    public JMo_Macro() {
        this(null, new SimpleList<I_Object>());
    }

    public JMo_Macro(CallRuntime cr, SimpleList<I_Object> items) {
        this.items = items;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.mExec(cr);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    public I_Series<? extends I_Object> getInternalCollection() {
        return this.items;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPosition(cr, i, this.items.size(), lazy);
        if (pos > this.items.size()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.items.size(), pos, "position in makro");
        }
        if (offset == keys.length - 1) {
            return this.items.get(pos - 1);
        }
        throw new RuntimeError(cr, "Invalid access for Macro.", "A Macro is only in one dimension and has no deeper objects");
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPosition(cr, i, this.items.size(), lazy);
        if (lazy) {
            this.items.ensureCapacity(pos);
            while (this.items.size() < pos) {
                this.items.add(Nil.NIL);
            }
        }
        if (offset != keys.length - 1) {
            throw new RuntimeError(cr, "Invalid access for Macro.", "A Macro is only in one dimension and has no deeper objects");
        }
        this.items.set(pos - 1, value);
    }

    @Override
    public int sequenceSize() {
        return this.items.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (I_Object item : this.items) {
            sb.append(item.toString());
            sb.append('\n');
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case NESTED: 
            case IDENT: {
                return String.valueOf(this.getTypeName()) + '<' + this.items.size() + '>';
            }
        }
        StringBuilder sb = new StringBuilder();
        for (I_Object item : this.items) {
            sb.append(item.toString(cr, type.getNested()));
            sb.append('\n');
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.mClear(cr));
            }
            case "items": {
                return A_Object.stdResult(this.mGetItems(cr));
            }
            case "exec": {
                return A_Object.stdResult(this.mExec(cr));
            }
        }
        return null;
    }

    @Override
    protected JMo_Macro copy(CallRuntime cr) {
        cr.argsNone();
        Object clone = this.items.copy();
        return new JMo_Macro(cr, (SimpleList<I_Object>)clone);
    }

    @Override
    protected I_Object getFirst(CallRuntime cr) {
        return this.items.size() == 0 ? Nil.NIL : this.items.get(0);
    }

    @Override
    protected I_Object getLast(CallRuntime cr) {
        return this.items.size() == 0 ? Nil.NIL : this.items.get(this.items.size() - 1);
    }

    @Override
    protected void mSequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.args(this, A_IntNumber.class, FuncLet.class);
        this.sequenceSet(cr, oa[0], oa[1], lazy);
    }

    @Override
    protected void sequenceContent(CallRuntime cr, I_Object[] values) {
        int i = 0;
        while (i < this.items.size()) {
            FuncLet func = (FuncLet)cr.argType(values[i], FuncLet.class);
            this.items.set(i, func);
            ++i;
        }
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.items.isEmpty();
    }

    @Override
    protected I_Object sequenceGetPull(CallRuntime cr, boolean lazy, I_Object arg) {
        A_IntNumber pos = (A_IntNumber)cr.argType(arg, A_IntNumber.class);
        int pos2 = Lib_Convert.getIntValue(cr, pos);
        if (lazy && pos2 > this.items.size()) {
            return Nil.NIL;
        }
        Lib_Error.ifNotBetween(cr, 1, this.items.size(), pos2, "position");
        return this.items.get(pos2 - 1);
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int oi = Lib_Convert.getIntValue(cr, key);
        int pos = Lib_Sequence.realPosition(cr, oi, this.items.size(), lazy);
        return pos == -1 ? Nil.NIL : this.items.get(pos - 1);
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object key, I_Object value, boolean lazy) {
        int pos = Lib_Convert.getIntValue(cr, key);
        if (lazy) {
            this.items.ensureCapacity(pos);
            while (pos > this.items.size()) {
                this.items.add(Nil.NIL);
            }
        }
        Lib_Error.ifNotBetween(cr, 1, this.items.size(), pos, "position");
        FuncLet o = (FuncLet)value;
        this.items.set(pos - 1, o);
    }

    private JMo_Macro mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        this.items.ensureCapacity(this.items.size() + args.length);
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            FuncLet func = (FuncLet)cr.argType(arg, FuncLet.class);
            this.items.add(func);
            ++n2;
        }
        return this;
    }

    private JMo_Macro mClear(CallRuntime cr) {
        cr.argsNone();
        this.items.clear();
        return this;
    }

    private JMo_Macro mExec(CallRuntime cr) {
        cr.argsNone();
        for (I_Object item : this.items) {
            if (item == Nil.NIL) continue;
            ((FuncLet)item).exec(cr);
        }
        return this;
    }

    private JMo_List mGetItems(CallRuntime cr) {
        cr.argsNone();
        Object clone = this.items.copy();
        return new JMo_List((SimpleList<I_Object>)clone);
    }
}

