/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute;

import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Type;

public class JMo_KeyValue
extends A_Immutable {
    private I_Object key;
    private I_Object value;
    private ArgCallBuffer cKey = null;
    private ArgCallBuffer cValue = null;

    public JMo_KeyValue(Call cKey, Call cValue) {
        this.cKey = new ArgCallBuffer(0, cKey);
        this.cValue = new ArgCallBuffer(1, cValue);
    }

    public JMo_KeyValue(I_Object key, I_Object value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof JMo_KeyValue) {
            JMo_KeyValue other2 = (JMo_KeyValue)other;
            return this.key.equals(other2.key) && this.value.equals(other2.value);
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object other) {
        return this.equals(other);
    }

    public I_Object getKey() {
        return this.key;
    }

    public I_Object getValue() {
        return this.value;
    }

    @Override
    public void init(CallRuntime cr) {
        I_Object o;
        if (this.cKey != null) {
            o = this.cKey.init(cr, this, I_Object.class);
            this.key = Lib_Convert.getValue(cr, o);
        }
        if (this.cValue != null) {
            o = this.cValue.init(cr, this, I_Object.class);
            this.value = Lib_Convert.getValue(cr, o);
        }
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.key + " -> " + this.value.toString();
            }
            case IDENT: {
                return this.getTypeName();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Lib_Type.getName(this));
        sb.append("(");
        String sk = this.key.toString(cr, STYPE.DESCRIBE);
        sk = Lib_Output.indentLines(sk, false);
        sb.append(sk);
        sb.append(",");
        String sv = this.value.toString(cr, STYPE.DESCRIBE);
        sv = Lib_Output.indentLines(sv, false);
        sb.append(sv);
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "key": {
                return A_Object.stdResult(this.mKey(cr));
            }
            case "value": {
                return A_Object.stdResult(this.mValue(cr));
            }
        }
        return null;
    }

    private I_Object mKey(CallRuntime cr) {
        cr.argsNone();
        return this.key;
    }

    private I_Object mValue(CallRuntime cr) {
        cr.argsNone();
        return this.value;
    }
}

