/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.HtmlChars;
import de.mn77.base.data.constant.ALIGN;
import de.mn77.base.data.constant.position.Lib_Position;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.convert.ConvertChar;
import de.mn77.base.data.convert.ConvertString;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.numsys.NumSys_Binary;
import de.mn77.base.data.numsys.NumSys_Hex;
import de.mn77.base.data.search.SearchText;
import de.mn77.base.data.struct.I_Collection;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.I_AutoBlockList;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.JMo_Range;
import org.jaymo_lang.object.JMo_RegEx;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.I_DeepGetSet;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.object.sys.JMo_Cmd;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Sequence;
import org.jaymo_lang.util.Lib_StrFormat;
import org.jaymo_lang.util.Lib_Type;

public class Str
extends A_Chars
implements I_Atomic,
I_AutoBlockDo,
I_AutoBlockList,
I_DeepGetSet {
    private final String value;

    public Str(String val) {
        Err.ifNull((Object)val);
        this.value = val;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public SimpleList<I_Object> autoBlockToList(CallRuntime cr) {
        SimpleList<I_Object> result = new SimpleList<I_Object>(this.value.length());
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            result.add(new Char(c));
            ++n2;
        }
        return result;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.STR;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Boolean isGreater3(I_Atomic o) {
        if (o instanceof Str) {
            return Lib_Compare.isGreaterString(this.value, ((Str)o).getValue());
        }
        return null;
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPosition(cr, i, this.value.length(), lazy);
        if (pos == -1 || pos > this.value.length()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.value.length(), pos, "position in list");
        }
        if (offset != keys.length - 1) {
            StringBuilder sb = new StringBuilder();
            int j = 0;
            while (j <= offset) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(keys[j].toString());
                ++j;
            }
            throw new RuntimeError(cr, "Invalid type of item.", "Item at position (" + sb.toString() + ") is a single <Char>, so I can't go deeper!");
        }
        return new Char(this.value.charAt(pos - 1));
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        throw new RuntimeError(cr, "Invalid type of item.", "A String is immutable, so it can't be modified!");
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: {
                return this.value;
            }
            case NESTED: {
                return this.value.length() <= 40 ? this.value : String.valueOf(this.value.substring(0, 40)) + "\u2026";
            }
            case IDENT: {
                String si = FormString.escapeSpecialChars(this.value, false, true);
                return si.length() <= 40 ? "\"" + si + "\"" : "\"" + si.substring(0, 37) + "\u2026\"";
            }
            case DESCRIBE: {
                String sd = FormString.escapeSpecialChars(this.value, false, true);
                return "\"" + sd + "\"";
            }
        }
        throw Err.impossible(new Object[]{type});
    }

    @Override
    protected ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "isEmpty": {
                cr.argsNone();
                return A_Object.stdResult(Bool.getObject(this.value.isEmpty()));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.mSubtract(cr));
            }
            case "begin": {
                return A_Object.stdResult(this.mBegin(cr));
            }
            case "cut": {
                return A_Object.stdResult(this.mCut(cr));
            }
            case "part": {
                return A_Object.stdResult(this.mPart(cr));
            }
            case "left": {
                return A_Object.stdResult(this.mLeft(cr));
            }
            case "right": {
                return A_Object.stdResult(this.mRight(cr));
            }
            case "first": {
                return A_Object.stdResult(this.mFirstLast(cr, false));
            }
            case "last": {
                return A_Object.stdResult(this.mFirstLast(cr, true));
            }
            case "end": {
                return A_Object.stdResult(this.mEndPos(cr));
            }
            case "start": {
                return A_Object.stdResult(this.mStartPos(cr));
            }
            case "from": 
            case "fromFirst": {
                return A_Object.stdResult(this.mFromFirst(cr, true));
            }
            case "after": 
            case "afterFirst": {
                return A_Object.stdResult(this.mFromFirst(cr, false));
            }
            case "tillFirst": 
            case "till": {
                return A_Object.stdResult(this.mTillFirst(cr, true));
            }
            case "before": 
            case "beforeFirst": {
                return A_Object.stdResult(this.mTillFirst(cr, false));
            }
            case "fromLast": {
                return A_Object.stdResult(this.mFromLast(cr, true));
            }
            case "afterLast": {
                return A_Object.stdResult(this.mFromLast(cr, false));
            }
            case "tillLast": {
                return A_Object.stdResult(this.mTillLast(cr, true));
            }
            case "beforeLast": {
                return A_Object.stdResult(this.mTillLast(cr, false));
            }
            case "/": 
            case "div": {
                return A_Object.stdResult(this.mDivide(cr));
            }
            case "explode": 
            case "split": {
                return A_Object.stdResult(this.mSplit(cr));
            }
            case "splitKeep": {
                return A_Object.stdResult(this.mSplitKeep(cr));
            }
            case "group": {
                return A_Object.stdResult(this.mGroup(cr));
            }
            case "lines": {
                return A_Object.stdResult(this.mLines(cr));
            }
            case "words": {
                return A_Object.stdResult(this.mWords(cr));
            }
            case "field": {
                return A_Object.stdResult(this.mField(cr));
            }
            case "fields": {
                return A_Object.stdResult(this.mFields(cr));
            }
            case "table": {
                return A_Object.stdResult(this.mTable(cr));
            }
            case "scan": {
                return A_Object.stdResult(this.mScan(cr));
            }
            case "capitalFirst": 
            case "capital": {
                return A_Object.stdResult(this.mCapital(cr, true));
            }
            case "capitalAll": {
                return A_Object.stdResult(this.mCapital(cr, false));
            }
            case "trim": {
                return A_Object.stdResult(this.mTrim(cr, true, true));
            }
            case "trimLeft": {
                return A_Object.stdResult(this.mTrim(cr, true, false));
            }
            case "trimRight": {
                return A_Object.stdResult(this.mTrim(cr, false, true));
            }
            case "width": {
                return A_Object.stdResult(this.mWidth(cr));
            }
            case "startsWith": {
                return A_Object.stdResult(this.mStartsWith(cr));
            }
            case "contains": {
                return A_Object.stdResult(this.mContains(cr));
            }
            case "endsWith": {
                return A_Object.stdResult(this.mEndsWith(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.mSearch(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.mSearch(cr, false));
            }
            case "count": {
                return A_Object.stdResult(this.mCount(cr));
            }
            case "replace": {
                return A_Object.stdResult(this.mReplace(cr));
            }
            case "match": {
                return A_Object.stdResult(this.mMatch(cr));
            }
            case "set": {
                return A_Object.stdResult(this.mSetChar(cr, false));
            }
            case "put": {
                return A_Object.stdResult(this.mSetChar(cr, true));
            }
            case "reverse": {
                return A_Object.stdResult(this.mReverse(cr));
            }
            case "insert": {
                return A_Object.stdResult(this.mInsert(cr));
            }
            case "align": {
                return A_Object.stdResult(this.mAlign(cr));
            }
            case "fill": {
                return A_Object.stdResult(this.mFill(cr));
            }
            case "quote": {
                return A_Object.stdResult(this.mQuote(cr));
            }
            case "unquote": {
                return A_Object.stdResult(this.mUnquote(cr));
            }
            case "escapeSlashes": {
                return A_Object.stdResult(this.mEscape(cr, false));
            }
            case "escape": 
            case "escapeAll": {
                return A_Object.stdResult(this.mEscape(cr, true));
            }
            case "unescape": {
                return A_Object.stdResult(this.mUnescape(cr));
            }
            case "htmlSpecialChars": 
            case "htmlSpecial": {
                return A_Object.stdResult(this.mHtmlSpecialChars(cr));
            }
            case "htmlEntities": {
                return A_Object.stdResult(this.mHtmlEntities(cr));
            }
            case "htmlDecode": {
                return A_Object.stdResult(this.mHtmlDecode(cr));
            }
            case "jmo": 
            case "jaymo": {
                return A_Object.stdResult(this.mExecJAYMO(cr));
            }
            case "cmd": {
                return A_Object.stdResult(this.mExecCMD(cr));
            }
            case "parseHex": {
                return A_Object.stdResult(this.mParseHex(cr));
            }
            case "parseUnicode": {
                return A_Object.stdResult(this.mParseUnicode(cr));
            }
            case "parseBin": {
                return A_Object.stdResult(this.mParseBin(cr));
            }
            case "toChars": 
            case "chars": {
                return A_Object.stdResult(this.mToChars(cr));
            }
            case "each": {
                return this.each(cr);
            }
            case "bytes": 
            case "toByteArray": {
                return A_Object.stdResult(this.mToByteArray(cr));
            }
            case "toRegEx": {
                cr.argsNone();
                return A_Object.stdResult(new JMo_RegEx(this.value));
            }
            case "unite": {
                return A_Object.stdResult(this.mUnite(cr));
            }
            case "unique": 
            case "uniq": {
                return A_Object.stdResult(this.mUnique(cr));
            }
            case "only": {
                return A_Object.stdResult(this.mOnly(cr));
            }
            case "filter": {
                return A_Object.stdResult(this.mFilter(cr, method));
            }
            case "map": {
                return A_Object.stdResult(this.mMap(cr, method));
            }
            case "sort": {
                return A_Object.stdResult(this.mSort(cr, method));
            }
            case "reduce": {
                return A_Object.stdResult(this.mReduce(cr, method));
            }
            case "amount": {
                return A_Object.stdResult(this.mAmount(cr, method));
            }
        }
        return null;
    }

    @Override
    protected boolean charsIsBlank() {
        return this.value.isBlank();
    }

    @Override
    protected boolean charsIsCaseDown() {
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLowerCase(c)) {
                return false;
            }
            ++n2;
        }
        return !this.value.isEmpty();
    }

    @Override
    protected boolean charsIsCaseUp() {
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isUpperCase(c)) {
                return false;
            }
            ++n2;
        }
        return !this.value.isEmpty();
    }

    @Override
    protected boolean charsIsNumber() {
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                return false;
            }
            ++n2;
        }
        return !this.value.isEmpty();
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        throw this.newErrorMinMaxValue(cr);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return new Str("");
    }

    @Override
    protected Str mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        String result = this.value;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            result = String.valueOf(result) + Lib_Convert.getStringValue(cr, arg);
            ++n2;
        }
        return new Str(result);
    }

    @Override
    protected Str mCaseDown(CallRuntime cr) {
        cr.argsNone();
        return new Str(this.value.toLowerCase());
    }

    @Override
    protected Str mCaseUp(CallRuntime cr) {
        cr.argsNone();
        return new Str(this.value.toUpperCase());
    }

    @Override
    protected Str mChangeChar(CallRuntime cr) {
        I_Object[] oa = cr.args(this, A_IntNumber.class, A_Chars.class);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        pos = Lib_Sequence.realPosition(cr, pos, this.value.length(), false);
        I_Object o = oa[1];
        String n = Lib_Convert.getStringValue(cr, o);
        String l = pos == 1 ? "" : this.value.substring(0, pos - 1);
        String r = pos == this.value.length() ? "" : this.value.substring(pos);
        return new Str(String.valueOf(l) + n + r);
    }

    @Override
    protected I_Object mCharAt(CallRuntime cr, boolean lazy) {
        int pos = Lib_Convert.getIntValue(cr, cr.args(this, A_IntNumber.class)[0]);
        pos = Lib_Sequence.realPosition(cr, pos, this.value.length(), lazy);
        if (lazy && (pos < 1 || pos > this.value.length())) {
            return Nil.NIL;
        }
        return new Char(this.value.charAt(pos - 1));
    }

    @Override
    protected Bool mComparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.args(this, A_Chars.class)[0];
        String arg = Lib_Convert.getStringValue(cr, o);
        switch (m) {
            case G: {
                return Bool.getObject(this.value.compareTo(arg) > 0);
            }
            case L: {
                return Bool.getObject(this.value.compareTo(arg) < 0);
            }
            case GE: {
                return Bool.getObject(this.value.compareTo(arg) >= 0);
            }
            case LE: {
                return Bool.getObject(this.value.compareTo(arg) <= 0);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected Str mMultiply(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int i = Lib_Convert.getIntValue(cr, arg);
        String s = Lib_String.sequence(this.value, (long)i);
        return new Str(s);
    }

    @Override
    protected JMo_List mSelect(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        SimpleList<I_Object> list = new SimpleList<I_Object>(args.length);
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int pos = Lib_Convert.getIntValue(cr, cr.argType(arg, A_IntNumber.class));
            pos = Lib_Sequence.realPosition(cr, pos, this.value.length(), lazy);
            if (lazy && (pos < 1 || pos > this.value.length())) {
                list.add(Nil.NIL);
            } else {
                list.add(new Char(this.value.charAt(pos - 1)));
            }
            ++n2;
        }
        return new JMo_List(list);
    }

    @Override
    protected final Str mUpdate(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 1);
        I_Object obj = cr.argType(oa[0], null);
        char c = Lib_Convert.getCharValue(cr, obj);
        StringBuilder sb = new StringBuilder(this.value);
        int i = 1;
        while (i < oa.length) {
            int pos1 = Lib_Convert.getIntValue(cr, cr.argType(oa[i], A_IntNumber.class));
            int pos2 = Lib_Sequence.realPosition(cr, pos1, sb.length(), lazy);
            if (pos2 < 0 && lazy) {
                pos2 = pos1;
                while (pos2 > sb.length()) {
                    sb.append(' ');
                }
            }
            sb.setCharAt(pos2 - 1, c);
            ++i;
        }
        return new Str(sb.toString());
    }

    private ObjectCallResult each(CallRuntime crOld) {
        crOld.argsNone();
        Lib_Exec.checkLoopWithout(crOld);
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = Nil.NIL;
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            handle.startLap();
            Char it = new Char(c);
            result = Lib_Exec.execBlockStream(crNew, it);
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++n2;
        }
        return new ObjectCallResult(result, true);
    }

    private Str mAlign(CallRuntime cr) {
        I_Object[] args = cr.args(this, MagicPosition.class, A_IntNumber.class);
        int arg = Lib_Convert.getIntValue(cr, args[1]);
        MagicPosition pos1 = (MagicPosition)Lib_Convert.getValue(cr, args[0]);
        POSITION pos2 = pos1.get();
        if (!Lib_Position.isHorizontal(pos2)) {
            throw new RuntimeError(cr, "Invalid position", "Only left,center and right are alowed. Got: " + pos1);
        }
        ALIGN align = Lib_Position.toAlign((POSITION_H)((Object)pos2));
        String s = FormString.width(arg, ' ', this.value, align, false);
        return new Str(s);
    }

    private Int mAmount(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        int result = 0;
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char test = cArray[n2];
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{new Char(test)}, Bool.class);
            if (ok.getValue().booleanValue()) {
                ++result;
            }
            ++n2;
        }
        return new Int(result);
    }

    private Str mBegin(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        String ps = Lib_Convert.getStringValue(cr, arg);
        return new Str(String.valueOf(ps) + this.value);
    }

    private Str mCapital(CallRuntime cr, boolean onlyFirst) {
        cr.argsNone();
        String result = Lib_String.capitalize(this.value, onlyFirst);
        return new Str(result);
    }

    private Bool mContains(CallRuntime cr) {
        I_Atomic arg = (I_Atomic)cr.args(this, I_Atomic.class)[0];
        int index = this.value.indexOf(Lib_Convert.getStringValue(cr, arg));
        return Bool.getObject(index > -1);
    }

    private Int mCount(CallRuntime cr) {
        I_Object arg = cr.args(this, Char.class)[0];
        int result = SearchText.countChar(this.value, ((Char)arg).getValue().charValue());
        return new Int(result);
    }

    private Str mCut(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, A_IntNumber.class);
        int from = Lib_Convert.getIntValue(cr, args[0]);
        int len = Lib_Convert.getIntValue(cr, args[1]);
        Lib_Error.ifNotBetween(cr, 1, this.value.length(), from, "'from'");
        Lib_Error.ifNotBetween(cr, 0, this.value.length() - from + 1, len, "'length'");
        int to = from + len;
        String s = this.value.substring(from - 1, to - 1);
        return new Str(s);
    }

    private JMo_List mDivide(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int divisor = Lib_Convert.getIntValue(cr, arg);
        int len = this.value.length();
        Lib_Error.ifNotBetween(cr, 1, len, divisor, "Argument");
        JMo_List list = new JMo_List();
        float part = (float)len / (float)divisor;
        int start = 0;
        float val = 0.0f;
        while (start < len) {
            int end = Math.min(len, Math.round(val + part));
            String s = this.value.substring(start, end);
            list.internalAdd(new Str(s));
            start = end;
            val += part;
        }
        return list;
    }

    private Str mEndPos(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int to = Lib_Convert.getIntValue(cr, arg);
        if (to == 0) {
            throw new RuntimeError(cr, "Invalid position in string", "Position can't be 0");
        }
        if (to >= this.value.length()) {
            return new Str(this.value);
        }
        if (to < 0 && Math.abs(to) > this.value.length()) {
            return new Str("");
        }
        if (to < 0) {
            to = this.value.length() + to + 1;
        }
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private Bool mEndsWith(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            String s = Lib_Convert.getStringValue(cr, cr.argType(o, I_Atomic.class));
            if (this.value.endsWith(s)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private I_Object mEscape(CallRuntime cr, boolean full) {
        cr.argsNone();
        String result = full ? FormString.escapeSpecialChars(this.value, false, false) : FormString.escapeSlashes(this.value);
        return new Str(result);
    }

    private I_Object mExecCMD(CallRuntime cr) {
        cr.argsNone();
        cr.getStrict().checkSandbox(cr, "Str.cmd");
        Call c = new Call(cr, this);
        return new JMo_Cmd(c);
    }

    private A_Immutable mExecJAYMO(CallRuntime cr) {
        cr.argsNone();
        return Lib_Exec.execJayMo(cr, this.value, "Str.jaymo", null);
    }

    private Str mField(CallRuntime cr) {
        I_Object[] oa = cr.args(this, I_Atomic.class, A_IntNumber.class);
        String delimiter = Lib_Convert.getStringValue(cr, oa[0]);
        String[] sa = this.value.split(delimiter);
        int col = Lib_Convert.getIntValue(cr, oa[1]);
        Lib_Error.ifTooSmall(cr, 1L, col);
        return col > sa.length ? new Str("") : new Str(sa[col - 1]);
    }

    private JMo_List mFields(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 1);
        I_Object parDelimiter = cr.argType(oa[0], I_Atomic.class);
        String delimiter = Lib_Convert.getStringValue(cr, parDelimiter);
        String[] sa = this.value.split(delimiter);
        SimpleList<I_Object> al = new SimpleList<I_Object>(sa.length);
        if (oa.length == 1) {
            String[] stringArray = sa;
            int n = sa.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                al.add(new Str(s));
                ++n2;
            }
        } else {
            int i = 1;
            while (i < oa.length) {
                int col = Lib_Convert.getIntValue(cr, oa[i]);
                Lib_Error.ifTooSmall(cr, 1L, col);
                Str s = col > sa.length ? new Str("") : new Str(sa[col - 1]);
                al.add(s);
                ++i;
            }
        }
        return new JMo_List(al);
    }

    private Str mFill(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 0, 0);
        int oaPos = 0;
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (pos < this.value.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(this.value, pos);
            pos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue()) {
                sb.append((String)part.o2);
                continue;
            }
            if (oaPos >= oa.length) continue;
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, oa[oaPos]));
            ++oaPos;
        }
        return new Str(sb.toString());
    }

    private Str mFilter(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        StringBuilder result = new StringBuilder();
        int p = 0;
        while (p < this.value.length()) {
            char test = this.value.charAt(p);
            Char testc = new Char(test);
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{testc}, Bool.class);
            if (ok.getValue().booleanValue()) {
                result.append(test);
            }
            ++p;
        }
        return new Str(result.toString());
    }

    private Char mFirstLast(CallRuntime cr, boolean last) {
        cr.argsNone();
        if (this.value.length() == 0) {
            throw new RuntimeError(cr, "Empty String", "Can't get first or last Char.");
        }
        return new Char(this.value.charAt(last ? this.value.length() - 1 : 0));
    }

    private Str mFromFirst(CallRuntime cr, boolean withDelimiter) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int idx = -1;
        String lastDelimiter = null;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, arg);
            int idx2 = this.value.indexOf(delimiter);
            if (idx2 > -1 && (idx == -1 || idx2 < idx)) {
                idx = idx2;
                lastDelimiter = delimiter;
            }
            ++n2;
        }
        String result = idx >= 0 ? this.value.substring(idx + (withDelimiter ? 0 : lastDelimiter.length())) : "";
        return new Str(result);
    }

    private Str mFromLast(CallRuntime cr, boolean withDelimiter) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int beginindex = -1;
        String lastDelimiter = null;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, arg);
            int idx2 = this.value.lastIndexOf(delimiter);
            if (idx2 > -1 && (beginindex == -1 || idx2 > beginindex)) {
                beginindex = idx2;
                lastDelimiter = delimiter;
            }
            ++n2;
        }
        String result = beginindex >= 0 ? this.value.substring(beginindex + (withDelimiter ? 0 : lastDelimiter.length())) : "";
        return new Str(result);
    }

    private JMo_List mGroup(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int step = Lib_Convert.getIntValue(cr, arg);
        Lib_Error.ifTooSmall(cr, 1L, step);
        JMo_List list = new JMo_List();
        String str = this.value;
        int start = 0;
        while (start < str.length()) {
            list.internalAdd(new Str(str.substring(start, Math.min(str.length(), start + step))));
            start += step;
        }
        return list;
    }

    private I_Object mHtmlDecode(CallRuntime cr) {
        cr.argsNone();
        String result = HtmlChars.htmlEntitiesDecode(this.value);
        return new Str(result);
    }

    private I_Object mHtmlEntities(CallRuntime cr) {
        cr.argsNone();
        String result = HtmlChars.htmlEntities(this.value);
        return new Str(result);
    }

    private I_Object mHtmlSpecialChars(CallRuntime cr) {
        cr.argsNone();
        String result = HtmlChars.htmlSpecialChars(this.value);
        return new Str(result);
    }

    private I_Object mInsert(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_Atomic.class, A_IntNumber.class);
        String ins = Lib_Convert.getStringValue(cr, args[0]);
        int pos = Lib_Convert.getIntValue(cr, args[1]);
        int len = this.value.length();
        int rpos = Lib_Sequence.realPosition(cr, pos, len + 1, false);
        String result = Lib_String.insert(ins, rpos, this.value);
        return new Str(result);
    }

    private Str mLeft(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int to = Lib_Convert.getIntValue(cr, arg);
        if (to > this.value.length()) {
            return this;
        }
        Lib_Error.ifTooSmall(cr, 1L, to);
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private JMo_List mLines(CallRuntime cr) {
        cr.argsNone();
        String[] sa = this.value.split("\n");
        JMo_List list = new JMo_List();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.internalAdd(new Str(s));
            ++n2;
        }
        return list;
    }

    private Str mMap(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        StringBuilder result = new StringBuilder();
        int p = 0;
        while (p < this.value.length()) {
            Char test = new Char(this.value.charAt(p));
            I_Object[] each = new I_Object[]{test};
            I_Object testr = cr.copyEach(method).argsEach(this, 0, each, I_Object.class);
            result.append(testr);
            ++p;
        }
        return new Str(result.toString());
    }

    private Bool mMatch(CallRuntime cr) {
        I_Object o = cr.args(this, JMo_RegEx.class)[0];
        String reg = ((JMo_RegEx)o).getValue();
        return Bool.getObject(this.value.matches(reg));
    }

    private I_Object mOnly(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        String[] allowed = new String[args.length];
        int i = 0;
        while (i < args.length) {
            I_Object arg = cr.argTypeExt(args[i], A_Chars.class, JMo_Range.class);
            if (arg instanceof Char) {
                allowed[i] = "" + ((Char)arg).getValue();
            } else if (arg instanceof Str) {
                allowed[i] = ((Str)arg).value;
            } else if (arg instanceof JMo_Range) {
                allowed[i] = ((JMo_Range)arg).computeString(cr);
            } else {
                Err.impossible(arg);
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder(this.value.length());
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            boolean okay = false;
            String[] stringArray = allowed;
            int n3 = allowed.length;
            int n4 = 0;
            while (n4 < n3) {
                String chars = stringArray[n4];
                if (chars.indexOf(c) >= 0) {
                    okay = true;
                    break;
                }
                ++n4;
            }
            if (okay) {
                sb.append(c);
            }
            ++n2;
        }
        return new Str(sb.toString());
    }

    private Int mParseBin(CallRuntime cr) {
        cr.argsNone();
        int i = NumSys_Binary.fromBin(this.value);
        return new Int(i);
    }

    private Int mParseHex(CallRuntime cr) {
        cr.argsNone();
        int i = NumSys_Hex.fromHex(this.value);
        return new Int(i);
    }

    private Char mParseUnicode(CallRuntime cr) {
        cr.argsNone();
        char c = ConvertChar.parseUnicode(this.value);
        return new Char(c);
    }

    private Str mPart(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, A_IntNumber.class);
        int from = Lib_Convert.getIntValue(cr, args[0]);
        int to = Lib_Convert.getIntValue(cr, args[1]);
        Lib_Error.ifNotBetween(cr, 1, this.value.length(), from, "'from'");
        Lib_Error.ifNotBetween(cr, from, this.value.length(), to, "'length'");
        String s = this.value.substring(from - 1, to);
        return new Str(s);
    }

    private I_Object mQuote(CallRuntime cr) {
        I_Object arg;
        I_Object[] args = cr.argsFlex(this, 0, 2);
        int format = 2;
        boolean escape = false;
        if (args.length >= 1) {
            arg = cr.argType(args[0], A_IntNumber.class);
            format = Lib_Convert.getIntValue(cr, arg);
        }
        if (args.length == 2) {
            arg = cr.argType(args[1], Bool.class);
            escape = Lib_Convert.getBoolValue(cr, arg);
        }
        switch (format) {
            case 1: {
                return new Str(FormString.quote(this.value, '\'', '\\', escape));
            }
            case 2: {
                return new Str(FormString.quote(this.value, '\"', '\\', escape));
            }
            case 3: {
                return new Str(FormString.quote(this.value, '\'', '\'', escape));
            }
            case 4: {
                return new Str(FormString.quote(this.value, '\"', '\"', escape));
            }
        }
        throw new RuntimeError(cr, "Invalid quote format", "Allowed are 1-4, but got: " + format);
    }

    private I_Object mReduce(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)3, cr, this);
        I_Object sum = cr.argsOneAdvance(this, 0, I_Object.class);
        int p = 0;
        while (p < this.value.length()) {
            Char test = new Char(this.value.charAt(p));
            I_Object[] each = new I_Object[]{sum, test};
            sum = cr.copyEach(method).argsEach(this, 1, each, I_Object.class);
            ++p;
        }
        return sum;
    }

    private Str mReplace(CallRuntime cr) {
        I_Object[] args = cr.argsExt(this, {I_Atomic.class, JMo_RegEx.class}, {I_Atomic.class});
        String s2 = Lib_Convert.getStringValue(cr, args[1]);
        if (args[0] instanceof JMo_RegEx) {
            String regex = ((JMo_RegEx)args[0]).getValue();
            try {
                String result = this.value.replaceAll(regex, s2);
                return new Str(result);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeError(cr, "Invalid Pattern Syntax", e.getMessage());
            }
        }
        String s1 = Lib_Convert.getStringValue(cr, args[0]);
        String result = this.value.replace(s1, s2);
        return new Str(result);
    }

    private I_Object mReverse(CallRuntime cr) {
        cr.argsNone();
        int len = this.value.length();
        char[] source = this.value.toCharArray();
        char[] target = new char[len];
        int i = 0;
        while (i < len) {
            target[i] = source[len - 1 - i];
            ++i;
        }
        return new Str(new String(target));
    }

    private Str mRight(CallRuntime cr) {
        int len;
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int begin = Lib_Convert.getIntValue(cr, arg);
        if (begin > (len = this.value.length())) {
            return this;
        }
        Lib_Error.ifTooSmall(cr, 1L, begin);
        String s = this.value.substring(len - begin);
        return new Str(s);
    }

    private JMo_List mScan(CallRuntime cr) {
        I_Object[] oa = cr.args(this, I_Atomic.class, I_Atomic.class);
        String start = Lib_Convert.getStringValue(cr, oa[0]);
        String end = Lib_Convert.getStringValue(cr, oa[1]);
        SimpleList<I_Object> result = new SimpleList<I_Object>();
        int len = this.value.length();
        int idx = 0;
        int next = 0;
        boolean open = false;
        while (idx < len) {
            if (!open) {
                next = this.value.indexOf(start, idx);
                if (next == -1) {
                    return new JMo_List(result);
                }
                idx = next + start.length();
                open = true;
                continue;
            }
            next = this.value.indexOf(end, idx);
            if (next == -1) {
                result.add(new Str(this.value.substring(idx)));
                return new JMo_List(result);
            }
            result.add(new Str(this.value.substring(idx, next)));
            idx = next + end.length();
            open = false;
        }
        if (open) {
            result.add(new Str(this.value.substring(idx)));
        }
        return new JMo_List(result);
    }

    private A_Immutable mSearch(CallRuntime cr, boolean first) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        String search = Lib_Convert.getStringValue(cr, arg);
        int idx = first ? this.value.indexOf(search) : this.value.lastIndexOf(search);
        return idx < 0 ? Nil.NIL : new Int(idx + 1);
    }

    private Str mSetChar(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.args(this, Char.class, A_IntNumber.class);
        char c = Lib_Convert.getCharValue(cr, args[0]);
        int pos1 = Lib_Convert.getIntValue(cr, args[1]);
        int pos = Lib_Sequence.realPosition(cr, pos1, this.value.length(), lazy);
        String base = this.value;
        if (pos == -1) {
            int posAbs = Math.abs(pos1);
            if (pos1 < 0) {
                pos = 1;
                base = String.valueOf(Lib_String.sequence(' ', (long)(posAbs - base.length()))) + base;
            } else {
                pos = posAbs;
                base = String.valueOf(base) + Lib_String.sequence(' ', (long)(posAbs - base.length()));
            }
        }
        String result = pos <= 1 ? "" : base.substring(0, pos - 1);
        result = String.valueOf(result) + c;
        result = String.valueOf(result) + base.substring(pos);
        return new Str(result);
    }

    private Str mSort(CallRuntime cr, String method) {
        int parCount = cr.argCount();
        Lib_Error.ifArgs(parCount, 0, (Integer)2, cr, this);
        SimpleList<Character> list = new SimpleList<Character>(this.value.length());
        Object object = this.value.toCharArray();
        int n = ((char[])object).length;
        int n2 = 0;
        while (n2 < n) {
            char c = object[n2];
            list.add(Character.valueOf(c));
            ++n2;
        }
        if (parCount == 0) {
            cr.argsNone();
            list.sort((o1, o2) -> Lib_Compare.isEqual(o1, o2) ? 0 : (Lib_Compare.isGreater(o1, o2) ? 1 : -1));
            StringBuilder sb = new StringBuilder();
            for (Character c : list) {
                sb.append(c);
            }
            return new Str(sb.toString());
        }
        int l = 1;
        while (l < list.size()) {
            int smallest = l;
            int m = l + 1;
            while (m <= list.size()) {
                Character buffer1 = (Character)list.get(smallest - 1);
                Character buffer2 = (Character)list.get(m - 1);
                I_Object[] test = new I_Object[]{new Char(buffer1.charValue()), new Char(buffer2.charValue())};
                Bool correct = (Bool)cr.copyEach(method).argsEach(this, 0, test, Bool.class);
                if (!correct.getValue().booleanValue()) {
                    smallest = m;
                }
                ++m;
            }
            if (l != smallest) {
                int pos1 = smallest - 1;
                int pos2 = l - 1;
                Character buffer1 = (Character)list.get(pos1);
                Character buffer2 = (Character)list.get(pos2);
                list.set(pos1, buffer2);
                list.set(pos2, buffer1);
            }
            ++l;
        }
        StringBuilder sb = new StringBuilder();
        object = list.iterator();
        while (object.hasNext()) {
            Character c = (Character)object.next();
            sb.append(c);
        }
        return new Str(sb.toString());
    }

    private JMo_List mSplit(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        I_Object arg = args.length == 0 ? null : cr.argTypeExt(args[0], A_Chars.class, JMo_RegEx.class);
        JMo_List list = new JMo_List();
        if (args.length == 0 || arg instanceof Str && ((Str)arg).value.length() == 0) {
            char[] cArray = this.value.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                list.internalAdd(new Char(c));
                ++n2;
            }
        } else if (arg instanceof JMo_RegEx) {
            String[] sa;
            String regex = ((JMo_RegEx)arg).getValue();
            String[] stringArray = sa = this.value.split(regex);
            int n = sa.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                list.internalAdd(new Str(s));
                ++n3;
            }
        } else {
            String delimiter = "" + ((I_Atomic)arg).getValue();
            List<String> sl = ConvertString.toList(delimiter, this.value);
            for (String s : sl) {
                list.internalAdd(new Str(s));
            }
        }
        return list;
    }

    private JMo_List mSplitKeep(CallRuntime cr) {
        I_Object o = cr.argsExt(this, new Class[][]{{I_Atomic.class, JMo_List.class}})[0];
        TypeTable2<String, Boolean> tab = null;
        if (o instanceof I_Atomic) {
            tab = ConvertString.splitToTable(this.value, o.toString());
        } else if (o instanceof JMo_List) {
            JMo_List delimiters = (JMo_List)o;
            SimpleList<String> al = new SimpleList<String>(((SimpleList)delimiters.getInternalCollection()).size());
            for (I_Object delimiter : delimiters.getInternalCollection()) {
                if (!(delimiter instanceof I_Atomic)) {
                    throw new RuntimeError(cr, "Non-Atomic Delimiter", "Got: " + Lib_Type.getName(delimiter.getClass(), delimiter));
                }
                al.add(Lib_Convert.getStringValue(cr, delimiter));
            }
            tab = ConvertString.splitToTable(this.value, al.toArray((T[])new String[al.size()]));
        } else {
            throw Err.todo(o);
        }
        I_Collection<String> data = tab.getColumn0();
        SimpleList<I_Object> newList = new SimpleList<I_Object>(data.size());
        for (String s : data) {
            newList.add(new Str(s));
        }
        return new JMo_List(newList);
    }

    private Str mStartPos(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int begin = Lib_Convert.getIntValue(cr, arg);
        if (begin == 0) {
            throw new RuntimeError(cr, "Invalid position in string", "Position can't be 0");
        }
        if (begin < 0) {
            begin = this.value.length() + begin + 1;
        }
        if (begin < 1 || begin > this.value.length()) {
            return new Str("");
        }
        String s = this.value.substring(begin - 1);
        return new Str(s);
    }

    private Bool mStartsWith(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            String s = Lib_Convert.getStringValue(cr, cr.argType(o, I_Atomic.class));
            if (this.value.startsWith(s)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private Str mSubtract(CallRuntime cr) {
        I_Object o = cr.args(this, I_Object.class)[0];
        return new Str(this.value.replace(Lib_Convert.getStringValue(cr, o), ""));
    }

    private JMo_Table mTable(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Atomic.class)[0];
        String delimiter = Lib_Convert.getStringValue(cr, arg);
        String[] lines = this.value.split("\n");
        int len = lines.length;
        String[][] splitLines = new String[len][0];
        int i = 0;
        while (i < len) {
            splitLines[i] = ConvertString.toStringArray(delimiter, lines[i]);
            ++i;
        }
        int max_width = 1;
        int i2 = 0;
        while (i2 < len) {
            max_width = Math.max(splitLines[i2].length, max_width);
            ++i2;
        }
        ArrayTable<I_Object> tab = new ArrayTable<I_Object>(max_width);
        int r = 0;
        while (r < len) {
            I_Object[] row = new I_Object[max_width];
            int c = 0;
            while (c < max_width) {
                row[c] = splitLines[r].length - 1 >= c ? new Str(splitLines[r][c]) : new Str("");
                ++c;
            }
            tab.add((T[])row);
            ++r;
        }
        return new JMo_Table(tab);
    }

    private Str mTillFirst(CallRuntime cr, boolean withDelimiter) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int idx = -1;
        int dlen = 0;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, arg);
            int idx2 = this.value.indexOf(delimiter);
            if (idx2 >= 0 && (idx == -1 || idx2 < idx)) {
                idx = idx2;
                dlen = delimiter.length();
            }
            ++n2;
        }
        if (!withDelimiter) {
            dlen = 0;
        }
        return idx >= 0 ? new Str(this.value.substring(0, idx + dlen)) : this;
    }

    private Str mTillLast(CallRuntime cr, boolean withDelimiter) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int idx = -1;
        int dlen = 0;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, arg);
            int idx2 = this.value.lastIndexOf(delimiter);
            if (idx2 >= 0 && (idx == -1 || idx2 > idx)) {
                idx = idx2;
                dlen = delimiter.length();
            }
            ++n2;
        }
        if (!withDelimiter) {
            dlen = 0;
        }
        return idx >= 0 ? new Str(this.value.substring(0, idx + dlen)) : this;
    }

    private JMo_ByteArray mToByteArray(CallRuntime cr) {
        cr.argsNone();
        byte[] ba = this.value.getBytes(StandardCharsets.UTF_8);
        return new JMo_ByteArray(ba);
    }

    private JMo_List mToChars(CallRuntime cr) {
        cr.argsNone();
        char[] ca = this.value.toCharArray();
        SimpleList<I_Object> al = new SimpleList<I_Object>(ca.length);
        char[] cArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            al.add(new Char(c));
            ++n2;
        }
        return new JMo_List(al);
    }

    private Str mTrim(CallRuntime cr, boolean left, boolean right) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        if (args.length == 0) {
            String s = FilterString.trim(this.value, left, right);
            return new Str(s);
        }
        char[] ca = new char[args.length];
        int i = 0;
        while (i < args.length) {
            ca[i] = ((Char)cr.argType(args[i], Char.class)).getValue().charValue();
            ++i;
        }
        String s = FilterString.trim(this.value, ca, left, right);
        return new Str(s);
    }

    private I_Object mUnescape(CallRuntime cr) {
        cr.argsNone();
        return new Str(FormString.unescapeSpecialChars(this.value));
    }

    private Str mUnique(CallRuntime cr) {
        cr.argsNone();
        StringBuilder sb = new StringBuilder(this.value.length());
        int p = 0;
        while (p < this.value.length()) {
            char search = this.value.charAt(p);
            boolean okay = true;
            int q = 0;
            while (q < p) {
                if (this.value.charAt(q) == search) {
                    okay = false;
                    break;
                }
                ++q;
            }
            if (okay) {
                sb.append(search);
            }
            ++p;
        }
        return new Str(sb.toString());
    }

    private I_Object mUnite(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        String temp = this.value;
        if (args.length == 0) {
            temp = FilterString.uniteDoubles(temp);
        } else {
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object arg = i_ObjectArray[n2];
                Char o = (Char)cr.argType(arg, Char.class);
                char c = o.getValue().charValue();
                temp = FilterString.uniteDoubles(c, temp);
                ++n2;
            }
        }
        return new Str(temp);
    }

    private I_Object mUnquote(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        int pari = 0;
        if (args.length == 1) {
            I_Object arg = cr.argType(args[0], A_IntNumber.class);
            pari = Lib_Convert.getIntValue(cr, arg);
        }
        char[] trimChars = new char[]{'\t', ' '};
        int valueLen = this.value.length();
        int spaceLeft = valueLen - FilterString.trim(this.value, trimChars, true, false).length();
        int spaceRight = valueLen - FilterString.trim(this.value, trimChars, false, true).length();
        String trimmed = this.value.substring(spaceLeft, valueLen - spaceRight);
        String left = this.value.substring(0, spaceLeft);
        String right = this.value.substring(valueLen - spaceRight, valueLen);
        StringBuilder sb = new StringBuilder(this.value.length());
        sb.append(left);
        switch (pari) {
            case 0: {
                String s = FormString.unquote(trimmed, '\'', '\\');
                s = FormString.unquote(s, '\"', '\\');
                sb.append(s);
                break;
            }
            case 1: {
                sb.append(FormString.unquote(trimmed, '\'', '\\'));
                break;
            }
            case 2: {
                sb.append(FormString.unquote(trimmed, '\"', '\\'));
                break;
            }
            case 3: {
                sb.append(FormString.unquote(trimmed, '\'', '\''));
                break;
            }
            case 4: {
                sb.append(FormString.unquote(trimmed, '\"', '\"'));
                break;
            }
            default: {
                throw new RuntimeError(cr, "Invalid quote format", "Allowed are 0-4, but got: " + pari);
            }
        }
        sb.append(right);
        return new Str(sb.toString());
    }

    private Str mWidth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int width = Lib_Convert.getIntValue(cr, arg);
        Lib_Error.ifTooSmall(cr, 0L, width);
        int len = this.value.length();
        if (len == width) {
            return this;
        }
        if (len > width) {
            return new Str(this.value.substring(0, width));
        }
        return new Str(String.valueOf(this.value) + Lib_String.sequence(' ', (long)(width - len)));
    }

    private JMo_List mWords(CallRuntime cr) {
        cr.argsNone();
        Iterable<String> words = ConvertString.toWords(this.value);
        JMo_List result = new JMo_List();
        for (String s : words) {
            result.internalAdd(new Str(s));
        }
        return result;
    }
}

